/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.bff.javampd.MPDException;
import org.bff.javampd.server.PropertyLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MPDProperties
implements PropertyLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MPDProperties.class);
    private Properties prop = new Properties();
    private static final String PROP_FILE = "/mpd.properties";
    private static final String PROP_OVERRIDE_FILE = "/javampd.properties";

    protected MPDProperties() {
        this.loadValues(PROP_FILE);
        this.loadOverrideValues();
    }

    @Override
    public String getPropertyString(String property) {
        return this.prop.getProperty(property);
    }

    protected void loadValues(String propertiesResourceLocation) {
        try (InputStream is = MPDProperties.class.getResourceAsStream(propertiesResourceLocation);){
            this.loadProperties(is);
        }
        catch (IOException | NullPointerException e) {
            LOGGER.error("Could not load properties values", (Throwable)e);
            throw new MPDException("Could not load mpd properties", e);
        }
    }

    protected void loadOverrideValues() {
        try (InputStream is = MPDProperties.class.getResourceAsStream(PROP_OVERRIDE_FILE);){
            this.loadProperties(is);
        }
        catch (IOException | NullPointerException e) {
            LOGGER.info("Override properties file not on classpath", (Throwable)e);
        }
    }

    protected void loadProperties(InputStream inputStream) throws IOException {
        this.prop.load(inputStream);
    }
}

