/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.server;

import org.bff.javampd.server.MPDProperties;

public class ServerProperties
extends MPDProperties {
    public String getClearError() {
        return this.getResponseCommand(Command.CLEARERROR);
    }

    public String getStatus() {
        return this.getResponseCommand(Command.STATUS);
    }

    public String getStats() {
        return this.getResponseCommand(Command.STATS);
    }

    public String getPing() {
        return this.getResponseCommand(Command.PING);
    }

    public String getPassword() {
        return this.getResponseCommand(Command.PASSWORD);
    }

    public String getClose() {
        return this.getResponseCommand(Command.CLOSE);
    }

    public String getStartBulk() {
        return this.getResponseCommand(Command.STARTBULK);
    }

    public String getEndBulk() {
        return this.getResponseCommand(Command.ENDBULK);
    }

    private String getResponseCommand(Command command) {
        return this.getPropertyString(command.getKey());
    }

    public String getEncoding() {
        return this.getResponseCommand(Command.SERVERENCODING);
    }

    private static enum Command {
        SERVERENCODING("server.encoding"),
        CLEARERROR("cmd.clear.error"),
        CLOSE("cmd.close"),
        KILL("cmd.kill"),
        STATUS("cmd.status"),
        STATS("cmd.statistics"),
        STARTBULK("cmd.start.bulk"),
        ENDBULK("cmd.end.bulk"),
        PASSWORD("cmd.password"),
        PING("cmd.ping");

        private final String key;

        private Command(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

