/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.song;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.bff.javampd.song.MPDSong;
import org.bff.javampd.song.SongConverter;
import org.bff.javampd.song.SongProcessor;

public class MPDSongConverter
implements SongConverter {
    private static String delimitingPrefix = SongProcessor.getDelimitingPrefix();

    @Override
    public List<MPDSong> convertResponseToSong(List<String> list) {
        ArrayList<MPDSong> songList = new ArrayList<MPDSong>();
        Iterator<String> iterator = list.iterator();
        String line = null;
        while (iterator.hasNext()) {
            if (line == null || !line.startsWith(delimitingPrefix)) {
                line = iterator.next();
            }
            if (!line.startsWith(delimitingPrefix)) continue;
            line = MPDSongConverter.processSong(line.substring(delimitingPrefix.length()).trim(), iterator, songList);
        }
        return songList;
    }

    private static String processSong(String file, Iterator<String> iterator, List<MPDSong> songs) {
        MPDSong song = new MPDSong(file, "");
        MPDSongConverter.initialize(song);
        String line = iterator.next();
        while (!line.startsWith(delimitingPrefix)) {
            MPDSongConverter.processLine(song, line);
            if (!iterator.hasNext()) break;
            line = iterator.next();
        }
        songs.add(song);
        return line;
    }

    private static void initialize(MPDSong song) {
        song.setName("");
        song.setAlbumName("");
        song.setArtistName("");
        song.setComment("");
        song.setDiscNumber("");
        song.setGenre("");
        song.setTitle("");
        song.setYear("");
    }

    @Override
    public List<String> getSongFileNameList(List<String> fileList) {
        String prefix = SongProcessor.FILE.getProcessor().getPrefix();
        return fileList.stream().filter(s -> s.startsWith(prefix)).map(s -> s.substring(prefix.length()).trim()).collect(Collectors.toList());
    }

    private static void processLine(MPDSong song, String line) {
        for (SongProcessor songProcessor : SongProcessor.values()) {
            songProcessor.getProcessor().processTag(song, line);
        }
    }
}

