/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.statistics;

import com.google.inject.Inject;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.List;
import org.bff.javampd.Clock;
import org.bff.javampd.command.CommandExecutor;
import org.bff.javampd.server.ServerProperties;
import org.bff.javampd.statistics.ServerStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPDServerStatistics
implements ServerStatistics {
    private static final Logger LOGGER = LoggerFactory.getLogger(MPDServerStatistics.class);
    private long expiryInterval = 60L;
    private List<String> cachedResponse;
    private Clock clock;
    private LocalDateTime responseDate;
    private ServerProperties serverProperties;
    private CommandExecutor commandExecutor;

    @Inject
    public MPDServerStatistics(ServerProperties serverProperties, CommandExecutor commandExecutor, Clock clock) {
        this.serverProperties = serverProperties;
        this.commandExecutor = commandExecutor;
        this.clock = clock;
        this.responseDate = clock.min();
    }

    private Number getStat(ServerStatistics.StatList stat) {
        LocalDateTime now = this.clock.now();
        if (now.minusSeconds(this.expiryInterval).isAfter(this.responseDate)) {
            this.responseDate = now;
            this.cachedResponse = this.commandExecutor.sendCommand(this.serverProperties.getStats());
        }
        for (String line : this.cachedResponse) {
            if (!line.startsWith(stat.getStatPrefix())) continue;
            try {
                return NumberFormat.getInstance().parse(line.substring(stat.getStatPrefix().length()).trim());
            }
            catch (ParseException e) {
                LOGGER.warn("Could not parse server statistic", (Throwable)e);
                return 0;
            }
        }
        return 0;
    }

    @Override
    public long getPlaytime() {
        return this.getStat(ServerStatistics.StatList.PLAYTIME).longValue();
    }

    @Override
    public long getUptime() {
        return this.getStat(ServerStatistics.StatList.UPTIME).longValue();
    }

    @Override
    public int getAlbumCount() {
        return this.getStat(ServerStatistics.StatList.ALBUMS).intValue();
    }

    @Override
    public int getArtistCount() {
        return this.getStat(ServerStatistics.StatList.ARTISTS).intValue();
    }

    @Override
    public int getSongCount() {
        return this.getStat(ServerStatistics.StatList.SONGS).intValue();
    }

    @Override
    public long getDatabasePlaytime() {
        return this.getStat(ServerStatistics.StatList.DBPLAYTIME).longValue();
    }

    @Override
    public long getLastUpdateTime() {
        return this.getStat(ServerStatistics.StatList.DBUPDATE).longValue();
    }

    @Override
    public void setExpiryInterval(long seconds) {
        this.expiryInterval = seconds;
    }

    @Override
    public void forceUpdate() {
        this.responseDate = this.clock.min();
    }
}

