/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.album;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bff.javampd.MPDItem;
import org.bff.javampd.album.AlbumConverter;
import org.bff.javampd.album.AlbumProcessor;
import org.bff.javampd.album.MPDAlbum;
import org.bff.javampd.artist.MPDConverter;

public class MPDAlbumConverter
extends MPDConverter
implements AlbumConverter {
    private static String delimitingPrefix = AlbumProcessor.getDelimitingPrefix();

    @Override
    public List<MPDAlbum> convertResponseToAlbum(List<String> list) {
        ArrayList<MPDAlbum> albumList = new ArrayList<MPDAlbum>();
        Iterator<String> iterator = list.iterator();
        String line = null;
        while (iterator.hasNext()) {
            if (line == null || !line.startsWith(delimitingPrefix)) {
                line = iterator.next();
            }
            while (line != null && line.startsWith(delimitingPrefix)) {
                line = this.processAlbum(line.substring(delimitingPrefix.length()).trim(), iterator, albumList);
            }
        }
        return albumList;
    }

    private String processAlbum(String name, Iterator<String> iterator, List<MPDAlbum> albums) {
        MPDAlbum album = new MPDAlbum(name);
        String line = this.processItem(album, iterator, delimitingPrefix);
        albums.add(album);
        return line;
    }

    @Override
    public void processLine(MPDItem item, String line) {
        for (AlbumProcessor albumProcessor : AlbumProcessor.values()) {
            albumProcessor.getProcessor().processTag((MPDAlbum)item, line);
        }
    }
}

