/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.album;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bff.javampd.album.AlbumConverter;
import org.bff.javampd.album.AlbumDatabase;
import org.bff.javampd.album.MPDAlbum;
import org.bff.javampd.artist.MPDArtist;
import org.bff.javampd.database.TagLister;
import org.bff.javampd.genre.MPDGenre;

public class MPDAlbumDatabase
implements AlbumDatabase {
    private TagLister tagLister;
    private AlbumConverter albumConverter;
    private static final TagLister.GroupType[] ALBUM_TAGS = new TagLister.GroupType[]{TagLister.GroupType.ARTIST, TagLister.GroupType.DATE, TagLister.GroupType.GENRE};

    @Inject
    public MPDAlbumDatabase(TagLister tagLister, AlbumConverter albumConverter) {
        this.tagLister = tagLister;
        this.albumConverter = albumConverter;
    }

    @Override
    public Collection<MPDAlbum> listAlbumsByArtist(MPDArtist artist) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(TagLister.ListType.ARTIST.getType());
        list.add(artist.getName());
        return this.convertResponseToAlbum(this.tagLister.list(TagLister.ListType.ALBUM, list, ALBUM_TAGS));
    }

    @Override
    public Collection<String> listAllAlbumNames() {
        return this.tagLister.list(TagLister.ListType.ALBUM).stream().map(s2 -> s2.substring(s2.split(":")[0].length() + 1).trim()).collect(Collectors.toList());
    }

    @Override
    public Collection<MPDAlbum> listAllAlbums() {
        return this.convertResponseToAlbum(this.tagLister.list(TagLister.ListType.ALBUM, ALBUM_TAGS));
    }

    @Override
    public Collection<MPDAlbum> listAllAlbums(int start, int end) {
        ArrayList<MPDAlbum> albums = new ArrayList<MPDAlbum>(this.listAllAlbums());
        int toIndex = Math.min(end, albums.size());
        int fromIndex = Math.min(start, end);
        return albums.subList(fromIndex, toIndex);
    }

    @Override
    public Collection<MPDAlbum> findAlbum(String albumName) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(TagLister.ListType.ALBUM.getType());
        list.add(albumName);
        return this.convertResponseToAlbum(this.tagLister.list(TagLister.ListType.ALBUM, list, ALBUM_TAGS));
    }

    @Override
    public Collection<MPDAlbum> listAlbumsByGenre(MPDGenre genre) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(TagLister.ListType.GENRE.getType());
        list.add(genre.getName());
        return this.convertResponseToAlbum(this.tagLister.list(TagLister.ListType.ALBUM, list, ALBUM_TAGS));
    }

    @Override
    public Collection<MPDAlbum> listAlbumsByYear(String year) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(TagLister.ListType.DATE.getType());
        list.add(year);
        return this.convertResponseToAlbum(this.tagLister.list(TagLister.ListType.ALBUM, list, ALBUM_TAGS));
    }

    @Override
    public Collection<String> listAlbumNamesByYear(String year) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(TagLister.ListType.DATE.getType());
        list.add(year);
        return this.tagLister.list(TagLister.ListType.ALBUM, list, new TagLister.GroupType[0]);
    }

    private Collection<MPDAlbum> convertResponseToAlbum(List<String> response) {
        return this.albumConverter.convertResponseToAlbum(response);
    }
}

