/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.artist;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bff.javampd.artist.ArtistDatabase;
import org.bff.javampd.artist.MPDArtist;
import org.bff.javampd.database.TagLister;
import org.bff.javampd.genre.MPDGenre;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPDArtistDatabase
implements ArtistDatabase {
    private static final Logger LOGGER = LoggerFactory.getLogger(MPDArtistDatabase.class);
    private TagLister tagLister;

    @Inject
    public MPDArtistDatabase(TagLister tagLister) {
        this.tagLister = tagLister;
    }

    @Override
    public Collection<MPDArtist> listAllArtists() {
        return this.tagLister.list(TagLister.ListType.ARTIST).stream().map(s2 -> new MPDArtist(MPDArtistDatabase.convertResponse(s2))).collect(Collectors.toList());
    }

    @Override
    public Collection<MPDArtist> listArtistsByGenre(MPDGenre genre) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(TagLister.ListType.GENRE.getType());
        list.add(genre.getName());
        return this.tagLister.list(TagLister.ListType.ARTIST, list, new TagLister.GroupType[0]).stream().map(s2 -> new MPDArtist(MPDArtistDatabase.convertResponse(s2))).collect(Collectors.toList());
    }

    @Override
    public MPDArtist listArtistByName(String name) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(TagLister.ListType.ARTIST.getType());
        list.add(name);
        MPDArtist artist = null;
        List artists = this.tagLister.list(TagLister.ListType.ARTIST, list, new TagLister.GroupType[0]).stream().map(s2 -> new MPDArtist(MPDArtistDatabase.convertResponse(s2))).collect(Collectors.toList());
        if (artists.size() > 1) {
            LOGGER.warn("Multiple artists returned for name {}", (Object)name);
        }
        if (!artists.isEmpty()) {
            artist = (MPDArtist)artists.get(0);
        }
        return artist;
    }

    private static String convertResponse(String s2) {
        return s2.substring(s2.split(":")[0].length() + 1).trim();
    }
}

