/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.command;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.bff.javampd.command.CommandExecutor;
import org.bff.javampd.command.MPDCommand;
import org.bff.javampd.server.MPD;
import org.bff.javampd.server.MPDConnectionException;
import org.bff.javampd.server.MPDSecurityException;
import org.bff.javampd.server.MPDSocket;
import org.bff.javampd.server.ServerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MPDCommandExecutor
implements CommandExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MPDCommandExecutor.class);
    private MPDSocket mpdSocket;
    private MPD mpd;
    private ServerProperties serverProperties = new ServerProperties();
    private String password;

    @Override
    public synchronized List<String> sendCommand(String command) {
        return this.sendCommand(new MPDCommand(command, new String[0]));
    }

    @Override
    public synchronized List<String> sendCommand(String command, String ... params) {
        return this.sendCommand(new MPDCommand(command, params));
    }

    @Override
    public synchronized List<String> sendCommand(String command, Integer ... params) {
        String[] intParms = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            intParms[i] = Integer.toString(params[i]);
        }
        return new ArrayList<String>(this.sendCommand(new MPDCommand(command, intParms)));
    }

    public synchronized List<String> sendCommand(MPDCommand command) {
        try {
            this.checkSocket();
            return new ArrayList<String>(this.mpdSocket.sendCommand(command));
        }
        catch (MPDSecurityException se) {
            LOGGER.warn("Connection exception while sending command {}, will retry", (Object)command.getCommand(), (Object)se);
            this.authenticate();
            return new ArrayList<String>(this.mpdSocket.sendCommand(command));
        }
    }

    @Override
    public synchronized void sendCommands(List<MPDCommand> commandList) {
        try {
            this.checkSocket();
            this.mpdSocket.sendCommands(commandList);
        }
        catch (MPDSecurityException se) {
            LOGGER.warn("Connection exception while sending commands, will retry", se);
            this.authenticate();
            this.mpdSocket.sendCommands(commandList);
        }
    }

    private void checkSocket() {
        if (this.mpd == null) {
            throw new MPDConnectionException("Socket could not be established.  Was mpd set?");
        }
        if (this.mpdSocket == null) {
            this.mpdSocket = this.createSocket();
        }
    }

    @Override
    public String getMPDVersion() {
        this.checkSocket();
        return this.mpdSocket.getVersion();
    }

    @Override
    public void setMpd(MPD mpd) {
        this.mpd = mpd;
    }

    @Override
    public void authenticate() {
        if (this.password != null) {
            try {
                this.sendCommand(new MPDCommand(this.serverProperties.getPassword(), this.password));
            }
            catch (Exception e) {
                LOGGER.error("Error authenticating to mpd", e);
                if (e.getMessage() != null && e.getMessage().contains("incorrect password")) {
                    throw new MPDSecurityException("Incorrect password");
                }
                throw new MPDConnectionException("Could not authenticate", e);
            }
        }
    }

    @Override
    public void usePassword(String password) {
        if (password == null || password.isEmpty()) {
            throw new IllegalArgumentException("Password cannot be null or empty");
        }
        this.password = password;
    }

    @Override
    public void close() {
        this.mpdSocket.close();
    }

    protected MPDSocket createSocket() {
        return new MPDSocket(this.mpd.getAddress(), this.mpd.getPort(), this.mpd.getTimeout());
    }
}

