/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.monitor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bff.javampd.admin.Admin;
import org.bff.javampd.monitor.OutputMonitor;
import org.bff.javampd.output.MPDOutput;
import org.bff.javampd.output.OutputChangeEvent;
import org.bff.javampd.output.OutputChangeListener;

@Singleton
public class MPDOutputMonitor
implements OutputMonitor {
    private Map<Integer, MPDOutput> outputMap;
    private List<OutputChangeListener> outputListeners;
    private Admin admin;

    @Inject
    MPDOutputMonitor(Admin admin) {
        this.admin = admin;
        this.outputMap = new HashMap<Integer, MPDOutput>();
        this.outputListeners = new ArrayList<OutputChangeListener>();
    }

    @Override
    public void checkStatus() {
        ArrayList<MPDOutput> outputs = new ArrayList<MPDOutput>(this.admin.getOutputs());
        if (outputs.size() > this.outputMap.size()) {
            this.fireOutputChangeEvent(new OutputChangeEvent(this, OutputChangeEvent.OUTPUT_EVENT.OUTPUT_ADDED));
            this.loadOutputs(outputs);
        } else if (outputs.size() < this.outputMap.size()) {
            this.fireOutputChangeEvent(new OutputChangeEvent(this, OutputChangeEvent.OUTPUT_EVENT.OUTPUT_DELETED));
            this.loadOutputs(outputs);
        } else {
            this.compareOutputs(outputs);
        }
    }

    private void compareOutputs(List<MPDOutput> outputs) {
        for (MPDOutput output : outputs) {
            MPDOutput mpdOutput = this.outputMap.get(output.getId());
            if (mpdOutput.isEnabled() == output.isEnabled()) continue;
            this.fireOutputChangeEvent(new OutputChangeEvent(output, OutputChangeEvent.OUTPUT_EVENT.OUTPUT_CHANGED));
            this.loadOutputs(outputs);
            return;
        }
    }

    @Override
    public synchronized void addOutputChangeListener(OutputChangeListener vcl) {
        this.outputListeners.add(vcl);
    }

    @Override
    public synchronized void removeOutputChangeListener(OutputChangeListener vcl) {
        this.outputListeners.remove(vcl);
    }

    protected synchronized void fireOutputChangeEvent(OutputChangeEvent event) {
        for (OutputChangeListener ocl : this.outputListeners) {
            ocl.outputChanged(event);
        }
    }

    private void loadOutputs(Collection<MPDOutput> outputs) {
        this.outputMap.clear();
        for (MPDOutput output : outputs) {
            this.outputMap.put(output.getId(), output);
        }
    }
}

