/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.monitor;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.bff.javampd.monitor.MPDBitrateMonitor;
import org.bff.javampd.monitor.PlayerMonitor;
import org.bff.javampd.monitor.PlayerStatus;
import org.bff.javampd.monitor.StandAloneMonitor;
import org.bff.javampd.player.PlayerBasicChangeEvent;
import org.bff.javampd.player.PlayerBasicChangeListener;
import org.bff.javampd.server.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MPDPlayerMonitor
extends MPDBitrateMonitor
implements PlayerMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MPDPlayerMonitor.class);
    private PlayerStatus status = PlayerStatus.STATUS_STOPPED;
    private List<PlayerBasicChangeListener> playerListeners = new ArrayList<PlayerBasicChangeListener>();
    private String state = "";

    MPDPlayerMonitor() {
    }

    @Override
    public void processResponseStatus(String line) {
        super.processResponseStatus(line);
        if (Status.lookupStatus(line) == Status.STATE) {
            this.state = line.substring(Status.STATE.getStatusPrefix().length()).trim();
        }
    }

    @Override
    public void checkStatus() {
        super.checkStatus();
        PlayerStatus newStatus = null;
        if (this.state.startsWith(StandAloneMonitor.PlayerResponse.PLAY.getPrefix())) {
            newStatus = PlayerStatus.STATUS_PLAYING;
        } else if (this.state.startsWith(StandAloneMonitor.PlayerResponse.PAUSE.getPrefix())) {
            newStatus = PlayerStatus.STATUS_PAUSED;
        } else if (this.state.startsWith(StandAloneMonitor.PlayerResponse.STOP.getPrefix())) {
            newStatus = PlayerStatus.STATUS_STOPPED;
        }
        if (!this.status.equals((Object)newStatus)) {
            this.processNewStatus(newStatus);
            this.status = newStatus;
        }
    }

    private void processNewStatus(PlayerStatus newStatus) {
        LOGGER.debug("status change from {} to {}", (Object)this.status, (Object)newStatus);
        if (newStatus == PlayerStatus.STATUS_PLAYING) {
            this.processPlayingStatus(this.status);
        } else if (newStatus == PlayerStatus.STATUS_STOPPED) {
            this.firePlayerChangeEvent(PlayerBasicChangeEvent.Status.PLAYER_STOPPED);
        } else if (newStatus == PlayerStatus.STATUS_PAUSED) {
            this.processPausedStatus(this.status);
        }
    }

    @Override
    public synchronized void addPlayerChangeListener(PlayerBasicChangeListener pcl) {
        this.playerListeners.add(pcl);
    }

    @Override
    public synchronized void removePlayerChangeListener(PlayerBasicChangeListener pcl) {
        this.playerListeners.remove(pcl);
    }

    @Override
    public PlayerStatus getStatus() {
        return this.status;
    }

    @Override
    public void reset() {
        this.state = "";
        this.status = PlayerStatus.STATUS_STOPPED;
    }

    protected synchronized void firePlayerChangeEvent(PlayerBasicChangeEvent.Status status) {
        PlayerBasicChangeEvent pce = new PlayerBasicChangeEvent(this, status);
        for (PlayerBasicChangeListener pcl : this.playerListeners) {
            pcl.playerBasicChange(pce);
        }
    }

    private void processPlayingStatus(PlayerStatus oldStatus) {
        if (oldStatus == PlayerStatus.STATUS_PAUSED) {
            this.firePlayerChangeEvent(PlayerBasicChangeEvent.Status.PLAYER_UNPAUSED);
        } else if (oldStatus == PlayerStatus.STATUS_STOPPED) {
            this.firePlayerChangeEvent(PlayerBasicChangeEvent.Status.PLAYER_STARTED);
        }
    }

    private void processPausedStatus(PlayerStatus oldStatus) {
        if (oldStatus == PlayerStatus.STATUS_PLAYING) {
            this.firePlayerChangeEvent(PlayerBasicChangeEvent.Status.PLAYER_PAUSED);
        } else if (oldStatus == PlayerStatus.STATUS_STOPPED) {
            this.firePlayerChangeEvent(PlayerBasicChangeEvent.Status.PLAYER_STOPPED);
        }
    }
}

