/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.monitor;

import com.google.inject.Singleton;
import org.bff.javampd.monitor.VolumeMonitor;
import org.bff.javampd.player.VolumeChangeDelegate;
import org.bff.javampd.player.VolumeChangeListener;
import org.bff.javampd.server.Status;

@Singleton
public class MPDVolumeMonitor
implements VolumeMonitor {
    private int newVolume;
    private int oldVolume;
    private VolumeChangeDelegate volumeChangeDelegate = new VolumeChangeDelegate();

    MPDVolumeMonitor() {
    }

    @Override
    public void processResponseStatus(String line) {
        if (Status.lookupStatus(line) == Status.VOLUME) {
            this.newVolume = Integer.parseInt(line.substring(Status.VOLUME.getStatusPrefix().length()).trim());
        }
    }

    @Override
    public void reset() {
        this.newVolume = 0;
        this.oldVolume = 0;
    }

    @Override
    public void checkStatus() {
        if (this.oldVolume != this.newVolume) {
            this.fireVolumeChangeEvent(this.newVolume);
            this.oldVolume = this.newVolume;
        }
    }

    @Override
    public synchronized void addVolumeChangeListener(VolumeChangeListener vcl) {
        this.volumeChangeDelegate.addVolumeChangeListener(vcl);
    }

    @Override
    public synchronized void removeVolumeChangeListener(VolumeChangeListener vcl) {
        this.volumeChangeDelegate.removeVolumeChangedListener(vcl);
    }

    protected synchronized void fireVolumeChangeEvent(int volume) {
        this.volumeChangeDelegate.fireVolumeChangeEvent(this, volume);
    }
}

