/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.playlist;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bff.javampd.command.CommandExecutor;
import org.bff.javampd.database.DatabaseProperties;
import org.bff.javampd.database.TagLister;
import org.bff.javampd.playlist.MPDSavedPlaylist;
import org.bff.javampd.playlist.PlaylistDatabase;
import org.bff.javampd.song.MPDSong;
import org.bff.javampd.song.SongConverter;
import org.bff.javampd.song.SongDatabase;

public class MPDPlaylistDatabase
implements PlaylistDatabase {
    private SongDatabase songDatabase;
    private CommandExecutor commandExecutor;
    private DatabaseProperties databaseProperties;
    private TagLister tagLister;
    private SongConverter songConverter;

    @Inject
    public MPDPlaylistDatabase(SongDatabase songDatabase, CommandExecutor commandExecutor, DatabaseProperties databaseProperties, TagLister tagLister, SongConverter songConverter) {
        this.songDatabase = songDatabase;
        this.commandExecutor = commandExecutor;
        this.databaseProperties = databaseProperties;
        this.tagLister = tagLister;
        this.songConverter = songConverter;
    }

    @Override
    public Collection<MPDSavedPlaylist> listSavedPlaylists() {
        ArrayList<MPDSavedPlaylist> playlists = new ArrayList<MPDSavedPlaylist>();
        for (String s2 : this.listPlaylists()) {
            MPDSavedPlaylist playlist = new MPDSavedPlaylist(s2);
            playlist.setSongs(this.listPlaylistSongs(s2));
            playlists.add(playlist);
        }
        return playlists;
    }

    @Override
    public Collection<String> listPlaylists() {
        return this.tagLister.listInfo(TagLister.ListInfoType.PLAYLIST);
    }

    @Override
    public Collection<MPDSong> listPlaylistSongs(String playlistName) {
        List<String> response = this.commandExecutor.sendCommand(this.databaseProperties.getListSongs(), playlistName);
        List<MPDSong> songList = this.songConverter.getSongFileNameList(response).stream().map(song -> new ArrayList<MPDSong>(this.songDatabase.searchFileName((String)song))).filter(Predicate.not(Collection::isEmpty)).map(col -> (MPDSong)col.get(0)).collect(Collectors.toList());
        songList.addAll(this.songConverter.getSongFileNameList(response).stream().filter(song -> Pattern.compile("http.+").matcher(song.toLowerCase()).matches()).map(song -> new MPDSong((String)song, (String)song)).collect(Collectors.toList()));
        return songList;
    }

    @Override
    public int countPlaylistSongs(String playlistName) {
        List<String> response = this.commandExecutor.sendCommand(this.databaseProperties.getListSongs(), playlistName);
        return response.size();
    }
}

