/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.server;

import com.google.inject.Inject;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import javax.inject.Singleton;
import org.bff.javampd.Clock;
import org.bff.javampd.command.CommandExecutor;
import org.bff.javampd.server.ServerProperties;
import org.bff.javampd.server.ServerStatus;
import org.bff.javampd.server.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MPDServerStatus
implements ServerStatus {
    private static final Logger LOGGER = LoggerFactory.getLogger(MPDServerStatus.class);
    private long expiryInterval = 5L;
    private List<String> cachedResponse;
    private Clock clock;
    private LocalDateTime responseDate;
    private ServerProperties serverProperties;
    private CommandExecutor commandExecutor;

    @Inject
    public MPDServerStatus(ServerProperties serverProperties, CommandExecutor commandExecutor, Clock clock) {
        this.serverProperties = serverProperties;
        this.commandExecutor = commandExecutor;
        this.clock = clock;
        this.responseDate = clock.min();
    }

    protected String getStatus(Status status) {
        LocalDateTime now = this.clock.now();
        if (now.minusSeconds(this.expiryInterval).isAfter(this.responseDate)) {
            this.responseDate = now;
            this.cachedResponse = this.commandExecutor.sendCommand(this.serverProperties.getStatus());
        }
        for (String line : this.cachedResponse) {
            if (!line.startsWith(status.getStatusPrefix())) continue;
            return line.substring(status.getStatusPrefix().length()).trim();
        }
        LOGGER.warn("Response did not contain status {}", (Object)status.getStatusPrefix());
        return "";
    }

    @Override
    public Collection<String> getStatus() {
        return this.commandExecutor.sendCommand(this.serverProperties.getStatus());
    }

    @Override
    public int getPlaylistVersion() {
        String version = this.getStatus(Status.PLAYLIST);
        try {
            return Integer.parseInt("".equals(version) ? "0" : version);
        }
        catch (NumberFormatException nfe) {
            LOGGER.error("Could not format playlist version response {}", (Object)version, (Object)nfe);
            return 0;
        }
    }

    @Override
    public String getState() {
        return this.getStatus(Status.STATE);
    }

    @Override
    public int getXFade() {
        String xFade = this.getStatus(Status.XFADE);
        try {
            return Integer.parseInt("".equals(xFade) ? "0" : xFade);
        }
        catch (NumberFormatException nfe) {
            LOGGER.error("Could not format xfade response {}", (Object)xFade, (Object)nfe);
            return 0;
        }
    }

    @Override
    public String getAudio() {
        return this.getStatus(Status.AUDIO);
    }

    @Override
    public boolean isError() {
        return !"".equals(this.getStatus(Status.ERROR));
    }

    @Override
    public String getError() {
        return this.getStatus(Status.ERROR);
    }

    @Override
    public long getElapsedTime() {
        return this.lookupTime(TimeType.ELAPSED);
    }

    @Override
    public long getTotalTime() {
        return this.lookupTime(TimeType.TOTAL);
    }

    @Override
    public int getBitrate() {
        String bitrate = this.getStatus(Status.BITRATE);
        try {
            return Integer.parseInt("".equals(bitrate) ? "0" : bitrate);
        }
        catch (NumberFormatException nfe) {
            LOGGER.error("Could not format bitrate response {}", (Object)bitrate, (Object)nfe);
            return 0;
        }
    }

    @Override
    public int getVolume() {
        String volume = this.getStatus(Status.VOLUME);
        try {
            return Integer.parseInt("".equals(volume) ? "0" : volume);
        }
        catch (NumberFormatException nfe) {
            LOGGER.error("Could not format volume response {}", (Object)volume, (Object)nfe);
            return 0;
        }
    }

    @Override
    public boolean isRepeat() {
        return "1".equals(this.getStatus(Status.REPEAT));
    }

    @Override
    public boolean isRandom() {
        return "1".equals(this.getStatus(Status.RANDOM));
    }

    @Override
    public boolean isDatabaseUpdating() {
        return !"".equals(this.getStatus(Status.UPDATINGDB));
    }

    @Override
    public boolean isConsume() {
        return "1".equals(this.getStatus(Status.CONSUME));
    }

    @Override
    public boolean isSingle() {
        return "1".equals(this.getStatus(Status.SINGLE));
    }

    @Override
    public void setExpiryInterval(long seconds) {
        this.expiryInterval = seconds;
    }

    @Override
    public void forceUpdate() {
        this.responseDate = this.clock.min();
    }

    private long lookupTime(TimeType type) {
        String time = this.getStatus(Status.TIME);
        if ("".equals(time) || !time.contains(":")) {
            return 0L;
        }
        try {
            return Integer.parseInt(time.trim().split(":")[type.getIndex()]);
        }
        catch (NumberFormatException nfe) {
            LOGGER.error("Could not format time {}", (Object)time, (Object)nfe);
            return 0L;
        }
    }

    private static enum TimeType {
        ELAPSED(0),
        TOTAL(1);

        private int index;

        private TimeType(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

