/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.server;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Status {
    VOLUME("volume:"),
    REPEAT("repeat:"),
    RANDOM("random:"),
    PLAYLIST("playlist:"),
    PLAYLISTLENGTH("playlistlength:"),
    STATE("state:"),
    CURRENTSONG("song:"),
    CURRENTSONGID("songid:"),
    TIME("time:"),
    BITRATE("bitrate:"),
    XFADE("xfade:"),
    AUDIO("audio:"),
    UPDATINGDB("updating_db:"),
    ERROR("error:"),
    CONSUME("consume:"),
    SINGLE("single:"),
    UNKNOWN("unknown");

    private String prefix;
    private static final Logger LOGGER;

    private Status(String prefix) {
        this.prefix = prefix;
    }

    public String getStatusPrefix() {
        return this.prefix;
    }

    public static Status lookupStatus(String statusLine) {
        for (Status status : Status.values()) {
            if (!statusLine.startsWith(status.getStatusPrefix())) continue;
            return status;
        }
        LOGGER.warn("Unknown status {} returned", (Object)statusLine);
        return UNKNOWN;
    }

    static {
        LOGGER = LoggerFactory.getLogger(Status.class);
    }
}

