/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.song;

import org.bff.javampd.MPDItem;

public class MPDSong
extends MPDItem {
    private String title;
    private String artistName;
    private String albumName;
    private String file;
    private String genre;
    private String comment;
    private String year;
    private String discNumber;
    private int length;
    private int track;
    private int position = -1;
    private int id = -1;

    public MPDSong(String file, String title) {
        super(title);
        this.title = title;
        this.file = file;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getArtistName() {
        return this.artistName;
    }

    public void setArtistName(String artistName) {
        this.artistName = artistName;
    }

    public String getAlbumName() {
        return this.albumName;
    }

    public void setAlbumName(String albumName) {
        this.albumName = albumName;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String path) {
        this.file = path;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getTrack() {
        return this.track;
    }

    public void setTrack(int track) {
        this.track = track;
    }

    public String getGenre() {
        return this.genre;
    }

    public void setGenre(String genre) {
        this.genre = genre;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    @Override
    public String toString() {
        return this.getFile();
    }

    public int getPosition() {
        return this.position;
    }

    public int getId() {
        return this.id;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getDiscNumber() {
        return this.discNumber;
    }

    public void setDiscNumber(String discNumber) {
        this.discNumber = discNumber;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        MPDSong song = (MPDSong)object;
        return this.getFile().equals(song.getFile());
    }

    @Override
    public String getName() {
        if (super.getName() == null || "".equals(super.getName())) {
            return this.getTitle();
        }
        return super.getName();
    }

    @Override
    public int hashCode() {
        return this.getTitle() != null ? this.getTitle().hashCode() : 0;
    }

    @Override
    public int compareTo(MPDItem item) {
        MPDSong song = (MPDSong)item;
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(this.getAlbumName() == null ? "" : this.getAlbumName());
        sb.append(MPDSong.formatToComparableString(this.getTrack()));
        String thisSong = sb.toString();
        sb = new StringBuilder(song.getName());
        sb.append(song.getAlbumName() == null ? "" : song.getAlbumName());
        sb.append(MPDSong.formatToComparableString(song.getTrack()));
        String songToCompare = sb.toString();
        return thisSong.compareTo(songToCompare);
    }

    private static String formatToComparableString(int i) {
        return String.format("%1$08d", i);
    }
}

