/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.song;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.bff.javampd.album.MPDAlbum;
import org.bff.javampd.artist.MPDArtist;
import org.bff.javampd.genre.MPDGenre;
import org.bff.javampd.song.MPDSong;
import org.bff.javampd.song.SongDatabase;
import org.bff.javampd.song.SongSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPDSongDatabase
implements SongDatabase {
    private static final Logger LOGGER = LoggerFactory.getLogger(MPDSongDatabase.class);
    private SongSearcher songSearcher;

    @Inject
    public MPDSongDatabase(SongSearcher songSearcher) {
        this.songSearcher = songSearcher;
    }

    @Override
    public Collection<MPDSong> findAlbum(MPDAlbum album) {
        return this.findAlbum(album.getName());
    }

    @Override
    public Collection<MPDSong> findAlbum(String album) {
        return this.songSearcher.find(SongSearcher.ScopeType.ALBUM, album);
    }

    @Override
    public Collection<MPDSong> findAlbumByArtist(MPDArtist artist, MPDAlbum album) {
        return this.findAlbumByArtist(artist.getName(), album.getName());
    }

    @Override
    public Collection<MPDSong> findAlbumByArtist(String artistName, String albumName) {
        ArrayList<MPDSong> songList = new ArrayList<MPDSong>(this.songSearcher.find(SongSearcher.ScopeType.ALBUM, albumName));
        return songList.stream().filter(song -> song.getArtistName() != null && song.getArtistName().equals(artistName)).collect(Collectors.toList());
    }

    @Override
    public Collection<MPDSong> findAlbumByGenre(MPDGenre genre, MPDAlbum album) {
        ArrayList<MPDSong> songList = new ArrayList<MPDSong>(this.songSearcher.find(SongSearcher.ScopeType.ALBUM, album.getName()));
        return songList.stream().filter(song -> song.getGenre() != null && song.getGenre().equals(genre.getName())).collect(Collectors.toList());
    }

    @Override
    public Collection<MPDSong> findAlbumByYear(String year, MPDAlbum album) {
        ArrayList<MPDSong> songList = new ArrayList<MPDSong>(this.songSearcher.find(SongSearcher.ScopeType.ALBUM, album.getName()));
        return songList.stream().filter(song -> song.getYear() != null && song.getYear().equals(year)).collect(Collectors.toList());
    }

    @Override
    public Collection<MPDSong> searchAlbum(MPDAlbum album) {
        return this.searchAlbum(album.getName());
    }

    @Override
    public Collection<MPDSong> searchAlbum(String album) {
        return this.songSearcher.search(SongSearcher.ScopeType.ALBUM, album);
    }

    @Override
    public Collection<MPDSong> findArtist(MPDArtist artist) {
        return this.findArtist(artist.getName());
    }

    @Override
    public Collection<MPDSong> findArtist(String artist) {
        return this.songSearcher.find(SongSearcher.ScopeType.ARTIST, artist);
    }

    @Override
    public Collection<MPDSong> searchArtist(MPDArtist artist) {
        return this.searchArtist(artist.getName());
    }

    @Override
    public Collection<MPDSong> searchArtist(String artist) {
        return this.songSearcher.search(SongSearcher.ScopeType.ARTIST, artist);
    }

    @Override
    public Collection<MPDSong> findYear(String year) {
        return this.songSearcher.find(SongSearcher.ScopeType.DATE, year);
    }

    @Override
    public Collection<MPDSong> findTitle(String title) {
        return this.songSearcher.find(SongSearcher.ScopeType.TITLE, title);
    }

    @Override
    public Collection<MPDSong> findAny(String criteria) {
        return this.songSearcher.find(SongSearcher.ScopeType.ANY, criteria);
    }

    @Override
    public Collection<MPDSong> searchTitle(String title) {
        return this.songSearcher.search(SongSearcher.ScopeType.TITLE, title);
    }

    @Override
    public Collection<MPDSong> searchAny(String criteria) {
        return this.songSearcher.search(SongSearcher.ScopeType.ANY, criteria);
    }

    @Override
    public Collection<MPDSong> searchTitle(String title, int startYear, int endYear) {
        ArrayList<MPDSong> retList = new ArrayList<MPDSong>();
        for (MPDSong song : this.songSearcher.search(SongSearcher.ScopeType.TITLE, title)) {
            if (song.getYear() == null) continue;
            try {
                int year = song.getYear().contains("-") ? Integer.parseInt(song.getYear().split("-")[0]) : Integer.parseInt(song.getYear());
                if (year < startYear || year > endYear) continue;
                retList.add(song);
            }
            catch (Exception e) {
                LOGGER.error("Problem searching for title", e);
            }
        }
        return retList;
    }

    @Override
    public Collection<MPDSong> searchFileName(String fileName) {
        return this.songSearcher.search(SongSearcher.ScopeType.FILENAME, MPDSongDatabase.removeSlashes(fileName));
    }

    @Override
    public Collection<MPDSong> findGenre(MPDGenre genre) {
        return this.findGenre(genre.getName());
    }

    @Override
    public Collection<MPDSong> findGenre(String genre) {
        return this.songSearcher.find(SongSearcher.ScopeType.GENRE, genre);
    }

    @Override
    public MPDSong findSong(String name, String album, String artist) {
        ArrayList<MPDSong> songs = new ArrayList<MPDSong>(this.songSearcher.find(SongSearcher.ScopeType.ALBUM, album));
        for (MPDSong song : songs) {
            if (!artist.equals(song.getArtistName())) continue;
            return song;
        }
        LOGGER.info("Song not found title --> {}, artist --> {}, album --> {}", name, artist, album);
        return null;
    }

    private static String removeSlashes(String path) {
        String retString = path;
        String slash = System.getProperty("file.separator");
        retString = retString.replace(slash, "/");
        retString = retString.replaceFirst("^/", "");
        retString = retString.replaceFirst("/$", "");
        return retString;
    }
}

