/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.song;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import org.bff.javampd.command.CommandExecutor;
import org.bff.javampd.song.MPDSong;
import org.bff.javampd.song.SearchProperties;
import org.bff.javampd.song.SongConverter;
import org.bff.javampd.song.SongSearcher;

public class MPDSongSearcher
implements SongSearcher {
    private SearchProperties searchProperties;
    private CommandExecutor commandExecutor;
    private SongConverter songConverter;

    @Inject
    public MPDSongSearcher(SearchProperties searchProperties, CommandExecutor commandExecutor, SongConverter songConverter) {
        this.searchProperties = searchProperties;
        this.commandExecutor = commandExecutor;
        this.songConverter = songConverter;
    }

    @Override
    public Collection<MPDSong> search(SongSearcher.ScopeType searchType, String criteria) {
        return this.search(MPDSongSearcher.generateParams(searchType, criteria));
    }

    @Override
    public Collection<MPDSong> search(SongSearcher.ScopeType searchType, String criteria, int start, int end) {
        return this.search(this.addWindowedParams(MPDSongSearcher.generateParams(searchType, criteria), start, end));
    }

    private Collection<MPDSong> search(String[] params) {
        return this.songConverter.convertResponseToSong(this.commandExecutor.sendCommand(this.searchProperties.getSearch(), params));
    }

    @Override
    public Collection<MPDSong> find(SongSearcher.ScopeType scopeType, String criteria) {
        return this.find(MPDSongSearcher.generateParams(scopeType, criteria));
    }

    @Override
    public Collection<MPDSong> find(SongSearcher.ScopeType scopeType, String criteria, int start, int end) {
        return this.find(this.addWindowedParams(MPDSongSearcher.generateParams(scopeType, criteria), start, end));
    }

    private Collection<MPDSong> find(String[] params) {
        return this.songConverter.convertResponseToSong(this.commandExecutor.sendCommand(this.searchProperties.getFind(), params));
    }

    private static String[] generateParams(SongSearcher.ScopeType scopeType, String criteria) {
        String[] paramList;
        if (criteria != null) {
            paramList = new String[2];
            paramList[1] = criteria;
        } else {
            paramList = new String[]{scopeType.getType()};
        }
        return paramList;
    }

    private String[] addWindowedParams(String[] params, int start, int end) {
        String[] paramList = Arrays.copyOf(params, params.length + 2);
        paramList[params.length] = this.searchProperties.getWindow();
        paramList[params.length + 1] = start + "." + end;
        return paramList;
    }
}

