/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.json.JSONObject;
import org.openstatic.TunesDirector;

public class ControlBoxConnection
implements Runnable {
    private WebSocketClient webSocketClient;
    private WebSocketSession session;
    private EventsWebSocket socket;
    private String websocketUri;
    private String controlBoxName;
    private String deviceName;
    private int deviceId = 0;
    private long lastWriteMillis = 0L;
    private long lastReconnectedMillis = 0L;
    private long lastReadMillis = 0L;
    private long lastKeepAliveMillis = 0L;
    private Thread connectionThread;
    private PropertyChangeSupport propertyChangeSupport;
    private LinkedBlockingQueue<JSONObject> outboundPackets;
    private JSONObject properties;
    private String[] lastLines = new String[4];

    public void displayTextLine(int num, String text) {
        try {
            if (num >= 1 && num <= 4) {
                if (text == null) {
                    text = "                    ";
                }
                if (!text.equals(this.lastLines[num - 1])) {
                    this.lastLines[num - 1] = text;
                    JSONObject jo = new JSONObject();
                    jo.put("dev", this.deviceId);
                    jo.put("line" + String.valueOf(num), text);
                    this.send(jo);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateSlider(int num, int value) {
        if (this.isConnected()) {
            String sliderName;
            if (value < 0) {
                value = 0;
            }
            if (value > 127) {
                value = 127;
            }
            if ((num == 1 || num == 2) && this.properties.optInt(sliderName = "slider" + String.valueOf(num), -1) != value) {
                try {
                    JSONObject jo = new JSONObject();
                    jo.put("dev", this.deviceId);
                    jo.put(sliderName, value);
                    this.send(jo);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void updateDial(int num, int value) {
        if (this.isConnected()) {
            String dialName;
            if (value < 0) {
                value = 0;
            }
            if (value > 127) {
                value = 127;
            }
            if ((num == 1 || num == 2) && this.properties.optInt(dialName = "dial" + String.valueOf(num), -1) != value) {
                try {
                    JSONObject jo = new JSONObject();
                    jo.put("dev", this.deviceId);
                    jo.put(dialName, value);
                    this.send(jo);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public JSONObject getProperties() {
        return this.properties;
    }

    public String getWSUri() {
        return this.websocketUri;
    }

    public ControlBoxConnection(String devName, String websocketUri, String controlBoxName, PropertyChangeListener listener) {
        this.deviceName = devName;
        this.outboundPackets = new LinkedBlockingQueue();
        this.lastLines = new String[4];
        this.websocketUri = websocketUri;
        this.controlBoxName = controlBoxName;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.propertyChangeSupport.addPropertyChangeListener(listener);
        this.properties = new JSONObject();
        Thread startConnect = new Thread(() -> {
            try {
                Thread.sleep(1000L);
                this.launchConnectionThread();
                if (TunesDirector.instance.settings.optBoolean("controlBoxProtocol", true)) {
                    this.connect();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        startConnect.start();
    }

    private static long age(long ts) {
        return System.currentTimeMillis() - ts;
    }

    @Override
    public void run() {
        while (TunesDirector.instance.controlBoxConnection == this && TunesDirector.instance.keepRunning) {
            try {
                if (this.isConnected()) {
                    JSONObject packet = this.outboundPackets.poll(1L, TimeUnit.SECONDS);
                    if (packet != null) {
                        this.session.getRemote().sendString(packet.toString());
                        this.lastWriteMillis = System.currentTimeMillis();
                    }
                    if (ControlBoxConnection.age(this.lastReadMillis) > 10000L && ControlBoxConnection.age(this.lastKeepAliveMillis) > 10000L) {
                        this.lastKeepAliveMillis = System.currentTimeMillis();
                        System.err.println("Last Read Millis too long!");
                        JSONObject jo = new JSONObject();
                        if (this.lastLines[0] != null) {
                            jo.put("line1", this.lastLines[0]);
                        }
                        if (this.lastLines[1] != null) {
                            jo.put("line2", this.lastLines[1]);
                        }
                        if (this.lastLines[2] != null) {
                            jo.put("line3", this.lastLines[2]);
                        }
                        if (this.lastLines[3] != null) {
                            jo.put("line4", this.lastLines[3]);
                        }
                        this.send(jo);
                    }
                } else if (TunesDirector.instance.settings.optBoolean("controlBoxProtocol", true) && ControlBoxConnection.age(this.lastReconnectedMillis) > 10000L) {
                    this.lastReconnectedMillis = System.currentTimeMillis();
                    this.connect();
                }
                Thread.sleep(50L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            System.err.print("ControlBoxConnection - Stopping websocketClient....");
            this.webSocketClient.stop();
            System.err.println("DONE");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        this.webSocketClient = null;
        System.err.println("ControlBoxConnection - Exiting Keep Alive Thread!");
    }

    public void handleWebSocketEvent(JSONObject j) {
        this.lastReadMillis = System.currentTimeMillis();
        System.err.println("Inbound CTRLBOX traffic: " + j.toString());
        if (j.has("register")) {
            System.err.println("CONTROLBOX REG " + j.toString());
            if (this.deviceName.equals(j.optString("register"))) {
                this.deviceId = j.optInt("dev", 0);
                System.err.println("REGISTERED this CONTROLBOX " + String.valueOf(this.deviceId));
            }
        } else if (j.optInt("dev", -1) == this.deviceId) {
            Set<String> objectFieldSet = j.keySet();
            for (String propertyName : objectFieldSet) {
                Object propertyValue = j.opt(propertyName);
                Object oldValue = this.properties.opt(propertyName);
                this.properties.put(propertyName, propertyValue);
                this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, propertyValue);
            }
        }
    }

    public void connect() {
        try {
            this.outboundPackets = new LinkedBlockingQueue();
            this.socket = new EventsWebSocket();
            URI upstreamUri = new URI(this.websocketUri);
            this.webSocketClient.connect(this.socket, upstreamUri, new ClientUpgradeRequest());
        }
        catch (Throwable t2) {
            System.err.println("Error on connect() URI: " + this.websocketUri);
            t2.printStackTrace(System.err);
        }
    }

    public void close() {
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.session = null;
        }
    }

    public void launchConnectionThread() {
        if (this.webSocketClient == null) {
            try {
                this.webSocketClient = new WebSocketClient();
                this.webSocketClient.setMaxIdleTimeout(120000L);
                this.webSocketClient.start();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        if (this.connectionThread == null) {
            System.err.println("ControlBoxConnection - Keep alive thread is null");
            this.connectionThread = new Thread(this);
            this.connectionThread.start();
        } else if (!this.connectionThread.isAlive()) {
            System.err.println("ControlBoxConnection - Keep alive thread is dead, but exists");
            this.connectionThread = new Thread(this);
            this.connectionThread.start();
        } else {
            System.err.println("ControlBoxConnection - Keep alive thread already active");
        }
    }

    public void send(JSONObject jo) {
        if (jo != null) {
            this.outboundPackets.add(jo);
        }
    }

    public boolean isConnected() {
        if (this.session != null) {
            return this.session.isOpen();
        }
        return false;
    }

    public String getControlBoxName() {
        return this.controlBoxName;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @WebSocket
    public class EventsWebSocket {
        @OnWebSocketMessage
        public void onText(Session session, String message) throws IOException {
            if (this == ControlBoxConnection.this.socket) {
                try {
                    JSONObject jo = new JSONObject(message);
                    ControlBoxConnection.this.handleWebSocketEvent(jo);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }

        @OnWebSocketConnect
        public void onConnect(Session session) throws IOException {
            if (session instanceof WebSocketSession && this == ControlBoxConnection.this.socket) {
                ControlBoxConnection.this.session = (WebSocketSession)session;
                JSONObject registerObject = new JSONObject();
                registerObject.put("register", ControlBoxConnection.this.deviceName);
                if (ControlBoxConnection.this.lastLines[0] != null) {
                    registerObject.put("line1", ControlBoxConnection.this.lastLines[0]);
                }
                if (ControlBoxConnection.this.lastLines[1] != null) {
                    registerObject.put("line2", ControlBoxConnection.this.lastLines[1]);
                }
                if (ControlBoxConnection.this.lastLines[2] != null) {
                    registerObject.put("line3", ControlBoxConnection.this.lastLines[2]);
                }
                if (ControlBoxConnection.this.lastLines[3] != null) {
                    registerObject.put("line4", ControlBoxConnection.this.lastLines[3]);
                }
                registerObject.put("slider1Name", "Volume");
                registerObject.put("icon", TunesDirector.instance.getWebInterfaceURL() + "icon64.png");
                ControlBoxConnection.this.send(registerObject);
            }
        }

        @OnWebSocketClose
        public void onClose(Session session, int status, String reason) {
            if (this == ControlBoxConnection.this.socket) {
                ControlBoxConnection.this.close();
            }
        }

        @OnWebSocketError
        public void onError(Throwable e) {
            if (this == ControlBoxConnection.this.socket) {
                System.err.println("Connection Error - websocket");
                e.printStackTrace(System.err);
                ControlBoxConnection.this.close();
            }
        }
    }

    public static class EventsWebSocketServlet
    extends WebSocketServlet {
        @Override
        public void configure(WebSocketServletFactory factory) {
            factory.register(EventsWebSocket.class);
        }
    }
}

