/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.URI;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.glxn.qrgen.QRCode;
import net.glxn.qrgen.image.ImageType;
import org.openstatic.ImageAutoView;

public class CopyOrGo
extends JDialog
implements ActionListener {
    private JTextArea urlField;
    private JButton btnGo;
    private JButton btnCopy;
    private JButton btnCancel;
    private JButton saveQR;
    private ImageAutoView qrView;
    private BufferedImage myQR;

    public static BufferedImage QRCode(String url) {
        try {
            ByteArrayOutputStream stream = QRCode.from(url).withSize(150, 150).to(ImageType.PNG).stream();
            return ImageIO.read(new ByteArrayInputStream(stream.toByteArray()));
        }
        catch (Exception e) {
            return null;
        }
    }

    public CopyOrGo(Frame parent, String url) {
        super(parent, "Tunes Director wants to open a URL", true);
        Point loc = parent.getLocation();
        Dimension pDim = parent.getSize();
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.setLayout(new BorderLayout());
        this.urlField = new JTextArea(url);
        this.urlField.setMaximumSize(new Dimension(320, 240));
        this.urlField.setLineWrap(true);
        this.urlField.setRows(5);
        panel.add((Component)this.urlField, "Center");
        this.myQR = CopyOrGo.QRCode(url);
        this.qrView = new ImageAutoView(this.myQR);
        this.qrView.setBackground(Color.WHITE);
        this.qrView.setPreferredSize(new Dimension(150, 150));
        panel.add((Component)this.qrView, "West");
        this.btnGo = new JButton("Open in Browser");
        this.btnGo.addActionListener(this);
        this.btnGo.setDefaultCapable(true);
        this.btnCopy = new JButton("Copy URL");
        this.btnCopy.addActionListener(this);
        this.saveQR = new JButton("Save QR");
        this.saveQR.addActionListener(this);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.addActionListener(this);
        this.getRootPane().setDefaultButton(this.btnGo);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.btnCancel);
        buttonPanel.add(this.saveQR);
        buttonPanel.add(this.btnCopy);
        buttonPanel.add(this.btnGo);
        panel.add((Component)buttonPanel, "Last");
        this.getContentPane().add(panel);
        this.pack();
        Dimension windowSize = new Dimension(700, 240);
        this.setPreferredSize(windowSize);
        this.setSize(windowSize);
        this.setLocation(loc.x + pDim.width / 2 - this.getWidth() / 2, loc.y + pDim.height / 2 - this.getHeight() / 2);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.btnGo) {
            try {
                Desktop dt = Desktop.getDesktop();
                dt.browse(new URI(this.urlField.getText()));
                this.dispose();
            }
            catch (Exception dt) {}
        } else if (source == this.btnCopy) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.urlField.getText()), null);
            this.dispose();
        } else if (source == this.btnCancel) {
            this.dispose();
        } else if (source == this.saveQR) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Specify a Location to save this QR");
            FileNameExtensionFilter filter = new FileNameExtensionFilter("PNG Image", "png");
            fileChooser.setFileFilter(filter);
            fileChooser.setName("qr");
            int userSelection = fileChooser.showSaveDialog(this);
            if (userSelection == 0) {
                File fileToSave = fileChooser.getSelectedFile();
                if (!fileToSave.getName().endsWith(".png")) {
                    fileToSave = new File(fileToSave.toString() + ".png");
                }
                try {
                    ImageIO.write((RenderedImage)this.myQR, "PNG", fileToSave);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

