/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import javax.swing.JTextPane;

public class ImageAutoView
extends JTextPane {
    private BufferedImage tv_image;

    public ImageAutoView(BufferedImage image) {
        this.setFocusable(false);
        this.setBackground(Color.BLACK);
        this.tv_image = image;
    }

    @Override
    public void paint(Graphics g2) {
        super.paint(g2);
        Graphics2D g2d = (Graphics2D)g2;
        if (this.tv_image != null) {
            float w = this.getWidth();
            float h2 = this.getHeight();
            float o_w = this.tv_image.getWidth();
            float o_h = this.tv_image.getHeight();
            AffineTransform at = new AffineTransform();
            float s_w = w / o_w;
            float s_h = h2 / o_h;
            float s_a = 0.0f;
            s_a = s_w > s_h ? s_h : s_w;
            at.scale(s_a, s_a);
            AffineTransformOp scaleOp = new AffineTransformOp(at, 2);
            BufferedImage rgbi = new BufferedImage(this.tv_image.getWidth(), this.tv_image.getHeight(), 1);
            rgbi.createGraphics().drawImage(this.tv_image, 0, 0, Color.BLACK, null);
            BufferedImage ri = new BufferedImage((int)(o_w * s_a), (int)(o_h * s_a), 1);
            scaleOp.filter(rgbi, ri);
            int x = (this.getWidth() - ri.getWidth(null)) / 2;
            int y = (this.getHeight() - ri.getHeight(null)) / 2;
            g2.drawImage(ri, x, y, null);
        }
    }

    public void perferImageHeight() {
        Dimension d = new Dimension(this.tv_image.getHeight(), this.getWidth());
        this.setPreferredSize(d);
    }
}

