/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.json.JSONObject;
import org.openstatic.MusicPlayerTrackCellRenderer;
import org.openstatic.api.MusicPlayerRemote;
import org.openstatic.api.MusicPlayerTrack;

public class LibrarySearch
extends JDialog
implements ActionListener {
    private JList<MusicPlayerTrack> resultsJList;
    protected DefaultListModel<MusicPlayerTrack> roomMembers;
    private JButton saveButton;
    private JButton cancelButton;
    private JScrollPane scroller;
    private JPanel searchPanel;
    private JTextField searchField;
    private JButton searchButton;
    private MusicPlayerRemote musicPlayerRemote;

    public LibrarySearch(MusicPlayerRemote mpr, JFrame parent, String actionText) {
        super(parent, "Library Search", true);
        this.musicPlayerRemote = mpr;
        this.setLayout(new BorderLayout());
        this.roomMembers = new DefaultListModel();
        this.resultsJList = new JList<MusicPlayerTrack>(this.roomMembers);
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        selectionModel.setSelectionMode(2);
        this.resultsJList.setBackground(Color.WHITE);
        this.resultsJList.setForeground(Color.BLACK);
        this.resultsJList.setAutoscrolls(false);
        this.resultsJList.setOpaque(true);
        this.resultsJList.setSelectionBackground(Color.DARK_GRAY);
        this.resultsJList.setSelectionForeground(Color.WHITE);
        this.resultsJList.setSelectionMode(2);
        this.resultsJList.setSelectionModel(selectionModel);
        this.resultsJList.setCellRenderer(new MusicPlayerTrackCellRenderer());
        this.saveButton = new JButton();
        this.saveButton.setText(actionText);
        this.saveButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(this);
        this.scroller = new JScrollPane(this.resultsJList);
        this.scroller.setHorizontalScrollBarPolicy(31);
        this.searchPanel = new JPanel(new BorderLayout());
        this.searchField = new JTextField();
        this.searchPanel.add((Component)this.searchField, "Center");
        this.searchField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    LibrarySearch.this.doSearch();
                }
                if (e.getKeyCode() == 27) {
                    LibrarySearch.this.resultsJList.clearSelection();
                    LibrarySearch.this.dispose();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.searchButton = new JButton();
        this.searchButton.setText("Search");
        this.searchButton.addActionListener(this);
        this.searchButton.setDefaultCapable(true);
        this.searchPanel.add((Component)new JLabel(" Song title/artist "), "West");
        this.searchPanel.add((Component)this.searchButton, "East");
        this.add((Component)this.searchPanel, "First");
        this.add((Component)this.scroller, "Center");
        GridLayout gl = new GridLayout(2, 1);
        JPanel buttPanel = new JPanel(gl);
        buttPanel.add(this.saveButton);
        buttPanel.add(this.cancelButton);
        this.add((Component)buttPanel, "Last");
        this.centerWindow();
    }

    public Collection<MusicPlayerTrack> getTracks() {
        return this.resultsJList.getSelectedValuesList();
    }

    public JSONObject textSearch(String value) {
        JSONObject text = new JSONObject().put("$regex", "^" + value);
        return text;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.saveButton) {
            this.dispose();
        } else if (e.getSource() == this.cancelButton) {
            this.roomMembers.clear();
            this.resultsJList.clearSelection();
            this.dispose();
        } else if (e.getSource() == this.searchButton) {
            this.doSearch();
        }
    }

    public void doSearch() {
        this.searchButton.setEnabled(false);
        this.searchField.setEnabled(false);
        this.roomMembers.clear();
        Thread t = new Thread(() -> {
            try {
                Collection<MusicPlayerTrack> resultsAsUsers = this.musicPlayerRemote.searchLibrary(this.searchField.getText());
                if (resultsAsUsers.size() > 0) {
                    this.roomMembers.addAll(resultsAsUsers);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            this.resultsJList.repaint();
            this.searchField.setEnabled(true);
            this.searchButton.setEnabled(true);
        });
        t.start();
    }

    public void centerWindow() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenSize = tk.getScreenSize();
        float WIDTH = screenSize.width;
        float HEIGHT = screenSize.height;
        int wWidth = 400;
        int wHeight = 450;
        int x = (int)(WIDTH / 2.0f - (float)wWidth / 2.0f);
        int y = (int)(HEIGHT / 2.0f - (float)wHeight / 2.0f);
        this.setBounds(x, y, wWidth, wHeight);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setVisible(true);
    }
}

