/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.json.JSONObject;
import org.openstatic.TunesDirector;
import org.openstatic.routeput.RoutePutChannel;
import org.openstatic.routeput.RoutePutChannelListener;
import org.openstatic.routeput.RoutePutMessage;
import org.openstatic.routeput.RoutePutMessageListener;
import org.openstatic.routeput.RoutePutRemoteSession;
import org.openstatic.routeput.RoutePutSession;
import org.openstatic.routeput.client.RoutePutClient;

public class RouteputInterface
implements RoutePutMessageListener,
RoutePutChannelListener {
    private RoutePutClient routeputClient;
    private RoutePutChannel myChannel;
    private static String LOCAL_SERIAL;

    public RouteputInterface() {
        if (LOCAL_SERIAL == null) {
            LOCAL_SERIAL = RouteputInterface.getLocalMAC();
        }
        String openstaticUri = "wss://openstatic.org/channel/";
        RoutePutRemoteSession.init();
        this.myChannel = RoutePutChannel.getChannel("tunes-director-" + LOCAL_SERIAL);
        this.routeputClient = new RoutePutClient(this.myChannel, openstaticUri);
        this.routeputClient.setAutoReconnect(true);
        this.routeputClient.setCollector(true);
        this.routeputClient.setProperty("description", "Tunes Director");
        this.routeputClient.setProperty("host", TunesDirector.getLocalHostname());
        this.myChannel.addChannelListener(this);
        this.routeputClient.connect();
    }

    public void shutdown() {
        this.routeputClient.setAutoReconnect(false);
        this.routeputClient.close();
    }

    public String getURLString() {
        return "https://openstatic.org/projects/tunesdirector/remote?s=" + LOCAL_SERIAL;
    }

    public static String getLocalMAC() {
        String return_mac = "";
        try {
            Enumeration<NetworkInterface> n = NetworkInterface.getNetworkInterfaces();
            while (n.hasMoreElements()) {
                NetworkInterface ni = n.nextElement();
                Enumeration<InetAddress> e = ni.getInetAddresses();
                while (e.hasMoreElements()) {
                    InetAddress ia = e.nextElement();
                    if (ia.isLoopbackAddress() || !ia.isSiteLocalAddress()) continue;
                    byte[] mac = ni.getHardwareAddress();
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < mac.length; ++i) {
                        sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
                    }
                    return_mac = sb.toString();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return return_mac;
    }

    public int getConnectionCount() {
        return this.myChannel.getMembers().size() - 1;
    }

    public void updateState(JSONObject state) {
        this.send(state);
    }

    public void send(JSONObject obj) {
        this.send(new RoutePutMessage(obj));
    }

    public void send(RoutePutMessage routePutMessage) {
        routePutMessage.setChannel(this.myChannel);
        this.routeputClient.send(routePutMessage);
    }

    @Override
    public void onJoin(RoutePutChannel arg0, RoutePutSession arg1) {
        if (arg1 != this.routeputClient) {
            System.err.println("Adding listener for " + arg1.toJSONObject().toString());
            arg1.addMessageListener(this);
            JSONObject playerState = TunesDirector.instance.getPlayerState();
            if (playerState == null) {
                playerState = new JSONObject();
            }
            RoutePutMessage greetingPacket = new RoutePutMessage(playerState);
            greetingPacket.setChannel(this.myChannel);
            greetingPacket.put("transportControl", TunesDirector.instance.settings.optBoolean("remoteTransportControl", true));
            greetingPacket.put("volumeControl", TunesDirector.instance.settings.optBoolean("remoteVolumeControl", true));
            arg1.send(greetingPacket);
        }
    }

    @Override
    public void onLeave(RoutePutChannel arg0, RoutePutSession arg1) {
        System.err.println("on leave for " + arg1.toJSONObject().toString());
    }

    @Override
    public void onMessage(RoutePutSession arg0, RoutePutMessage j) {
        try {
            System.err.println("routeput - " + j.toString());
            if (j.has("cmd") && TunesDirector.instance.settings.optBoolean("remoteTransportControl", true)) {
                String cmd = j.optString("cmd");
                if ("play".equals(cmd)) {
                    TunesDirector.instance.play();
                } else if ("pause".equals(cmd)) {
                    TunesDirector.instance.pause();
                } else if ("previous".equals(cmd)) {
                    TunesDirector.instance.previous();
                } else if ("next".equals(cmd)) {
                    TunesDirector.instance.next();
                }
            }
            if (j.has("shuffle") && TunesDirector.instance.settings.optBoolean("remoteTransportControl", true)) {
                TunesDirector.instance.setShuffle(j.optBoolean("shuffle", false));
            }
            if (j.has("repeat") && TunesDirector.instance.settings.optBoolean("remoteTransportControl", true)) {
                TunesDirector.instance.setRepeat(j.optBoolean("repeat", false));
            }
            if (j.has("volume") && TunesDirector.instance.settings.optBoolean("remoteVolumeControl", true)) {
                TunesDirector.instance.setVolume(j.optInt("volume", 0));
            }
            if (j.has("player")) {
                TunesDirector.instance.selectPlayer(j.optString("player"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

