/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.DirectAndRawInputEnvironmentPlugin;
import org.checkerframework.checker.regex.RegexUtil;
import org.json.JSONObject;
import org.openstatic.ControlBoxConnection;
import org.openstatic.CopyOrGo;
import org.openstatic.LibrarySearch;
import org.openstatic.RouteputInterface;
import org.openstatic.WebServer;
import org.openstatic.api.GamepadController;
import org.openstatic.api.MusicPlayerRemote;
import org.openstatic.api.MusicPlayerTrack;
import org.openstatic.api.audacious.AudaciousRemote;
import org.openstatic.api.itunes.OSAScriptRemote;
import org.openstatic.api.itunes.VBScriptRemote;
import org.openstatic.api.mpd.MPDRemote;
import org.openstatic.api.remote.TunesDirectorRemote;
import org.openstatic.api.spotify.SpotifyRemote;

public class TunesDirector
extends JFrame
implements Runnable,
ActionListener,
PropertyChangeListener,
MusicPlayerRemote,
ChangeListener,
ServiceListener {
    public static MusicPlayerRemote musicPlayerRemote;
    public WebServer webServer;
    public RouteputInterface routeputInterface;
    public String hostname;
    public String controlBoxDeviceId;
    public static LinkedHashMap<String, BufferedImage> cachedImages;
    public static ArrayList<JmDNS> jmdns;
    public static TunesDirector instance;
    public static int forceWidth;
    public static int forceHeight;
    public static int forceX;
    public static int forceY;
    public ControlBoxConnection controlBoxConnection;
    public static int[] volumeMap;
    private JTextArea trackLabel;
    private JLabel statusLabel;
    private JLabel preFadeLabel;
    private JButton playButton;
    private JToggleButton shuffleButton;
    private JToggleButton repeatButton;
    private JButton pauseButton;
    private JButton nextButton;
    private JButton previousButton;
    private JPanel buttonPanel;
    public JSONObject settings;
    private JSONObject playerState;
    private JProgressBar songProgress;
    private JSlider preFadeVolumeSlider;
    public JSlider volumeSlider;
    private String currentTrack;
    private long lastNextClickMillis;
    private int trackPosition;
    private int trackDuration;
    private int fadeDirection;
    private boolean isFaded;
    public boolean keepRunning;
    private boolean isPlaying;
    private Thread directorThread;
    private JLabel albumArtwork;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenu optionsMenu;
    private JMenu controllersMenu;
    private JMenu playerMenu;
    private JMenu helpMenu;
    private JMenu gamepadMenu;
    private JCheckBoxMenuItem assertControlOverPlayer;
    private JCheckBoxMenuItem controlBoxProtocolMenuItem;
    private JCheckBoxMenuItem webServerMenuItem;
    private JCheckBoxMenuItem routeputMenuItem;
    private JCheckBoxMenuItem alwaysOnTopMenuItem;
    private JCheckBoxMenuItem fadeOutOnPauseMenuItem;
    private JCheckBoxMenuItem lockNextUnlessPausedMenuItem;
    private JCheckBoxMenuItem remoteVolumeControl;
    private JCheckBoxMenuItem remoteTransportControl;
    private JRadioButtonMenuItem itunesPlayerMenuItem;
    private JRadioButtonMenuItem spotifyPlayerMenuItem;
    private JRadioButtonMenuItem audaciousPlayerMenuItem;
    private JRadioButtonMenuItem mpdPlayerMenuItem;
    private JRadioButtonMenuItem remoteTunesDirectorPlayerMenuItem;
    private ArrayList<JRadioButtonMenuItem> remoteTunesDirectorMenuItems;
    private JMenuItem exitMenuItem;
    private JMenuItem aboutMenuItem;
    private JMenuItem searchLibraryMenuItem;
    private JMenuItem openWebMenuItem;
    private JMenuItem openOpenstaticMenuItem;
    private JMenuItem configurePlayerMenuItem;
    private ButtonGroup playerButtonGroup;
    private long volumeReadLockoutUntil;
    private boolean assertedPlaybackState;
    private ControllerEnvironment controllerEnvironment;
    private HashMap<String, GamepadController> gamepads;
    private Thread gamepadScanThread;

    public String capFirstLetter(String s2) {
        return s2.substring(0, 1).toUpperCase() + s2.substring(1);
    }

    public TunesDirector(JSONObject settings) {
        super("Tunes Director");
        try {
            this.controllerEnvironment = ControllerEnvironment.getDefaultEnvironment();
        }
        catch (Exception cee) {
            cee.printStackTrace(System.err);
        }
        this.gamepads = new HashMap();
        this.settings = settings;
        this.assertedPlaybackState = false;
        this.volumeReadLockoutUntil = 0L;
        this.isPlaying = false;
        instance = this;
        this.hostname = TunesDirector.getLocalHostname();
        this.controlBoxDeviceId = this.hostname.length() <= 11 ? "Tunes" + this.capFirstLetter(this.hostname) : "Tunes" + this.capFirstLetter(this.hostname).substring(0, 10);
        this.menuBar = new JMenuBar();
        this.fadeDirection = 0;
        this.isFaded = false;
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic(70);
        this.openWebMenuItem = new JMenuItem("Open HTTP Interface");
        this.openWebMenuItem.setMnemonic(79);
        this.openWebMenuItem.addActionListener(this);
        this.openWebMenuItem.setActionCommand("openweb");
        this.openWebMenuItem.setEnabled(false);
        this.fileMenu.add(this.openWebMenuItem);
        this.openOpenstaticMenuItem = new JMenuItem("Open Openstatic.org Interface");
        this.openOpenstaticMenuItem.addActionListener(this);
        this.openOpenstaticMenuItem.setActionCommand("openopenstatic");
        this.openOpenstaticMenuItem.setEnabled(false);
        this.fileMenu.add(this.openOpenstaticMenuItem);
        this.searchLibraryMenuItem = new JMenuItem("Search Library");
        this.searchLibraryMenuItem.addActionListener(this);
        this.searchLibraryMenuItem.setActionCommand("searchlibrary");
        this.fileMenu.add(this.searchLibraryMenuItem);
        this.exitMenuItem = new JMenuItem("Exit");
        this.exitMenuItem.setMnemonic(88);
        this.exitMenuItem.addActionListener(this);
        this.exitMenuItem.setActionCommand("exit");
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.optionsMenu = new JMenu("Options");
        this.optionsMenu.setMnemonic(79);
        this.controllersMenu = new JMenu("Controllers");
        this.controllersMenu.setMnemonic(67);
        this.controlBoxProtocolMenuItem = new JCheckBoxMenuItem("Enable ControlBox Protocol");
        this.controlBoxProtocolMenuItem.addActionListener(this);
        this.controlBoxProtocolMenuItem.setActionCommand("controlbox");
        boolean contorlBoxProtocol = settings.optBoolean("controlBoxProtocol", false);
        this.controlBoxProtocolMenuItem.setSelected(contorlBoxProtocol);
        this.setControlBoxProtocol(contorlBoxProtocol);
        this.controllersMenu.add(this.controlBoxProtocolMenuItem);
        this.assertControlOverPlayer = new JCheckBoxMenuItem("Assert Control over Player");
        this.assertControlOverPlayer.addActionListener(this);
        this.assertControlOverPlayer.setActionCommand("assert");
        boolean assertControl = settings.optBoolean("assertControl", false);
        this.assertControlOverPlayer.setSelected(assertControl);
        this.optionsMenu.add(this.assertControlOverPlayer);
        this.webServerMenuItem = new JCheckBoxMenuItem("Enable HTTP/WS Server");
        this.webServerMenuItem.addActionListener(this);
        this.webServerMenuItem.setActionCommand("webserver");
        this.webServerMenuItem.setSelected(settings.optBoolean("webServer", true));
        this.controllersMenu.add(this.webServerMenuItem);
        this.routeputMenuItem = new JCheckBoxMenuItem("Enable Openstatic.org Interface");
        this.routeputMenuItem.addActionListener(this);
        this.routeputMenuItem.setActionCommand("routeput");
        this.routeputMenuItem.setSelected(settings.optBoolean("routeput", false));
        this.controllersMenu.add(this.routeputMenuItem);
        this.alwaysOnTopMenuItem = new JCheckBoxMenuItem("Keep this window on top");
        this.alwaysOnTopMenuItem.addActionListener(this);
        this.alwaysOnTopMenuItem.setActionCommand("alwaystop");
        this.alwaysOnTopMenuItem.setSelected(settings.optBoolean("alwaysOnTop", true));
        this.optionsMenu.add(this.alwaysOnTopMenuItem);
        this.fadeOutOnPauseMenuItem = new JCheckBoxMenuItem("Perform Fade on Play/Pause");
        this.fadeOutOnPauseMenuItem.addActionListener(this);
        this.fadeOutOnPauseMenuItem.setActionCommand("fadeout");
        this.fadeOutOnPauseMenuItem.setSelected(settings.optBoolean("fadeOut", false));
        this.optionsMenu.add(this.fadeOutOnPauseMenuItem);
        this.lockNextUnlessPausedMenuItem = new JCheckBoxMenuItem("Disable Next/Previous unless Paused");
        this.lockNextUnlessPausedMenuItem.addActionListener(this);
        this.lockNextUnlessPausedMenuItem.setActionCommand("lockskip");
        this.lockNextUnlessPausedMenuItem.setSelected(settings.optBoolean("lockSkip", false));
        this.optionsMenu.add(this.lockNextUnlessPausedMenuItem);
        this.remoteTransportControl = new JCheckBoxMenuItem("Remote Transport Control");
        this.remoteTransportControl.addActionListener(this);
        this.remoteTransportControl.setActionCommand("rtransport");
        this.remoteTransportControl.setSelected(settings.optBoolean("remoteTransportControl", true));
        this.controllersMenu.add(this.remoteTransportControl);
        this.remoteVolumeControl = new JCheckBoxMenuItem("Remote Volume Control");
        this.remoteVolumeControl.addActionListener(this);
        this.remoteVolumeControl.setActionCommand("rvolume");
        this.remoteVolumeControl.setSelected(settings.optBoolean("remoteVolumeControl", true));
        this.controllersMenu.add(this.remoteVolumeControl);
        this.gamepadMenu = new JMenu("Gamepads");
        this.controllersMenu.add(this.gamepadMenu);
        this.menuBar.add(this.optionsMenu);
        this.menuBar.add(this.controllersMenu);
        this.remoteTunesDirectorMenuItems = new ArrayList();
        this.playerMenu = new JMenu("Select Player");
        this.spotifyPlayerMenuItem = new JRadioButtonMenuItem("Spotify");
        this.spotifyPlayerMenuItem.setIcon(this.getIcon("/spotify.png"));
        this.spotifyPlayerMenuItem.setActionCommand("player-spotify");
        this.spotifyPlayerMenuItem.addActionListener(this);
        this.itunesPlayerMenuItem = new JRadioButtonMenuItem("iTunes");
        this.itunesPlayerMenuItem.setIcon(this.getIcon("/itunes.png"));
        this.itunesPlayerMenuItem.setActionCommand("player-itunes");
        this.itunesPlayerMenuItem.addActionListener(this);
        this.audaciousPlayerMenuItem = new JRadioButtonMenuItem("Audacious");
        this.audaciousPlayerMenuItem.setIcon(this.getIcon("/audacious.png"));
        this.audaciousPlayerMenuItem.setActionCommand("player-audacious");
        this.audaciousPlayerMenuItem.addActionListener(this);
        this.mpdPlayerMenuItem = new JRadioButtonMenuItem("MPD");
        this.mpdPlayerMenuItem.setIcon(this.getIcon("/mpd.png"));
        this.mpdPlayerMenuItem.setActionCommand("player-mpd");
        this.mpdPlayerMenuItem.addActionListener(this);
        this.remoteTunesDirectorPlayerMenuItem = new JRadioButtonMenuItem("Remote Tunes Director");
        this.remoteTunesDirectorPlayerMenuItem.setIcon(this.getIcon("/icon48.png"));
        this.remoteTunesDirectorPlayerMenuItem.setActionCommand("player-remote");
        this.remoteTunesDirectorPlayerMenuItem.addActionListener(this);
        this.playerButtonGroup = new ButtonGroup();
        this.playerButtonGroup.add(this.spotifyPlayerMenuItem);
        this.playerButtonGroup.add(this.itunesPlayerMenuItem);
        this.playerButtonGroup.add(this.audaciousPlayerMenuItem);
        this.playerButtonGroup.add(this.mpdPlayerMenuItem);
        this.playerButtonGroup.add(this.remoteTunesDirectorPlayerMenuItem);
        this.configurePlayerMenuItem = new JMenuItem("Configure Player");
        this.configurePlayerMenuItem.setIcon(this.getIcon("/gear48.png"));
        this.configurePlayerMenuItem.setActionCommand("configure-player");
        this.configurePlayerMenuItem.addActionListener(this);
        this.playerMenu.add(this.itunesPlayerMenuItem);
        this.playerMenu.add(this.spotifyPlayerMenuItem);
        this.playerMenu.add(this.audaciousPlayerMenuItem);
        this.playerMenu.add(this.mpdPlayerMenuItem);
        this.playerMenu.add(this.remoteTunesDirectorPlayerMenuItem);
        this.playerMenu.addSeparator();
        this.playerMenu.add(this.configurePlayerMenuItem);
        this.menuBar.add(this.playerMenu);
        this.helpMenu = new JMenu("Help");
        this.helpMenu.setMnemonic(72);
        this.aboutMenuItem = new JMenuItem("About");
        this.aboutMenuItem.setMnemonic(65);
        this.aboutMenuItem.setActionCommand("about");
        this.aboutMenuItem.addActionListener(this);
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.keepRunning = true;
        this.setLayout(new BorderLayout());
        try {
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icon48.png")));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        Font big_font = new Font("Monospaced", 1, 48);
        Font small_font = new Font("Monospaced", 1, 18);
        JPanel main_pane = new JPanel(new BorderLayout());
        this.setForeground(Color.WHITE);
        this.setBackground(Color.BLACK);
        main_pane.setForeground(Color.WHITE);
        main_pane.setBackground(Color.BLACK);
        this.trackLabel = new JTextArea("");
        this.trackLabel.setFont(big_font);
        this.trackLabel.setOpaque(false);
        this.trackLabel.setLineWrap(true);
        this.trackLabel.setWrapStyleWord(true);
        this.trackLabel.setForeground(Color.WHITE);
        this.trackLabel.setBackground(Color.BLACK);
        this.trackLabel.setEditable(false);
        this.trackLabel.setFocusable(false);
        this.trackLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(1, 6));
        this.previousButton = new JButton(this.getIcon("/prev.png"));
        this.previousButton.setActionCommand("previous");
        this.previousButton.addActionListener(this);
        this.buttonPanel.add(this.previousButton);
        this.playButton = new JButton(this.getIcon("/play.png"));
        this.playButton.setActionCommand("play");
        this.playButton.addActionListener(this);
        this.buttonPanel.add(this.playButton);
        this.repeatButton = new JToggleButton(this.getIcon("/repeat.png"));
        this.repeatButton.setActionCommand("repeat");
        this.repeatButton.addActionListener(this);
        this.buttonPanel.add(this.repeatButton);
        this.shuffleButton = new JToggleButton(this.getIcon("/shuffle.png"));
        this.shuffleButton.setActionCommand("shuffle");
        this.shuffleButton.addActionListener(this);
        this.buttonPanel.add(this.shuffleButton);
        this.pauseButton = new JButton(this.getIcon("/pause.png"));
        this.pauseButton.setActionCommand("pause");
        this.pauseButton.addActionListener(this);
        this.buttonPanel.add(this.pauseButton);
        this.nextButton = new JButton(this.getIcon("/next.png"));
        this.nextButton.setActionCommand("next");
        this.nextButton.addActionListener(this);
        this.buttonPanel.add(this.nextButton);
        main_pane.add((Component)this.buttonPanel, "First");
        JPanel labelPanel = new JPanel(new BorderLayout());
        labelPanel.setBackground(Color.BLACK);
        labelPanel.add((Component)this.trackLabel, "Center");
        this.statusLabel = new JLabel();
        this.statusLabel.setBackground(Color.BLACK);
        this.statusLabel.setForeground(Color.YELLOW);
        this.statusLabel.setFont(small_font);
        labelPanel.add((Component)this.statusLabel, "Last");
        main_pane.add((Component)labelPanel, "Center");
        this.volumeSlider = new JSlider(1, 0, 100, 0);
        this.volumeSlider.addChangeListener(this);
        this.volumeSlider.setBackground(Color.BLACK);
        this.volumeSlider.setForeground(Color.WHITE);
        Dimension volumeSliderDimension = this.volumeSlider.getPreferredSize();
        volumeSliderDimension.width = 32;
        this.volumeSlider.setPreferredSize(volumeSliderDimension);
        this.preFadeVolumeSlider = new JSlider(1, 0, 100, 0);
        this.preFadeVolumeSlider.addChangeListener(this);
        this.preFadeVolumeSlider.setBackground(Color.BLACK);
        this.preFadeVolumeSlider.setForeground(Color.WHITE);
        this.preFadeVolumeSlider.setPreferredSize(volumeSliderDimension);
        JPanel volumeLabels = new JPanel(new GridLayout(1, 2));
        volumeLabels.setBackground(Color.BLACK);
        this.preFadeLabel = new JLabel("PF");
        this.preFadeLabel.setOpaque(true);
        this.preFadeLabel.setBackground(Color.BLACK);
        this.preFadeLabel.setHorizontalAlignment(0);
        this.preFadeLabel.setForeground(Color.GREEN);
        volumeLabels.add(this.preFadeLabel);
        this.preFadeVolumeSlider.setVisible(settings.optBoolean("fadeOut", false));
        this.preFadeLabel.setVisible(settings.optBoolean("fadeOut", false));
        JLabel masterLabel = new JLabel("M");
        masterLabel.setOpaque(true);
        masterLabel.setBackground(Color.BLACK);
        masterLabel.setHorizontalAlignment(0);
        masterLabel.setForeground(Color.RED);
        volumeLabels.add(masterLabel);
        JPanel volumeSliders = new JPanel(new GridLayout(1, 2));
        volumeSliders.setBackground(Color.BLACK);
        volumeSliders.add(this.preFadeVolumeSlider);
        volumeSliders.add(this.volumeSlider);
        JPanel volumePanel = new JPanel(new BorderLayout());
        volumePanel.add((Component)volumeSliders, "Center");
        volumePanel.add((Component)volumeLabels, "First");
        main_pane.add((Component)volumePanel, "East");
        this.albumArtwork = new JLabel();
        this.albumArtwork.setMinimumSize(new Dimension(256, 256));
        this.albumArtwork.setOpaque(false);
        this.albumArtwork.setBackground(Color.BLACK);
        EmptyBorder margin = new EmptyBorder(10, 10, 10, 10);
        this.albumArtwork.setBorder(margin);
        this.albumArtwork.setIcon(new ImageIcon(TunesDirector.getCachedImage("/disk2.png", "256x256")));
        main_pane.add((Component)this.albumArtwork, "West");
        this.songProgress = new JProgressBar();
        this.songProgress.setStringPainted(true);
        this.songProgress.setForeground(Color.BLUE);
        this.songProgress.setBackground(Color.BLACK);
        this.songProgress.setBorderPainted(false);
        this.songProgress.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        Dimension songProgressDimension = this.songProgress.getPreferredSize();
        songProgressDimension.height = 48;
        this.songProgress.setPreferredSize(songProgressDimension);
        main_pane.add((Component)this.songProgress, "Last");
        this.add((Component)main_pane, "Center");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (TunesDirector.this.routeputInterface != null) {
                    TunesDirector.this.routeputInterface.shutdown();
                }
                TunesDirector.this.keepRunning = false;
                File homeDir = new File(System.getProperty("user.home"));
                File settingsFile = new File(homeDir, ".tunes-director-settings.json");
                TunesDirector.saveJSONObject(settingsFile, TunesDirector.this.settings);
                if (TunesDirector.this.controlBoxConnection != null) {
                    ControlBoxConnection cbc = TunesDirector.this.controlBoxConnection;
                    TunesDirector.this.controlBoxConnection = null;
                    cbc.close();
                }
                TunesDirector.shutDownMDNS();
            }
        });
        this.setDefaultCloseOperation(3);
        this.webServer = new WebServer(this);
        this.setWebServerState(settings.optBoolean("webServer", true));
        this.setRouteputState(settings.optBoolean("routeput", false));
        String defaultPlayer = "";
        String os_name = System.getProperty("os.name").toLowerCase();
        if (os_name.contains("win") || os_name.contains("mac")) {
            defaultPlayer = "itunes";
        } else if (os_name.contains("linux")) {
            this.itunesPlayerMenuItem.setEnabled(false);
            defaultPlayer = "audacious";
        } else {
            this.itunesPlayerMenuItem.setEnabled(false);
            defaultPlayer = "spotify";
        }
        this.selectPlayer(settings.optString("player", defaultPlayer));
        this.directorThread = new Thread(this);
        this.directorThread.start();
        Thread loadMDNS = new Thread(() -> TunesDirector.initMDNS());
        loadMDNS.start();
        this.refreshGamepads();
    }

    public static void shutDownMDNS() {
        if (jmdns != null) {
            System.err.println("Please Wait for mDNS to unregister....");
            jmdns.forEach(mDNS -> {
                try {
                    System.err.println("Unregister " + mDNS.getInetAddress().toString());
                    mDNS.unregisterAllServices();
                    mDNS.close();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            });
        }
    }

    public void refreshGamepads() {
        DirectAndRawInputEnvironmentPlugin env = new DirectAndRawInputEnvironmentPlugin();
        this.controllerEnvironment = !((ControllerEnvironment)env).isSupported() ? ControllerEnvironment.getDefaultEnvironment() : env;
        Controller[] ca = this.controllerEnvironment.getControllers();
        Vector<Controller> scannedControllers = new Vector<Controller>(Arrays.asList(ca));
        Vector<String> controllerNames = new Vector<String>();
        for (Controller di : scannedControllers) {
            String devName = di.getName().toLowerCase();
            controllerNames.add(devName);
            if (this.gamepads.containsKey(devName) || devName.contains("mouse") || devName.contains("keyboard")) continue;
            System.err.println("Gamepad Found: " + devName);
            GamepadController gpController = new GamepadController(di);
            this.gamepads.put(devName, gpController);
            this.gamepadMenu.add(gpController.getMenuItem());
        }
        for (String key : this.gamepads.keySet()) {
            if (controllerNames.contains(key)) continue;
            System.err.println("Gamepad Removed: " + key);
            GamepadController removedGamepad = this.gamepads.remove(key);
            this.gamepadMenu.remove(removedGamepad.getMenuItem());
        }
    }

    public void resetAlbumArt() {
        this.albumArtwork.setIcon(new ImageIcon(TunesDirector.getCachedImage("/disk2.png", "256x256")));
    }

    public static void initMDNS() {
        try {
            if (jmdns == null) {
                jmdns = new ArrayList();
                Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
                for (NetworkInterface netint : Collections.list(nets)) {
                    Enumeration<InetAddress> addresses = netint.getInetAddresses();
                    Collections.list(addresses).forEach(address -> {
                        if (address instanceof Inet4Address) {
                            try {
                                JmDNS jm = JmDNS.create(address);
                                ServiceInfo httpServiceInfo = ServiceInfo.create("_http._tcp.", "TunesDirector " + TunesDirector.instance.hostname, 6323, "path=index.html");
                                jm.registerService(httpServiceInfo);
                                ServiceInfo wsServiceInfo = ServiceInfo.create("_ws._tcp.", "TunesDirector " + TunesDirector.instance.hostname, 6323, "path=/events/");
                                jm.registerService(wsServiceInfo);
                                jm.addServiceListener("_ws._tcp.local.", instance);
                                jmdns.add(jm);
                                System.err.println("Created JMDNS for (" + address.toString() + ")!");
                            }
                            catch (Exception e) {
                                e.printStackTrace(System.err);
                            }
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public ImageIcon getIcon(String name) {
        try {
            return new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream(name)));
        }
        catch (Exception e) {
            return null;
        }
    }

    public void centerWindow() {
        Dimension minimumSize = new Dimension(800, forceHeight);
        Dimension maximumSize = new Dimension(1920, forceHeight);
        if (forceWidth > 0) {
            Dimension forceSize = new Dimension(forceWidth, forceHeight);
            this.setSize(forceSize);
        } else {
            this.setSize(minimumSize);
        }
        this.setMaximumSize(maximumSize);
        this.setMinimumSize(minimumSize);
        this.setResizable(true);
        this.setLocation(forceX, forceY);
        this.debug("Centered Window");
        this.repaint();
        this.onPlaybackChange(this.isPlaying);
        this.setAlwaysOnTop(this.settings.optBoolean("alwaysOnTop", true));
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i <= 127; ++i) {
            int y;
            TunesDirector.volumeMap[i] = y = TunesDirector.map(i, 0, 127, 0, 100);
        }
        File homeDir = new File(System.getProperty("user.home"));
        File settingsFile = new File(homeDir, ".tunes-director-settings.json");
        JSONObject settings = new JSONObject();
        if (settingsFile.exists()) {
            settings = TunesDirector.loadJSONObject(settingsFile);
        }
        if (!settings.has("controlBoxProtocol")) {
            settings.put("controlBoxProtocol", true);
        }
        if (!settings.has("alwaysOnTop")) {
            settings.put("alwaysOnTop", true);
        }
        TunesDirector mcDesktop = new TunesDirector(settings);
        mcDesktop.setVisible(true);
        int i = 0;
        if (args.length > 0) {
            for (String arg : args) {
                String[] gSplit;
                String g2;
                if (arg.equals("--size")) {
                    g2 = args[i + 1];
                    gSplit = g2.split(RegexUtil.asRegex("x"));
                    forceWidth = Integer.valueOf(gSplit[0]);
                    forceHeight = Integer.valueOf(gSplit[1]);
                    System.err.println("Forced size to " + String.valueOf(forceWidth) + "x" + String.valueOf(forceHeight));
                }
                if (arg.equals("--location")) {
                    g2 = args[i + 1];
                    gSplit = g2.split(RegexUtil.asRegex(","));
                    forceX = Integer.valueOf(gSplit[0]);
                    forceY = Integer.valueOf(gSplit[1]);
                    System.err.println("Forced location to " + String.valueOf(forceX) + "," + String.valueOf(forceY));
                }
                ++i;
            }
        }
        mcDesktop.centerWindow();
    }

    public void debug(String text) {
        if (!this.settings.optBoolean("quiet", false)) {
            System.err.println(text);
        }
    }

    public static JSONObject loadJSONObject(File file) {
        try {
            int ch;
            FileInputStream fis = new FileInputStream(file);
            StringBuilder builder = new StringBuilder();
            while ((ch = fis.read()) != -1) {
                builder.append((char)ch);
            }
            fis.close();
            JSONObject props = new JSONObject(builder.toString());
            return props;
        }
        catch (Exception e) {
            return new JSONObject();
        }
    }

    public static void saveJSONObject(File file, JSONObject obj) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            PrintStream ps = new PrintStream(fos);
            ps.print(obj.toString(2));
            ps.close();
            fos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (this.keepRunning) {
            try {
                int rcc;
                int wsc;
                boolean ignoreAssert = false;
                ignoreAssert = this.playerState == null ? true : this.playerState.optBoolean("error", false);
                if (ignoreAssert) {
                    System.err.println("Ignoring Assert Player state is null");
                }
                this.playerState = musicPlayerRemote.getPlayerState();
                boolean playbackNewState = this.playerState.optInt("playerState", 0) > 0;
                String trackName = this.playerState.optString("artist", "") + "\n" + this.playerState.optString("title", "");
                if (!trackName.equals(this.currentTrack)) {
                    if (this.getArtwork() != null) {
                        this.albumArtwork.setIcon(new ImageIcon(this.getArtwork()));
                    } else {
                        this.resetAlbumArt();
                    }
                }
                this.currentTrack = trackName;
                this.trackDuration = this.playerState.optInt("duration", 0);
                this.trackPosition = this.playerState.optInt("position", 0);
                String timeProgress = TunesDirector.getDurationBreakdown(this.trackPosition) + " / " + TunesDirector.getDurationBreakdown(this.trackDuration);
                this.playerState.put("timeProgress", timeProgress);
                this.playerState.put("fadeDirection", this.fadeDirection);
                this.playerState.put("player", this.settings.optString("player"));
                this.playerState.put("host", this.hostname);
                if (playbackNewState != this.isPlaying) {
                    if (this.settings.optBoolean("assertControl", false) && !ignoreAssert) {
                        if (this.assertedPlaybackState && !playbackNewState) {
                            new Thread(() -> this.play()).start();
                            System.err.println("Asserting control: play");
                        } else if (!this.assertedPlaybackState && playbackNewState) {
                            new Thread(() -> this.pause()).start();
                            System.err.println("Asserting control: pause");
                        } else {
                            this.isPlaying = playbackNewState;
                            new Thread(() -> this.onPlaybackChange(this.isPlaying)).start();
                        }
                    } else {
                        this.isPlaying = playbackNewState;
                        this.assertedPlaybackState = playbackNewState;
                        new Thread(() -> this.onPlaybackChange(this.isPlaying)).start();
                    }
                }
                this.webServer.updateState(this.playerState);
                if (this.routeputInterface != null) {
                    this.routeputInterface.updateState(this.playerState);
                }
                this.trackLabel.setText(this.currentTrack + "\n" + timeProgress);
                this.songProgress.setMaximum(this.trackDuration);
                this.songProgress.setValue(this.trackPosition);
                int volume = this.playerState.optInt("volume", 0);
                if (this.settings.optBoolean("assertControl", false) && !ignoreAssert) {
                    int slider1Value;
                    int sliderCurrentVolume;
                    int assertedVolume = this.volumeSlider.getValue();
                    if (volume != assertedVolume && this.fadeDirection == 0) {
                        musicPlayerRemote.setVolume(assertedVolume);
                        System.err.println("Asserting volume: " + String.valueOf(assertedVolume) + " (" + String.valueOf(volume) + ")");
                    }
                    if (!this.isFaded && this.fadeDirection == 0) {
                        this.preFadeVolumeSlider.setValue(assertedVolume);
                    }
                    if (this.controlBoxConnection != null && System.currentTimeMillis() > this.volumeReadLockoutUntil && this.controlBoxConnection.isConnected() && (sliderCurrentVolume = volumeMap[slider1Value = this.controlBoxConnection.getProperties().optInt("slider1", 0)]) != assertedVolume) {
                        int sliderNewValue = this.volumeToMaxSlider(assertedVolume);
                        System.err.println(" Updating volume slide to asserted volume " + String.valueOf(assertedVolume) + " = " + String.valueOf(sliderNewValue));
                        this.controlBoxConnection.updateSlider(1, sliderNewValue);
                    }
                } else if (System.currentTimeMillis() > this.volumeReadLockoutUntil) {
                    int slider1Value;
                    int sliderCurrentVolume;
                    this.volumeSlider.setValue(volume);
                    if (!this.isFaded && this.fadeDirection == 0) {
                        this.preFadeVolumeSlider.setValue(volume);
                    }
                    if (this.controlBoxConnection != null && this.controlBoxConnection.isConnected() && (sliderCurrentVolume = volumeMap[slider1Value = this.controlBoxConnection.getProperties().optInt("slider1", 0)]) != volume) {
                        int sliderNewValue = this.volumeToMaxSlider(volume);
                        System.err.println(" Updating volume slide " + String.valueOf(volume) + " = " + String.valueOf(sliderNewValue));
                        this.controlBoxConnection.updateSlider(1, sliderNewValue);
                    }
                }
                this.shuffleButton.setSelected(this.playerState.optBoolean("shuffle", false));
                this.repeatButton.setSelected(this.playerState.optBoolean("repeat", false));
                boolean controlBoxProtocol = this.settings.optBoolean("controlBoxProtocol", false);
                Object remoteStatus = "";
                if (controlBoxProtocol && this.controlBoxConnection != null && this.controlBoxConnection.isConnected()) {
                    remoteStatus = (String)remoteStatus + " +" + this.controlBoxConnection.getControlBoxName();
                    this.controlBoxConnection.displayTextLine(2, this.playerState.optString("artist", ""));
                    this.controlBoxConnection.displayTextLine(3, this.playerState.optString("title", ""));
                    if (this.isPlaying) {
                        if (this.fadeDirection == -1) {
                            this.controlBoxConnection.displayTextLine(1, "- Fading");
                        } else if (this.fadeDirection == 1) {
                            this.controlBoxConnection.displayTextLine(1, "+ Fading");
                        } else {
                            this.controlBoxConnection.displayTextLine(1, "> Playing");
                        }
                    } else {
                        this.controlBoxConnection.displayTextLine(1, "|| Paused");
                    }
                    this.controlBoxConnection.displayTextLine(4, timeProgress);
                }
                if ((wsc = this.webServer.getWebSocketConnectionCount()) > 0) {
                    remoteStatus = wsc == 1 ? (String)remoteStatus + " +1 WebSocket" : (String)remoteStatus + " +" + String.valueOf(wsc) + " WebSockets";
                }
                if (this.routeputInterface != null && (rcc = this.routeputInterface.getConnectionCount()) > 0) {
                    remoteStatus = rcc == 1 ? (String)remoteStatus + " +1 openstatic.org" : (String)remoteStatus + " +" + String.valueOf(rcc) + " openstatic.org";
                }
                for (GamepadController gpc : this.gamepads.values()) {
                    if (!gpc.isEnabled()) continue;
                    remoteStatus = (String)remoteStatus + " +" + gpc.getControllerName();
                }
                if ("".equals(remoteStatus)) {
                    this.statusLabel.setText(" No Remote Connected!");
                    this.statusLabel.setForeground(Color.YELLOW);
                } else {
                    this.statusLabel.setText((String)remoteStatus);
                    this.statusLabel.setForeground(Color.GREEN);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        this.trackLabel.setText("Please Wait\nShutting Down");
    }

    public void onPlaybackChange(boolean state) {
        if (!state) {
            this.pauseButton.setBackground(Color.YELLOW);
            this.pauseButton.setOpaque(true);
            this.playButton.setOpaque(false);
            this.playButton.setBackground(null);
        } else {
            this.playButton.setBackground(Color.GREEN);
            this.playButton.setOpaque(true);
            this.pauseButton.setOpaque(false);
            this.pauseButton.setBackground(null);
        }
    }

    public static int map(int x, int in_min, int in_max, int out_min, int out_max) {
        return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
    }

    public static synchronized BufferedImage getCachedImage(String url, String size) {
        String key;
        if (size == null) {
            size = "";
        }
        if (cachedImages.containsKey(key = size + "-" + url)) {
            return cachedImages.get(key);
        }
        try {
            BufferedImage image = null;
            if (url.startsWith("http://") || url.startsWith("https://")) {
                System.err.println("Downloading " + url + " ...");
                URL url2 = new URL(url);
                image = ImageIO.read(url2);
            } else if (url.startsWith("/")) {
                System.err.print("READING " + url + " ...");
                image = ImageIO.read(TunesDirector.class.getResourceAsStream(url));
            }
            if (image != null) {
                BufferedImage ri = TunesDirector.resizeImage(size, image, true);
                cachedImages.put(key, ri);
                return ri;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return null;
    }

    public static String getDurationBreakdown(long seconds) {
        DecimalFormat formatter = new DecimalFormat("#00");
        long days = TimeUnit.SECONDS.toDays(seconds);
        long hours = TimeUnit.SECONDS.toHours(seconds -= TimeUnit.DAYS.toSeconds(days));
        long minutes = TimeUnit.SECONDS.toMinutes(seconds -= TimeUnit.HOURS.toSeconds(hours));
        seconds -= TimeUnit.MINUTES.toSeconds(minutes);
        StringBuilder sb = new StringBuilder(64);
        sb.append(formatter.format(minutes));
        sb.append(":");
        sb.append(formatter.format(seconds));
        return sb.toString();
    }

    public static BufferedImage resizeImage(String amount, BufferedImage in_image, boolean alpha) {
        AffineTransform at;
        if ("".equals(amount) || amount == null) {
            return in_image;
        }
        float scale_to_float = 0.0f;
        float w = 0.0f;
        float h2 = 0.0f;
        float o_w = in_image.getWidth();
        float o_h = in_image.getHeight();
        if (amount.contains("x")) {
            String[] spl = amount.split("x");
            w = Float.valueOf(spl[0]).floatValue();
            h2 = Float.valueOf(spl[1]).floatValue();
        } else {
            scale_to_float = Float.valueOf(amount).floatValue();
            w = o_w * scale_to_float;
            h2 = o_h * scale_to_float;
        }
        if (!alpha) {
            at = new AffineTransform();
            at.scale(w / o_w, h2 / o_h);
            AffineTransformOp scaleOp = new AffineTransformOp(at, 2);
            BufferedImage rgbi = new BufferedImage(in_image.getWidth(), in_image.getHeight(), 1);
            rgbi.createGraphics().drawImage(in_image, 0, 0, Color.WHITE, null);
            BufferedImage ri = new BufferedImage((int)w, (int)h2, 1);
            scaleOp.filter(rgbi, ri);
            return ri;
        }
        at = new AffineTransform();
        at.scale(w / o_w, h2 / o_h);
        AffineTransformOp scaleOp = new AffineTransformOp(at, 2);
        BufferedImage rgbi = new BufferedImage(in_image.getWidth(), in_image.getHeight(), 2);
        rgbi.createGraphics().drawImage(in_image, 0, 0, new Color(1.0f, 1.0f, 1.0f, 0.0f), null);
        BufferedImage ri = new BufferedImage((int)w, (int)h2, 2);
        scaleOp.filter(rgbi, ri);
        return ri;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        System.err.println("Action Command: " + command);
        if ("play".equals(command)) {
            this.play();
        } else if ("pause".equals(command)) {
            this.pause();
        } else if ("previous".equals(command)) {
            this.previous();
        } else if ("next".equals(command)) {
            this.next();
        } else if ("repeat".equals(command)) {
            this.setRepeat(this.repeatButton.isSelected());
        } else if ("shuffle".equals(command)) {
            this.setShuffle(this.shuffleButton.isSelected());
        } else if ("exit".equals(command)) {
            System.exit(0);
        } else if ("controlbox".equals(command)) {
            boolean currentState = this.controlBoxProtocolMenuItem.isSelected();
            if (currentState) {
                System.err.println("ControlBox State ON");
            } else {
                System.err.println("ControlBox State OFF");
            }
            this.setControlBoxProtocol(currentState);
        } else if ("alwaystop".equals(command)) {
            boolean currentState = this.alwaysOnTopMenuItem.isSelected();
            this.settings.put("alwaysOnTop", currentState);
            this.setAlwaysOnTop(currentState);
        } else if ("about".equals(command)) {
            TunesDirector.browseTo("https://openstatic.org/projects/tunesdirector/");
        } else if ("webserver".equals(command)) {
            boolean currentState = this.webServerMenuItem.isSelected();
            this.setWebServerState(currentState);
        } else if ("routeput".equals(command)) {
            boolean currentState = this.routeputMenuItem.isSelected();
            this.setRouteputState(currentState);
        } else if ("fadeout".equals(command)) {
            boolean currentState = this.fadeOutOnPauseMenuItem.isSelected();
            this.settings.put("fadeOut", currentState);
            this.preFadeVolumeSlider.setVisible(currentState);
            this.preFadeLabel.setVisible(currentState);
        } else if ("assert".equals(command)) {
            boolean currentState = this.assertControlOverPlayer.isSelected();
            this.settings.put("assertControl", currentState);
        } else if ("openweb".equals(command)) {
            TunesDirector.browseTo(this.getWebInterfaceURL());
        } else if ("openopenstatic".equals(command)) {
            if (this.routeputInterface != null) {
                TunesDirector.browseTo(this.routeputInterface.getURLString());
            }
        } else if ("lockskip".equals(command)) {
            boolean currentState = this.lockNextUnlessPausedMenuItem.isSelected();
            this.settings.put("lockSkip", currentState);
        } else if (command.startsWith("player-")) {
            this.selectPlayer(command.substring(7));
        } else if ("configure-player".equals(command)) {
            this.configure(this);
        } else if ("rtransport".equals(command)) {
            boolean currentState = this.remoteTransportControl.isSelected();
            JSONObject rtchange = new JSONObject();
            rtchange.put("transportControl", currentState);
            this.webServer.broadcastJSONObject(rtchange);
            this.settings.put("remoteTransportControl", currentState);
            if (this.routeputInterface != null) {
                this.routeputInterface.send(rtchange);
            }
        } else if ("rvolume".equals(command)) {
            boolean currentState = this.remoteVolumeControl.isSelected();
            JSONObject rtchange = new JSONObject();
            rtchange.put("volumeControl", currentState);
            this.webServer.broadcastJSONObject(rtchange);
            this.settings.put("remoteVolumeControl", currentState);
            if (this.routeputInterface != null) {
                this.routeputInterface.send(rtchange);
            }
        } else if ("searchlibrary".equals(command)) {
            LibrarySearch ls = new LibrarySearch(this, this, "Enqueue");
            ls.getTracks().forEach(track -> this.enqueue((MusicPlayerTrack)track));
        }
    }

    public void setRouteputState(boolean value) {
        this.settings.put("routeput", value);
        this.openOpenstaticMenuItem.setEnabled(value);
        if (value) {
            if (this.routeputInterface == null) {
                this.routeputInterface = new RouteputInterface();
            }
        } else if (this.routeputInterface != null) {
            this.routeputInterface.shutdown();
            this.routeputInterface = null;
        }
    }

    public void setWebServerState(boolean value) {
        this.settings.put("webServer", value);
        this.webServer.setState(value);
        this.openWebMenuItem.setEnabled(value);
    }

    public void setControlBoxProtocol(boolean value) {
        this.settings.put("controlBoxProtocol", value);
        if (value) {
            System.err.println("Enabled controlbox");
            Thread t = new Thread(() -> {
                String localIp = TunesDirector.getLocalIP();
                if (localIp.startsWith("10.10.10.")) {
                    System.err.println("Found AP IP");
                    this.controlBoxConnection = new ControlBoxConnection(this.controlBoxDeviceId, "ws://10.10.10.1:81/", "BoxHotspot", this);
                    this.controlBoxConnection.connect();
                } else if (this.controlBoxConnection != null) {
                    this.controlBoxConnection.connect();
                }
            });
            t.start();
        } else {
            System.err.println("Disabled controlbox");
            if (this.controlBoxConnection != null) {
                this.controlBoxConnection.close();
            }
        }
    }

    public static void copyText(String text) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), null);
    }

    public static boolean browseTo(String url) {
        try {
            CopyOrGo copyOrGo = new CopyOrGo((Frame)instance, url);
            copyOrGo.setVisible(true);
            return true;
        }
        catch (Exception dt_ex) {
            return false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        System.err.println("CtrlBox propertyChange " + evt.getPropertyName());
        if (this.settings.optBoolean("remoteTransportControl", true)) {
            long clickTime;
            if (evt.getPropertyName().equals("whiteButton") && evt.getNewValue().equals(1)) {
                if (this.isPlaying) {
                    this.pause();
                } else {
                    this.play();
                }
            }
            if (evt.getPropertyName().equals("blackButton") && evt.getNewValue().equals(1) && (clickTime = System.currentTimeMillis()) - this.lastNextClickMillis > 1000L) {
                this.lastNextClickMillis = clickTime;
                this.next();
            }
        }
        if (evt.getPropertyName().equals("slider1") && this.settings.optBoolean("remoteVolumeControl", true) && !this.isFaded && this.fadeDirection == 0) {
            Integer sliderValue = (Integer)evt.getNewValue();
            int newVolume = volumeMap[sliderValue];
            System.err.println("Slider 1 volume request = " + String.valueOf(newVolume));
            this.setVolume(newVolume);
        }
    }

    @Override
    public void play() {
        if (this.fadeDirection == 0) {
            if (this.settings.optBoolean("fadeOut", false) && this.isFaded) {
                System.err.println("Goint to fade in");
                musicPlayerRemote.play();
                this.assertedPlaybackState = true;
                this.fadeDirection = 1;
                Thread playThread = new Thread(() -> {
                    for (int i = 0; i < this.preFadeVolumeSlider.getValue(); ++i) {
                        try {
                            this.volumeReadLockoutUntil = System.currentTimeMillis() + 5000L;
                            this.volumeSlider.setValue(i);
                            musicPlayerRemote.setVolume(i);
                            Thread.sleep(10L);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.fadeDirection = 0;
                    this.isFaded = false;
                });
                playThread.start();
            } else {
                musicPlayerRemote.play();
                this.assertedPlaybackState = true;
            }
        }
    }

    @Override
    public void pause() {
        if (this.fadeDirection == 0) {
            int currentVolume = this.playerState.optInt("volume", 100);
            if (this.settings.optBoolean("fadeOut", false) && currentVolume > 0 && !this.isFaded) {
                this.fadeDirection = -1;
                System.err.println("Goint to fade out");
                Thread pauseThread = new Thread(() -> {
                    for (int i = this.preFadeVolumeSlider.getValue(); i > 0; --i) {
                        try {
                            this.volumeReadLockoutUntil = System.currentTimeMillis() + 5000L;
                            this.volumeSlider.setValue(i);
                            musicPlayerRemote.setVolume(i);
                            Thread.sleep(10L);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.isFaded = true;
                    this.assertedPlaybackState = false;
                    musicPlayerRemote.pause();
                    this.fadeDirection = 0;
                });
                pauseThread.start();
            } else {
                this.assertedPlaybackState = false;
                musicPlayerRemote.pause();
                this.fadeDirection = 0;
            }
        }
    }

    @Override
    public void next() {
        boolean lockSkip = this.settings.optBoolean("lockSkip", false);
        if (!(this.fadeDirection != 0 || lockSkip && this.isPlaying)) {
            musicPlayerRemote.next();
        }
    }

    @Override
    public void previous() {
        boolean lockSkip = this.settings.optBoolean("lockSkip", false);
        if (!(this.fadeDirection != 0 || lockSkip && this.isPlaying)) {
            musicPlayerRemote.previous();
        }
    }

    @Override
    public JSONObject getPlayerState() {
        return this.playerState;
    }

    int volumeToMaxSlider(int volume) {
        for (int i = 127; i >= 0; --i) {
            if (volume != volumeMap[i]) continue;
            return i;
        }
        return 0;
    }

    @Override
    public void setVolume(int volume) {
        if (!this.isFaded && this.fadeDirection == 0) {
            System.err.println("SETTING VOLUME: " + String.valueOf(volume));
            this.volumeReadLockoutUntil = System.currentTimeMillis() + 5000L;
            this.volumeSlider.setValue(volume);
        }
    }

    public String getWebInterfaceURL() {
        String localIP = TunesDirector.getLocalIP();
        return "http://" + localIP + ":6323/";
    }

    public static String getLocalIP() {
        String return_ip = "";
        try {
            Enumeration<NetworkInterface> n = NetworkInterface.getNetworkInterfaces();
            while (n.hasMoreElements()) {
                NetworkInterface ni = n.nextElement();
                Enumeration<InetAddress> e = ni.getInetAddresses();
                while (e.hasMoreElements()) {
                    InetAddress ia = e.nextElement();
                    String this_ip = ia.getHostAddress();
                    if (ia.isLoopbackAddress() || !ia.isSiteLocalAddress()) continue;
                    return_ip = this_ip;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return return_ip;
    }

    public static String shellExec(String[] cmd) {
        try {
            Process cmdProc = Runtime.getRuntime().exec(cmd);
            cmdProc.waitFor();
            return TunesDirector.readStreamToString(cmdProc.getInputStream());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String readStreamToString(InputStream is) {
        String result = "";
        try {
            Scanner s2 = new Scanner(is).useDelimiter("\\A");
            result = s2.hasNext() ? s2.next() : "";
            s2.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String getLocalHostname() {
        String hostname;
        Map<String, String> env = System.getenv();
        if (env.containsKey("COMPUTERNAME")) {
            return env.get("COMPUTERNAME");
        }
        if (env.containsKey("HOSTNAME")) {
            return env.get("HOSTNAME");
        }
        String hostnameCommand = TunesDirector.shellExec(new String[]{"hostname"});
        if (hostnameCommand != null && !"".equals(hostname = hostnameCommand.trim())) {
            return hostname;
        }
        try {
            Enumeration<NetworkInterface> n = NetworkInterface.getNetworkInterfaces();
            while (n.hasMoreElements()) {
                NetworkInterface ni = n.nextElement();
                Enumeration<InetAddress> e = ni.getInetAddresses();
                while (e.hasMoreElements()) {
                    InetAddress ia = e.nextElement();
                    if (ia.isLoopbackAddress() || !ia.isSiteLocalAddress()) continue;
                    String hostname2 = ia.getHostName();
                    return hostname2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "unknown-host";
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == this.volumeSlider && this.fadeDirection == 0) {
            System.err.println("Volume Changed by Java Slider: " + String.valueOf(this.volumeSlider.getValue()));
            this.volumeReadLockoutUntil = System.currentTimeMillis() + 5000L;
            if (this.playerState.optInt("volume", this.volumeSlider.getValue()) != this.volumeSlider.getValue()) {
                System.err.println("Sending change to player");
                musicPlayerRemote.setVolume(this.volumeSlider.getValue());
            } else {
                System.err.println("NON CHANGE");
            }
        }
    }

    public synchronized JRadioButtonMenuItem getRemoteTunesDirectorEntry(String host) {
        try {
            return this.remoteTunesDirectorMenuItems.stream().filter(item -> item.getActionCommand().endsWith(host)).findFirst().get();
        }
        catch (Exception e) {
            return null;
        }
    }

    public synchronized JRadioButtonMenuItem createRemoteTunesDirectorEntry(String displayName, String host) {
        JRadioButtonMenuItem existingEntry = this.getRemoteTunesDirectorEntry(host);
        Object displayText = displayName + " (" + host + ")";
        if (host.equals(displayName)) {
            displayText = displayName;
        }
        if (existingEntry != null) {
            existingEntry.setText((String)displayText);
            return existingEntry;
        }
        JRadioButtonMenuItem newRemoteEntry = new JRadioButtonMenuItem((String)displayText);
        newRemoteEntry.setIcon(this.getIcon("/icon48.png"));
        newRemoteEntry.setActionCommand("player-remote-" + host);
        newRemoteEntry.addActionListener(this);
        this.remoteTunesDirectorMenuItems.add(newRemoteEntry);
        this.playerButtonGroup.add(newRemoteEntry);
        this.playerMenu.add((Component)newRemoteEntry, 0);
        return newRemoteEntry;
    }

    public synchronized void destroyRemoteTunesDirectorEntry(String host) {
        JRadioButtonMenuItem remoteEntry = this.getRemoteTunesDirectorEntry(host);
        if (remoteEntry != null) {
            this.playerMenu.remove(remoteEntry);
            this.playerButtonGroup.remove(remoteEntry);
            this.remoteTunesDirectorMenuItems.remove(remoteEntry);
        }
    }

    public void selectPlayer(String playerName) {
        if (playerName != null) {
            this.playerState = null;
            System.err.println("Selected Player: " + playerName);
            String os_name = System.getProperty("os.name").toLowerCase();
            if ("itunes".equals(playerName)) {
                this.settings.put("player", playerName);
                this.itunesPlayerMenuItem.setSelected(true);
                if (os_name.contains("win")) {
                    musicPlayerRemote = new VBScriptRemote();
                } else if (os_name.contains("mac")) {
                    musicPlayerRemote = new OSAScriptRemote();
                }
            } else if ("spotify".equals(playerName)) {
                this.settings.put("player", playerName);
                this.spotifyPlayerMenuItem.setSelected(true);
                musicPlayerRemote = new SpotifyRemote(this.settings);
            } else if ("audacious".equals(playerName)) {
                if (os_name.contains("win")) {
                    if (!this.settings.has("audToolPath")) {
                        File x86Path = new File("c:\\Program Files (x86)\\Audacious\\bin\\audtool.exe");
                        File regPath = new File("c:\\Program Files\\Audacious\\bin\\audtool.exe");
                        if (x86Path.exists()) {
                            this.settings.put("audToolPath", x86Path.toString());
                        } else if (regPath.exists()) {
                            this.settings.put("audToolPath", regPath);
                        }
                    }
                } else if (os_name.contains("linux")) {
                    File normalAudtoolPath = new File("/usr/bin/audtool");
                    if (normalAudtoolPath.exists()) {
                        String audToolPath = normalAudtoolPath.toString();
                        System.err.println("Found system audtool: " + audToolPath);
                        this.settings.put("audToolPath", audToolPath);
                    } else {
                        try {
                            File audtoolTemp = File.createTempFile("audtool", "");
                            FileOutputStream fos = new FileOutputStream(audtoolTemp);
                            InputStream audtoolIS = this.getClass().getResourceAsStream("/audtool");
                            while (audtoolIS.available() > 0) {
                                fos.write(audtoolIS.readAllBytes());
                            }
                            audtoolIS.close();
                            fos.close();
                            String audToolPath = audtoolTemp.getAbsolutePath();
                            System.err.println("Extracted internal audtool: " + audToolPath);
                            Process cmdProc = Runtime.getRuntime().exec("/bin/chmod +x " + audToolPath);
                            cmdProc.waitFor();
                            this.settings.put("audToolPath", audToolPath);
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                        }
                    }
                }
                this.settings.put("player", playerName);
                this.audaciousPlayerMenuItem.setSelected(true);
                musicPlayerRemote = new AudaciousRemote(this.settings);
            } else if ("mpd".equals(playerName)) {
                this.settings.put("player", playerName);
                this.mpdPlayerMenuItem.setSelected(true);
                musicPlayerRemote = new MPDRemote(this.settings);
            } else if (playerName.startsWith("remote")) {
                this.settings.put("player", playerName);
                if ("remote".equals(playerName)) {
                    this.remoteTunesDirectorPlayerMenuItem.setSelected(true);
                    musicPlayerRemote = new TunesDirectorRemote(this.settings);
                } else {
                    String host = playerName.substring(7);
                    System.err.println("Selected Remote host=" + host);
                    JRadioButtonMenuItem remoteEntry = this.getRemoteTunesDirectorEntry(host);
                    if (remoteEntry != null) {
                        remoteEntry.setSelected(true);
                    } else {
                        remoteEntry = this.createRemoteTunesDirectorEntry(host, host);
                        remoteEntry.setSelected(true);
                    }
                    musicPlayerRemote = new TunesDirectorRemote(host);
                }
            }
        }
    }

    @Override
    public void configure(Component parent) {
        musicPlayerRemote.configure(parent);
    }

    @Override
    public void serviceAdded(ServiceEvent event) {
    }

    @Override
    public void serviceRemoved(ServiceEvent event) {
        ServiceInfo serviceInfo = event.getInfo();
        String serviceName = serviceInfo.getName().toLowerCase();
        if (serviceName.startsWith("TunesDirector")) {
            Inet4Address[] addresses = serviceInfo.getInet4Addresses();
            String addr = addresses[0].toString().substring(1);
            System.err.println("Removing Host selection in player menu for " + serviceName + "/" + addr);
            this.destroyRemoteTunesDirectorEntry(addr);
        }
    }

    @Override
    public void serviceResolved(ServiceEvent event) {
        ServiceInfo serviceInfo = event.getInfo();
        int port = serviceInfo.getPort();
        String serviceName = serviceInfo.getName();
        Inet4Address[] addresses = serviceInfo.getInet4Addresses();
        String addr = addresses[0].toString().substring(1);
        if (serviceName.toLowerCase().endsWith("box") && port == 81) {
            boolean reconnect = false;
            String url = "ws://" + addr + ":" + String.valueOf(port);
            System.out.println("Service resolved: " + url);
            if (this.controlBoxConnection == null) {
                reconnect = true;
            } else if (!this.controlBoxConnection.getWSUri().equals(url)) {
                reconnect = true;
            } else if (!this.controlBoxConnection.isConnected()) {
                reconnect = true;
            }
            if (reconnect) {
                this.controlBoxConnection = new ControlBoxConnection(this.controlBoxDeviceId, url, serviceInfo.getName(), this);
            }
        } else if (serviceName.startsWith("TunesDirector ")) {
            String serviceHostname = serviceName.substring(serviceName.indexOf(" ") + 1);
            if (!serviceHostname.equals(this.hostname)) {
                System.err.println("Found another TunesDirector: " + serviceHostname + "/" + addr);
                this.createRemoteTunesDirectorEntry(serviceHostname, addr);
            }
        } else {
            System.err.println("not a controlbox: " + serviceInfo.getName());
        }
    }

    @Override
    public void setRepeat(boolean value) {
        musicPlayerRemote.setRepeat(value);
    }

    @Override
    public void setShuffle(boolean value) {
        musicPlayerRemote.setShuffle(value);
    }

    @Override
    public Collection<MusicPlayerTrack> searchLibrary(String text) {
        return musicPlayerRemote.searchLibrary(text);
    }

    @Override
    public Collection<MusicPlayerTrack> getPlaylist() {
        return musicPlayerRemote.getPlaylist();
    }

    @Override
    public void enqueue(MusicPlayerTrack track) {
        musicPlayerRemote.enqueue(track);
    }

    @Override
    public void jump(MusicPlayerTrack track) {
        musicPlayerRemote.jump(track);
    }

    @Override
    public BufferedImage getArtwork() {
        return musicPlayerRemote.getArtwork();
    }

    static {
        cachedImages = new LinkedHashMap();
        forceWidth = 0;
        forceHeight = 450;
        forceX = 30;
        forceY = 30;
        volumeMap = new int[128];
    }
}

