/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.openstatic.TunesDirector;
import org.openstatic.api.MusicPlayerRemote;
import org.openstatic.api.spotify.SpotifyRemote;

public class WebServer {
    private Server httpServer;
    protected ArrayList<WebSocketSession> wsSessions;
    protected static WebServer instance;
    private String staticRoot;
    private MusicPlayerRemote musicPlayerRemote;
    private JSONObject state;

    public WebServer(MusicPlayerRemote remote) {
        instance = this;
        this.musicPlayerRemote = remote;
        this.wsSessions = new ArrayList();
        this.httpServer = new Server(6323);
        ServletContextHandler context = new ServletContextHandler(0);
        context.setContextPath("/");
        context.addServlet(ApiServlet.class, "/api/*");
        context.addServlet(EventsWebSocketServlet.class, "/events/*");
        try {
            URL url = WebServer.class.getResource("/index.html");
            this.staticRoot = url.toString().replaceAll("index.html", "");
            DefaultServlet defaultServlet = new DefaultServlet();
            ServletHolder holderPwd = new ServletHolder("default", defaultServlet);
            holderPwd.setInitParameter("resourceBase", this.staticRoot);
            context.addServlet(holderPwd, "/*");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        this.httpServer.setHandler(context);
    }

    public void handleWebSocketEvent(JSONObject j, WebSocketSession session) {
        if (j.has("cmd") && TunesDirector.instance.settings.optBoolean("remoteTransportControl", true)) {
            String cmd = j.optString("cmd");
            if ("play".equals(cmd)) {
                this.musicPlayerRemote.play();
            } else if ("pause".equals(cmd)) {
                this.musicPlayerRemote.pause();
            } else if ("previous".equals(cmd)) {
                this.musicPlayerRemote.previous();
            } else if ("next".equals(cmd)) {
                this.musicPlayerRemote.next();
            }
        }
        if (j.has("shuffle") && TunesDirector.instance.settings.optBoolean("remoteTransportControl", true)) {
            this.musicPlayerRemote.setShuffle(j.optBoolean("shuffle", false));
        }
        if (j.has("repeat") && TunesDirector.instance.settings.optBoolean("remoteTransportControl", true)) {
            this.musicPlayerRemote.setRepeat(j.optBoolean("repeat", false));
        }
        if (j.has("volume") && TunesDirector.instance.settings.optBoolean("remoteVolumeControl", true)) {
            this.musicPlayerRemote.setVolume(j.optInt("volume", 0));
        }
        if (j.has("player")) {
            TunesDirector.instance.selectPlayer(j.optString("player"));
        }
    }

    public void setState(boolean b) {
        if (b) {
            try {
                this.httpServer.start();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        } else {
            try {
                this.httpServer.stop();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public void updateState(JSONObject state) {
        this.state = state;
        this.broadcastJSONObject(this.state);
    }

    public void broadcastJSONObject(JSONObject jo) {
        String message = jo.toString();
        for (Session session : this.wsSessions) {
            try {
                session.getRemote().sendStringByFuture(message);
            }
            catch (Exception exception) {}
        }
    }

    public int getWebSocketConnectionCount() {
        return this.wsSessions.size();
    }

    public static class ApiServlet
    extends HttpServlet {
        public JSONObject readJSONObjectPOST(HttpServletRequest request) {
            StringBuffer jb = new StringBuffer();
            String line = null;
            try {
                BufferedReader reader = request.getReader();
                while ((line = reader.readLine()) != null) {
                    jb.append(line);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            try {
                JSONObject jsonObject = new JSONObject(jb.toString());
                return jsonObject;
            }
            catch (JSONException e) {
                e.printStackTrace(System.err);
                return new JSONObject();
            }
        }

        public boolean isNumber(String v) {
            try {
                Integer.parseInt(v);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        protected void doGet(HttpServletRequest request, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            String target = request.getPathInfo();
            System.err.println("Path: " + target);
            try {
                if ("/play/".equals(target)) {
                    httpServletResponse.setContentType("text/javascript");
                    httpServletResponse.setStatus(200);
                    httpServletResponse.setCharacterEncoding("iso-8859-1");
                    WebServer.instance.musicPlayerRemote.play();
                    httpServletResponse.getWriter().println(WebServer.instance.state.toString());
                } else if ("/pause/".equals(target)) {
                    httpServletResponse.setContentType("text/javascript");
                    httpServletResponse.setStatus(200);
                    httpServletResponse.setCharacterEncoding("iso-8859-1");
                    WebServer.instance.musicPlayerRemote.pause();
                    httpServletResponse.getWriter().println(WebServer.instance.state.toString());
                } else if ("/next/".equals(target)) {
                    httpServletResponse.setContentType("text/javascript");
                    httpServletResponse.setStatus(200);
                    httpServletResponse.setCharacterEncoding("iso-8859-1");
                    WebServer.instance.musicPlayerRemote.next();
                    httpServletResponse.getWriter().println(WebServer.instance.state.toString());
                } else if ("/previous/".equals(target)) {
                    httpServletResponse.setContentType("text/javascript");
                    httpServletResponse.setStatus(200);
                    httpServletResponse.setCharacterEncoding("iso-8859-1");
                    WebServer.instance.musicPlayerRemote.previous();
                    httpServletResponse.getWriter().println(WebServer.instance.state.toString());
                } else if ("/spotify/".equals(target)) {
                    httpServletResponse.setContentType("text/html");
                    httpServletResponse.setStatus(200);
                    httpServletResponse.setCharacterEncoding("iso-8859-1");
                    String accessCode = request.getParameter("code");
                    System.err.println("Spotify auth!");
                    if (TunesDirector.musicPlayerRemote instanceof SpotifyRemote) {
                        System.err.println("Spotify Remote found!");
                        SpotifyRemote spotifyRemote = (SpotifyRemote)TunesDirector.musicPlayerRemote;
                        spotifyRemote.receiveAccessCode(accessCode);
                    }
                    httpServletResponse.getWriter().println("<html><body><div style=\"text-align: center; width: 100%;\"><h1>Spotify Authorized!</h2><p>Spotify has been authorized for TunesDirector!</p></div></body></html>");
                } else {
                    httpServletResponse.setContentType("text/javascript");
                    httpServletResponse.setStatus(200);
                    httpServletResponse.setCharacterEncoding("iso-8859-1");
                    httpServletResponse.getWriter().println(WebServer.instance.state.toString());
                }
            }
            catch (Exception x) {
                x.printStackTrace(System.err);
            }
        }
    }

    public static class EventsWebSocketServlet
    extends WebSocketServlet {
        @Override
        public void configure(WebSocketServletFactory factory) {
            factory.register(EventsWebSocket.class);
        }
    }

    @WebSocket
    public static class EventsWebSocket {
        @OnWebSocketMessage
        public void onText(Session session, String message) throws IOException {
            try {
                JSONObject jo = new JSONObject(message);
                if (session instanceof WebSocketSession) {
                    WebSocketSession wssession = (WebSocketSession)session;
                    instance.handleWebSocketEvent(jo, wssession);
                } else {
                    System.err.println("not instance of WebSocketSession");
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }

        @OnWebSocketConnect
        public void onConnect(Session session) throws IOException {
            System.err.println("@OnWebSocketConnect");
            if (session instanceof WebSocketSession) {
                WebSocketSession wssession = (WebSocketSession)session;
                System.out.println(wssession.getRemoteAddress().getHostString() + " connected!");
                WebServer.instance.wsSessions.add(wssession);
                JSONObject greetingPacket = new JSONObject(TunesDirector.instance.getPlayerState().toString());
                greetingPacket.put("transportControl", TunesDirector.instance.settings.optBoolean("remoteTransportControl", true));
                greetingPacket.put("volumeControl", TunesDirector.instance.settings.optBoolean("remoteVolumeControl", true));
                wssession.getRemote().sendStringByFuture(greetingPacket.toString());
            } else {
                System.err.println("Not an instance of WebSocketSession");
            }
        }

        @OnWebSocketClose
        public void onClose(Session session, int status, String reason) {
            if (session instanceof WebSocketSession) {
                WebSocketSession wssession = (WebSocketSession)session;
                WebServer.instance.wsSessions.remove(wssession);
            }
        }
    }
}

