/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.api;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.Event;
import net.java.games.input.EventQueue;
import org.openstatic.TunesDirector;

public class GamepadController
implements Runnable,
ActionListener {
    private Controller controller;
    private boolean enabled;
    private Thread eventThread;
    private JCheckBoxMenuItem menuItem;
    private int volumeDirection = 0;
    private long nextVolumeUpdate;

    public GamepadController(Controller controller) {
        this.controller = controller;
        this.enabled = false;
        this.menuItem = new JCheckBoxMenuItem(this.getControllerName());
        this.menuItem.addActionListener(this);
    }

    public String getControllerName() {
        return this.controller.getName().toLowerCase();
    }

    public JCheckBoxMenuItem getMenuItem() {
        return this.menuItem;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.enabled && this.eventThread == null) {
            this.eventThread = new Thread(this);
            this.eventThread.start();
        }
        this.menuItem.setSelected(enabled);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void run() {
        System.err.println("Controller thread started");
        while (this.enabled) {
            try {
                boolean poll = this.controller.poll();
                EventQueue queue = this.controller.getEventQueue();
                boolean transportControl = TunesDirector.instance.settings.optBoolean("remoteTransportControl", true);
                boolean volumeControl = TunesDirector.instance.settings.optBoolean("remoteVolumeControl", true);
                Event event = new Event();
                while (queue.getNextEvent(event)) {
                    Component comp = event.getComponent();
                    float value = event.getValue();
                    String componentName = comp.getName().toLowerCase();
                    System.err.println("Gamepad Event " + this.getControllerName() + " " + componentName + " = " + String.valueOf(value));
                    if ((componentName.equals("button 0") || componentName.equals("a")) && value > 0.0f) {
                        if (!transportControl) continue;
                        TunesDirector.instance.play();
                        continue;
                    }
                    if ((componentName.equals("button 1") || componentName.equals("b")) && value > 0.0f) {
                        if (!transportControl) continue;
                        TunesDirector.instance.pause();
                        continue;
                    }
                    if ((componentName.equals("button 4") || componentName.equals("left thumb")) && value > 0.0f) {
                        if (!transportControl) continue;
                        TunesDirector.instance.previous();
                        continue;
                    }
                    if ((componentName.equals("button 5") || componentName.equals("right thumb")) && value > 0.0f) {
                        if (!transportControl) continue;
                        TunesDirector.instance.next();
                        continue;
                    }
                    if (componentName.equals("z axis")) {
                        if ((double)value > 0.2 && value < 1.0f) {
                            this.volumeDirection = -1;
                            continue;
                        }
                        if ((double)value < -0.2 && value > -1.0f) {
                            this.volumeDirection = 1;
                            continue;
                        }
                        this.volumeDirection = 0;
                        continue;
                    }
                    if (componentName.equals("hat switch") || componentName.equals("pov")) {
                        if ((double)value == 0.25) {
                            this.volumeDirection = 1;
                            continue;
                        }
                        if ((double)value == 0.75) {
                            this.volumeDirection = -1;
                            continue;
                        }
                        if (value == 1.0f) {
                            if (!transportControl) continue;
                            TunesDirector.instance.previous();
                            continue;
                        }
                        if ((double)value == 0.5) {
                            if (!transportControl) continue;
                            TunesDirector.instance.next();
                            continue;
                        }
                        this.volumeDirection = 0;
                        continue;
                    }
                    if (componentName.equals("z")) {
                        if (value > 0.0f) {
                            this.volumeDirection = -1;
                            continue;
                        }
                        this.volumeDirection = 0;
                        continue;
                    }
                    if (!componentName.equals("rz")) continue;
                    if (value > 0.0f) {
                        this.volumeDirection = 1;
                        continue;
                    }
                    this.volumeDirection = 0;
                }
                Thread.sleep(20L);
                long ts = System.currentTimeMillis();
                if (ts <= this.nextVolumeUpdate || this.volumeDirection == 0 || !volumeControl) continue;
                TunesDirector.instance.setVolume(TunesDirector.instance.volumeSlider.getValue() + this.volumeDirection);
                this.nextVolumeUpdate = ts + 200L;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        this.eventThread = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setEnabled(this.menuItem.isSelected());
    }
}

