/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.api.audacious;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.json.JSONObject;
import org.openstatic.TunesDirector;
import org.openstatic.api.MusicPlayerRemote;
import org.openstatic.api.MusicPlayerTrack;

public class AudaciousRemote
implements MusicPlayerRemote {
    JSONObject playerState;
    JSONObject settings;
    String audToolPath;

    public AudaciousRemote(JSONObject settings) {
        this.settings = settings;
        this.audToolPath = settings.optString("audToolPath", "audtool");
        JSONObject stateObj = new JSONObject();
        stateObj.put("artist", "ERROR");
        stateObj.put("title", "No Audacious Connection");
        stateObj.put("playerState", 0);
        stateObj.put("duration", 0);
        stateObj.put("position", 0);
        stateObj.put("volume", 0);
        stateObj.put("repeat", false);
        stateObj.put("shuffle", false);
        stateObj.put("lastStateFetch", System.currentTimeMillis());
        stateObj.put("error", true);
        this.playerState = stateObj;
    }

    public static String shellExec(String[] cmd) {
        try {
            Process cmdProc = Runtime.getRuntime().exec(cmd);
            cmdProc.waitFor();
            return TunesDirector.readStreamToString(cmdProc.getInputStream());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public <T> T[] concatenate(T[] a, T[] b) {
        int aLen = a.length;
        int bLen = b.length;
        Object[] c = (Object[])Array.newInstance(a.getClass().getComponentType(), aLen + bLen);
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    public void executeAudtoolCommand(String[] commands) {
        String[] args = new String[]{"current-song", "current-song-length-seconds", "playback-status", "current-song-output-length-seconds", "get-volume", "playlist-repeat-status", "playlist-shuffle-status"};
        String data = AudaciousRemote.shellExec(this.concatenate(new String[]{this.audToolPath}, this.concatenate(commands, args))).trim();
        if (!data.equals("")) {
            StringTokenizer st = new StringTokenizer(data, "\n");
            String artistTitle = st.nextToken();
            String artist = "";
            String title = "";
            if (artistTitle.contains(" - ")) {
                StringTokenizer st2 = new StringTokenizer(artistTitle, "-");
                artist = st2.nextToken().trim();
                while (st2.hasMoreTokens()) {
                    title = st2.nextToken().trim();
                }
            } else {
                title = artistTitle;
            }
            int duration = 0;
            try {
                duration = Float.valueOf(st.nextToken().trim()).intValue();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String playbackState = st.nextToken().trim();
            int position = 0;
            try {
                position = Float.valueOf(st.nextToken().trim()).intValue();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int volume = 0;
            try {
                volume = Integer.valueOf(st.nextToken().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean repeatStatus = false;
            try {
                repeatStatus = !st.nextToken().trim().equals("off");
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean shuffleStatus = false;
            try {
                shuffleStatus = !st.nextToken().trim().equals("off");
            }
            catch (Exception exception) {
                // empty catch block
            }
            JSONObject state = new JSONObject();
            state.put("title", title);
            state.put("artist", artist);
            state.put("duration", duration);
            state.put("position", position);
            state.put("playerState", "playing".equals(playbackState) ? 1 : 0);
            state.put("volume", volume);
            state.put("repeat", repeatStatus);
            state.put("shuffle", shuffleStatus);
            state.put("lastStateFetch", System.currentTimeMillis());
            this.playerState = state;
        } else {
            JSONObject state = new JSONObject();
            state.put("artist", "ERROR");
            state.put("title", "No Audacious Connection");
            state.put("playerState", 0);
            state.put("duration", 0);
            state.put("position", 0);
            state.put("volume", 0);
            state.put("repeat", false);
            state.put("shuffle", false);
            state.put("lastStateFetch", System.currentTimeMillis());
            state.put("error", true);
            this.playerState = state;
        }
    }

    @Override
    public void play() {
        if (this.playerState.optInt("playerState", 0) == 0) {
            this.executeAudtoolCommand(new String[]{"playback-play"});
        }
    }

    @Override
    public void pause() {
        if (this.playerState.optInt("playerState", 0) == 1) {
            this.executeAudtoolCommand(new String[]{"playback-pause"});
        }
    }

    @Override
    public void next() {
        this.executeAudtoolCommand(new String[]{"playlist-advance"});
    }

    @Override
    public void previous() {
        this.executeAudtoolCommand(new String[]{"playlist-reverse"});
    }

    @Override
    public JSONObject getPlayerState() {
        if (System.currentTimeMillis() - this.playerState.optLong("lastStateFetch", 0L) > 500L) {
            this.executeAudtoolCommand(new String[0]);
        }
        return this.playerState;
    }

    @Override
    public void setVolume(int volume) {
        if (volume > 100) {
            volume = 100;
        }
        if (volume < 0) {
            volume = 0;
        }
        if (volume != this.playerState.optInt("volume", 0)) {
            this.executeAudtoolCommand(new String[]{"set-volume", String.valueOf(volume)});
        }
    }

    @Override
    public void configure(Component parent) {
        JOptionPane.showMessageDialog(parent, "Nothing to configure!");
    }

    @Override
    public void setRepeat(boolean value) {
        if (value != this.playerState.optBoolean("repeat", false)) {
            this.executeAudtoolCommand(new String[]{"playlist-repeat-toggle"});
        }
    }

    @Override
    public void setShuffle(boolean value) {
        if (value != this.playerState.optBoolean("shuffle", false)) {
            this.executeAudtoolCommand(new String[]{"playlist-shuffle-toggle"});
        }
    }

    @Override
    public Collection<MusicPlayerTrack> searchLibrary(String text) {
        return null;
    }

    @Override
    public Collection<MusicPlayerTrack> getPlaylist() {
        return null;
    }

    @Override
    public void enqueue(MusicPlayerTrack track) {
    }

    @Override
    public void jump(MusicPlayerTrack track) {
    }

    @Override
    public BufferedImage getArtwork() {
        return null;
    }
}

