/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.api.itunes;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.json.JSONObject;
import org.openstatic.TunesDirector;
import org.openstatic.api.MusicPlayerRemote;
import org.openstatic.api.MusicPlayerTrack;

public class OSAScriptRemote
implements MusicPlayerRemote {
    JSONObject playerState;

    public OSAScriptRemote() {
        JSONObject stateObj = new JSONObject();
        stateObj.put("artist", "ERROR");
        stateObj.put("title", "No iTunes Connection");
        stateObj.put("playerState", 0);
        stateObj.put("duration", 0);
        stateObj.put("position", 0);
        stateObj.put("volume", 0);
        stateObj.put("repeat", false);
        stateObj.put("shuffle", false);
        stateObj.put("lastStateFetch", System.currentTimeMillis());
        stateObj.put("error", true);
        this.playerState = stateObj;
    }

    public static String shellExec(String[] cmd) {
        try {
            Process cmdProc = Runtime.getRuntime().exec(cmd);
            cmdProc.waitFor();
            return TunesDirector.readStreamToString(cmdProc.getInputStream());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void executeiTunesScript(String text) {
        String stub = "tell app \"iTunes\"";
        String fetch = "get {artist of current track, name of current track, duration of current track, player state, player position, sound volume, shuffle enabled, song repeat}";
        String[] args = new String[]{"osascript", "-e", stub, "-e", text, "-e", fetch, "-e", "end tell"};
        String data = OSAScriptRemote.shellExec(args);
        System.err.println("DATA: " + data);
        StringTokenizer st = new StringTokenizer(data, ",");
        String artist = "";
        try {
            artist = st.nextToken().trim();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String title = "";
        try {
            title = st.nextToken().trim();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int duration = 0;
        try {
            duration = Float.valueOf(st.nextToken().trim()).intValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String playbackState = st.nextToken().trim();
        int position = 0;
        try {
            position = Float.valueOf(st.nextToken().trim()).intValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int volume = 0;
        try {
            volume = Integer.valueOf(st.nextToken().trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean shuffleState = false;
        try {
            shuffleState = st.nextToken().trim().equals("true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean repeatState = false;
        try {
            repeatState = !st.nextToken().trim().equals("off");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JSONObject state = new JSONObject();
        state.put("title", title);
        state.put("artist", artist);
        state.put("duration", duration);
        state.put("position", position);
        state.put("playerState", "playing".equals(playbackState) ? 1 : 0);
        state.put("volume", volume);
        state.put("repeat", repeatState);
        state.put("shuffle", shuffleState);
        state.put("lastStateFetch", System.currentTimeMillis());
        this.playerState = state;
    }

    @Override
    public void play() {
        this.executeiTunesScript("play");
    }

    @Override
    public void pause() {
        this.executeiTunesScript("pause");
    }

    @Override
    public void next() {
        this.executeiTunesScript("play next track");
    }

    @Override
    public void previous() {
        this.executeiTunesScript("play previous track");
    }

    @Override
    public JSONObject getPlayerState() {
        if (System.currentTimeMillis() - this.playerState.optLong("lastStateFetch", 0L) > 500L) {
            this.executeiTunesScript("");
        }
        return this.playerState;
    }

    @Override
    public void setVolume(int volume) {
        if (volume > 100) {
            volume = 100;
        }
        if (volume < 0) {
            volume = 0;
        }
        if (volume != this.playerState.optInt("volume", 0)) {
            this.executeiTunesScript("set sound volume to " + String.valueOf(volume));
        }
    }

    @Override
    public void configure(Component parent) {
        JOptionPane.showMessageDialog(parent, "Nothing to configure!");
    }

    @Override
    public void setRepeat(boolean value) {
        if (value) {
            this.executeiTunesScript("set song repeat to all");
        } else {
            this.executeiTunesScript("set song repeat to off");
        }
    }

    @Override
    public void setShuffle(boolean value) {
        if (value) {
            this.executeiTunesScript("set shuffle enabled to true");
        } else {
            this.executeiTunesScript("set shuffle enabled to false");
        }
    }

    @Override
    public Collection<MusicPlayerTrack> searchLibrary(String text) {
        return null;
    }

    @Override
    public Collection<MusicPlayerTrack> getPlaylist() {
        return null;
    }

    @Override
    public void enqueue(MusicPlayerTrack track) {
    }

    @Override
    public void jump(MusicPlayerTrack track) {
    }

    @Override
    public BufferedImage getArtwork() {
        return null;
    }
}

