/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.api.itunes;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.json.JSONObject;
import org.openstatic.TunesDirector;
import org.openstatic.api.MusicPlayerRemote;
import org.openstatic.api.MusicPlayerTrack;

public class VBScriptRemote
implements MusicPlayerRemote {
    public JSONObject playerState;

    public VBScriptRemote() {
        JSONObject stateObj = new JSONObject();
        stateObj.put("artist", "ERROR");
        stateObj.put("title", "No iTunes Connection");
        stateObj.put("playerState", 0);
        stateObj.put("duration", 0);
        stateObj.put("position", 0);
        stateObj.put("volume", 0);
        stateObj.put("repeat", false);
        stateObj.put("shuffle", false);
        stateObj.put("lastStateFetch", System.currentTimeMillis());
        stateObj.put("error", true);
        this.playerState = stateObj;
    }

    public static String shellExec(String[] cmd) {
        try {
            Process cmdProc = Runtime.getRuntime().exec(cmd);
            cmdProc.waitFor();
            return TunesDirector.readStreamToString(cmdProc.getInputStream());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void executeiTunesScript(String text) {
        try {
            String stub = "Set fso = CreateObject (\"Scripting.FileSystemObject\")\r\nSet stdout = fso.GetStandardStream (1)\r\nDim iTunesApp\r\nSet iTunesApp = CreateObject(\"iTunes.Application\")\r\nstdout.WriteLine \"$%@BEGINOUT$%@\"\r\n";
            String footer = "\r\nstdout.WriteLine \"{\"\"artist\"\": \"\"\" + iTunesApp.CurrentTrack.Artist + \"\"\", \"\"title\"\": \"\"\" +  iTunesApp.CurrentTrack.Name + \"\"\", \"\"playerState\"\": \" +  CStr(iTunesApp.PlayerState)  + \", \"\"position\"\": \" + CStr(iTunesApp.PlayerPosition) + \", \"\"duration\"\": \" +  CStr(iTunesApp.CurrentTrack.Duration)+ \", \"\"volume\"\": \" +  CStr(iTunesApp.SoundVolume) + \", \"\"shuffle\"\": \" +  CStr(iTunesApp.CurrentPlaylist.Shuffle) + \", \"\"repeat\"\": \" +  CStr(iTunesApp.CurrentPlaylist.SongRepeat > 0) + \"}\"";
            File file = File.createTempFile("itd" + String.valueOf(System.currentTimeMillis()), ".vbs");
            FileOutputStream fos = new FileOutputStream(file);
            PrintStream ps = new PrintStream(fos);
            ps.print(stub + text + footer);
            ps.close();
            fos.close();
            String result = VBScriptRemote.executeVBScript(file);
            file.delete();
            int outBegin = result.indexOf("$%@BEGINOUT$%@");
            if (outBegin >= 0) {
                result = result.substring(outBegin + 14);
            }
            if (!(result = result.trim()).startsWith("{")) {
                JSONObject stateObj = new JSONObject();
                stateObj.put("artist", "ERROR");
                stateObj.put("title", "No iTunes Connection");
                stateObj.put("playerState", 0);
                stateObj.put("duration", 0);
                stateObj.put("position", 0);
                stateObj.put("volume", 0);
                stateObj.put("repeat", false);
                stateObj.put("shuffle", false);
                stateObj.put("lastStateFetch", System.currentTimeMillis());
                stateObj.put("error", true);
                this.playerState = stateObj;
            } else {
                this.playerState = new JSONObject(result);
                this.playerState.put("lastStateFetch", System.currentTimeMillis());
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static String executeVBScript(File file) throws Exception {
        return VBScriptRemote.shellExec(new String[]{"cscript", file.toString()});
    }

    @Override
    public void play() {
        this.executeiTunesScript("iTunesApp.Play()");
    }

    @Override
    public void pause() {
        this.executeiTunesScript("iTunesApp.Pause()");
    }

    @Override
    public void next() {
        this.executeiTunesScript("iTunesApp.NextTrack()");
    }

    @Override
    public void previous() {
        this.executeiTunesScript("iTunesApp.BackTrack()");
    }

    @Override
    public JSONObject getPlayerState() {
        if (System.currentTimeMillis() - this.playerState.optLong("lastStateFetch", 0L) > 500L) {
            this.executeiTunesScript("");
        }
        return this.playerState;
    }

    @Override
    public void setVolume(int volume) {
        if (volume > 100) {
            volume = 100;
        }
        if (volume < 0) {
            volume = 0;
        }
        if (volume != this.playerState.optInt("volume", 0)) {
            this.executeiTunesScript("iTunesApp.SoundVolume = " + String.valueOf(volume));
        }
    }

    @Override
    public void configure(Component parent) {
        JOptionPane.showMessageDialog(parent, "Nothing to configure!");
    }

    @Override
    public void setRepeat(boolean value) {
        this.executeiTunesScript("iTunesApp.CurrentPlaylist.SongRepeat = " + (value ? "2" : "0"));
    }

    @Override
    public void setShuffle(boolean value) {
        this.executeiTunesScript("iTunesApp.CurrentPlaylist.Shuffle = " + (value ? "True" : "False"));
    }

    @Override
    public Collection<MusicPlayerTrack> searchLibrary(String text) {
        return null;
    }

    @Override
    public Collection<MusicPlayerTrack> getPlaylist() {
        return null;
    }

    @Override
    public void enqueue(MusicPlayerTrack track) {
    }

    @Override
    public void jump(MusicPlayerTrack track) {
    }

    @Override
    public BufferedImage getArtwork() {
        return null;
    }
}

