/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.api.mpd;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.bff.javampd.player.Player;
import org.bff.javampd.server.MPD;
import org.bff.javampd.server.MPDConnectionException;
import org.bff.javampd.server.MPDSecurityException;
import org.bff.javampd.song.MPDSong;
import org.json.JSONObject;
import org.openstatic.api.MusicPlayerRemote;
import org.openstatic.api.MusicPlayerTrack;
import org.openstatic.api.mpd.MPDMusicTrack;

public class MPDRemote
implements MusicPlayerRemote {
    public JSONObject playerState;
    private JSONObject settings;
    private MPD mpdClient;
    private Player player;

    public MPDRemote(JSONObject settings) {
        this.settings = settings;
        this.mpdConnect();
    }

    @Override
    public void play() {
        if (this.player != null) {
            try {
                this.player.play();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void pause() {
        if (this.player != null) {
            try {
                this.player.pause();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void next() {
        if (this.player != null) {
            try {
                this.player.playNext();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void previous() {
        if (this.player != null) {
            try {
                this.player.playPrevious();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    @Override
    public JSONObject getPlayerState() {
        if (System.currentTimeMillis() - this.playerState.optLong("lastStateFetch", 0L) > 500L && this.mpdClient != null) {
            if (this.mpdClient.isConnected()) {
                MPDSong currentSong = this.player.getCurrentSong();
                JSONObject stateObj = new JSONObject();
                stateObj.put("artist", currentSong.getArtistName());
                stateObj.put("title", currentSong.getTitle());
                Player.Status playerStatus = this.player.getStatus();
                stateObj.put("playerState", playerStatus == Player.Status.STATUS_PLAYING ? 1 : 0);
                stateObj.put("duration", currentSong.getLength());
                stateObj.put("position", (int)this.player.getElapsedTime());
                stateObj.put("volume", this.player.getVolume());
                stateObj.put("lastStateFetch", System.currentTimeMillis());
                this.playerState = stateObj;
            } else {
                JSONObject stateObj = new JSONObject();
                stateObj.put("artist", "ERROR");
                stateObj.put("title", "No MPD Connection");
                stateObj.put("playerState", 0);
                stateObj.put("duration", 0);
                stateObj.put("position", 0);
                stateObj.put("volume", 0);
                stateObj.put("lastStateFetch", System.currentTimeMillis());
                stateObj.put("error", true);
                this.playerState = stateObj;
            }
        }
        return this.playerState;
    }

    @Override
    public void setVolume(int volume) {
        try {
            if (volume > 100) {
                volume = 100;
            }
            if (volume < 0) {
                volume = 0;
            }
            if (volume != this.playerState.optInt("volume", 0) && this.player != null) {
                this.player.setVolume(volume);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void configure(Component parent) {
        String mpdPort;
        String mpdServer = JOptionPane.showInputDialog(parent, "Enter Hostname or IP of MPD Server", this.settings.optString("mpdServer", "127.0.0.1"));
        if (mpdServer != null) {
            this.settings.put("mpdServer", mpdServer);
        }
        if ((mpdPort = JOptionPane.showInputDialog(parent, "Enter port of MPD Server (leave default if unsure)", this.settings.optString("mpdPort", "6600"))) != null) {
            this.settings.put("mpdPort", Integer.valueOf(mpdPort));
        }
        String mpdPassword = JOptionPane.showInputDialog(parent, "Enter Password for MPD Server", this.settings.optString("mpdPassword", ""));
        this.settings.put("mpdPassword", mpdPassword);
        this.mpdConnect();
    }

    public void mpdConnect() {
        JSONObject stateObj = new JSONObject();
        stateObj.put("artist", "ERROR");
        stateObj.put("title", "No MPD Connection");
        try {
            this.mpdClient = new MPD.Builder().server(this.settings.optString("mpdServer", "127.0.0.1")).port(this.settings.optInt("mpdPort", 6600)).password(this.settings.optString("mpdPassword", "")).build();
            this.player = this.mpdClient.getPlayer();
        }
        catch (MPDSecurityException mpde) {
            String message = mpde.getLocalizedMessage();
            message = message.substring(message.indexOf(":") + 1).trim();
            stateObj.put("title", message);
            this.mpdClient = null;
            this.player = null;
        }
        catch (MPDConnectionException mpde) {
            String message = mpde.getLocalizedMessage();
            message = message.substring(message.indexOf(":") + 1).trim();
            stateObj.put("title", message);
            this.mpdClient = null;
            this.player = null;
        }
        catch (Exception e) {
            this.mpdClient = null;
            this.player = null;
        }
        stateObj.put("playerState", 0);
        stateObj.put("duration", 0);
        stateObj.put("position", 0);
        try {
            stateObj.put("repeat", this.player.isRepeat());
            stateObj.put("shuffle", this.player.isRandom());
        }
        catch (Exception e) {
            stateObj.put("repeat", false);
            stateObj.put("shuffle", false);
        }
        stateObj.put("volume", 0);
        stateObj.put("lastStateFetch", System.currentTimeMillis());
        this.playerState = stateObj;
    }

    @Override
    public void setRepeat(boolean value) {
        this.player.setRepeat(value);
    }

    @Override
    public void setShuffle(boolean value) {
        this.player.setRandom(value);
    }

    @Override
    public Collection<MusicPlayerTrack> searchLibrary(String text) {
        return this.mpdClient.getMusicDatabase().getSongDatabase().findTitle(text).stream().map(mpdTrack -> new MPDMusicTrack((MPDSong)mpdTrack)).collect(Collectors.toList());
    }

    @Override
    public Collection<MusicPlayerTrack> getPlaylist() {
        return null;
    }

    @Override
    public void enqueue(MusicPlayerTrack track) {
    }

    @Override
    public void jump(MusicPlayerTrack track) {
    }

    @Override
    public BufferedImage getArtwork() {
        return null;
    }
}

