/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.api.remote;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.json.JSONObject;
import org.openstatic.TunesDirector;
import org.openstatic.api.MusicPlayerRemote;
import org.openstatic.api.MusicPlayerTrack;

public class TunesDirectorRemote
implements MusicPlayerRemote,
Runnable {
    private JSONObject playerState;
    private JSONObject settings;
    private WebSocketClient webSocketClient;
    private WebSocketSession session;
    private EventsWebSocket socket;
    private Thread keepAliveThread;
    private String wsUrl;

    public TunesDirectorRemote(JSONObject settings) {
        this.settings = settings;
        if (settings.has("tunesDirectorRemoteServer")) {
            this.wsUrl = "ws://" + settings.optString("tunesDirectorRemoteServer", "127.0.0.1") + ":6123/events/";
        }
        Thread startConnect = new Thread(() -> {
            try {
                this.webSocketClient = new WebSocketClient();
                this.webSocketClient.start();
                Thread.sleep(1000L);
                this.connect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        startConnect.start();
    }

    public TunesDirectorRemote(String host) {
        this.settings = new JSONObject();
        this.wsUrl = "ws://" + host + ":6123/events/";
        Thread startConnect = new Thread(() -> {
            try {
                this.webSocketClient = new WebSocketClient();
                this.webSocketClient.start();
                Thread.sleep(1000L);
                this.connect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        startConnect.start();
    }

    public void connect() {
        if (this.wsUrl != null) {
            try {
                URI echoUri = new URI(this.wsUrl);
                ClientUpgradeRequest request = new ClientUpgradeRequest();
                this.socket = new EventsWebSocket();
                this.launchKeepAliveThread();
                this.webSocketClient.connect(this.socket, echoUri, request);
                System.out.printf("Connecting to : %s%n", echoUri);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                JSONObject stateObj = new JSONObject();
                stateObj.put("artist", "ERROR");
                stateObj.put("title", e.getMessage());
                stateObj.put("playerState", 0);
                stateObj.put("duration", 0);
                stateObj.put("position", 0);
                stateObj.put("repeat", false);
                stateObj.put("shuffle", false);
                stateObj.put("volume", 0);
                stateObj.put("lastStateFetch", System.currentTimeMillis());
                stateObj.put("error", true);
                this.playerState = stateObj;
            }
        } else {
            JSONObject stateObj = new JSONObject();
            stateObj.put("artist", "ERROR");
            stateObj.put("title", "Configure Target Host");
            stateObj.put("playerState", 0);
            stateObj.put("duration", 0);
            stateObj.put("position", 0);
            stateObj.put("repeat", false);
            stateObj.put("shuffle", false);
            stateObj.put("volume", 0);
            stateObj.put("lastStateFetch", System.currentTimeMillis());
            this.playerState = stateObj;
        }
    }

    public void transmit(JSONObject data) {
        if (this.session != null) {
            try {
                String textData = data.toString();
                System.err.println("Transmit: " + textData);
                this.session.getRemote().sendStringByFuture(textData);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public void transmitCommand(String cmd) {
        JSONObject packet = new JSONObject();
        packet.put("cmd", cmd);
        this.transmit(packet);
    }

    @Override
    public void play() {
        this.transmitCommand("play");
    }

    @Override
    public void pause() {
        this.transmitCommand("pause");
    }

    @Override
    public void next() {
        this.transmitCommand("next");
    }

    @Override
    public void previous() {
        this.transmitCommand("previous");
    }

    @Override
    public JSONObject getPlayerState() {
        return this.playerState;
    }

    @Override
    public void setVolume(int volume) {
        try {
            if (volume > 100) {
                volume = 100;
            }
            if (volume < 0) {
                volume = 0;
            }
            if (volume != this.playerState.optInt("volume", 0)) {
                JSONObject packet = new JSONObject();
                packet.put("volume", volume);
                this.transmit(packet);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void configure(Component parent) {
        String tdServer = JOptionPane.showInputDialog(parent, "Enter Hostname or IP of Tunes Director Server", this.settings.optString("tunesDirectorRemoteServer", "127.0.0.1"));
        if (tdServer != null) {
            this.settings.put("tunesDirectorRemoteServer", tdServer);
        }
        try {
            this.close();
            Thread.sleep(1000L);
            this.connect();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void close() {
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isConnected() {
        if (this.session != null) {
            return this.session.isOpen();
        }
        return false;
    }

    public void launchKeepAliveThread() {
        if (this.keepAliveThread == null) {
            System.err.println("TunesDirectorRemote - Keep alive thread is null, launching now");
            this.keepAliveThread = new Thread(this);
            this.keepAliveThread.start();
        } else if (!this.keepAliveThread.isAlive()) {
            System.err.println("TunesDirectorRemote - Keep alive thread is dead, but exists, launching new one");
            this.keepAliveThread = new Thread(this);
            this.keepAliveThread.start();
        } else {
            System.err.println("TunesDirectorRemote - Keep alive thread already active, no need to launch another");
        }
    }

    @Override
    public void run() {
        while (TunesDirector.musicPlayerRemote == this && TunesDirector.instance.keepRunning) {
            try {
                Thread.sleep(10000L);
                if (this.isConnected()) continue;
                System.err.println("TunesDirectorRemote - No connection detected by keep alive reconnecting...");
                this.close();
                this.session = null;
                this.connect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            System.err.print("TunesDirectorRemote - Stopping websocketClient....");
            this.webSocketClient.stop();
            System.err.println("DONE");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        System.err.println("TunesDirectorRemote - Exiting Keep Alive Thread!");
    }

    @Override
    public void setRepeat(boolean value) {
        JSONObject packet = new JSONObject();
        packet.put("repeat", value);
        this.transmit(packet);
    }

    @Override
    public void setShuffle(boolean value) {
        JSONObject packet = new JSONObject();
        packet.put("shuffle", value);
        this.transmit(packet);
    }

    @Override
    public Collection<MusicPlayerTrack> searchLibrary(String text) {
        return null;
    }

    @Override
    public Collection<MusicPlayerTrack> getPlaylist() {
        return null;
    }

    @Override
    public void enqueue(MusicPlayerTrack track) {
    }

    @Override
    public void jump(MusicPlayerTrack track) {
    }

    @Override
    public BufferedImage getArtwork() {
        if (this.playerState.has("artwork")) {
            return TunesDirector.getCachedImage(this.playerState.optString("artwork", "/disk2.png"), "256x256");
        }
        return null;
    }

    @WebSocket
    public class EventsWebSocket {
        @OnWebSocketMessage
        public void onText(Session session, String message) throws IOException {
            try {
                JSONObject jo;
                TunesDirectorRemote.this.playerState = jo = new JSONObject(message);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }

        @OnWebSocketConnect
        public void onConnect(Session session) throws IOException {
            if (session instanceof WebSocketSession) {
                TunesDirectorRemote.this.session = (WebSocketSession)session;
            }
        }

        @OnWebSocketClose
        public void onClose(Session session, int status, String reason) {
            TunesDirectorRemote.this.close();
            TunesDirectorRemote.this.session = null;
            if (TunesDirector.musicPlayerRemote == TunesDirectorRemote.this) {
                System.err.println("Connection Closed - TunesDirectorRemote (Auto Reconnect)");
            } else {
                System.err.println("Connection Closed - TunesDirectorRemote (kill)");
            }
            JSONObject stateObj = new JSONObject();
            stateObj.put("artist", "ERROR");
            stateObj.put("title", reason);
            stateObj.put("playerState", 0);
            stateObj.put("duration", 0);
            stateObj.put("position", 0);
            stateObj.put("volume", 0);
            stateObj.put("repeat", false);
            stateObj.put("shuffle", false);
            stateObj.put("lastStateFetch", System.currentTimeMillis());
            TunesDirectorRemote.this.playerState = stateObj;
        }

        @OnWebSocketError
        public void onError(Throwable e) {
            e.printStackTrace(System.err);
            TunesDirectorRemote.this.close();
            TunesDirectorRemote.this.session = null;
            if (TunesDirector.musicPlayerRemote == TunesDirectorRemote.this) {
                System.err.println("Connection Error - TunesDirectorRemote (Auto Reconnect)");
            } else {
                System.err.println("Connection Error - TunesDirectorRemote (Kill)");
            }
            JSONObject stateObj = new JSONObject();
            stateObj.put("artist", "ERROR");
            stateObj.put("title", e.getMessage());
            stateObj.put("playerState", 0);
            stateObj.put("duration", 0);
            stateObj.put("position", 0);
            stateObj.put("volume", 0);
            stateObj.put("repeat", false);
            stateObj.put("shuffle", false);
            stateObj.put("lastStateFetch", System.currentTimeMillis());
            TunesDirectorRemote.this.playerState = stateObj;
        }
    }
}

