/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.api.spotify;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.json.JSONObject;
import org.openstatic.TunesDirector;
import org.openstatic.api.MusicPlayerRemote;
import org.openstatic.api.MusicPlayerTrack;
import org.openstatic.api.spotify.SpotifyTrack;
import se.michaelthelin.spotify.SpotifyApi;
import se.michaelthelin.spotify.SpotifyHttpManager;
import se.michaelthelin.spotify.exceptions.detailed.UnauthorizedException;
import se.michaelthelin.spotify.model_objects.IPlaylistItem;
import se.michaelthelin.spotify.model_objects.credentials.AuthorizationCodeCredentials;
import se.michaelthelin.spotify.model_objects.miscellaneous.CurrentlyPlayingContext;
import se.michaelthelin.spotify.model_objects.specification.Image;
import se.michaelthelin.spotify.model_objects.specification.Paging;
import se.michaelthelin.spotify.model_objects.specification.Track;
import se.michaelthelin.spotify.requests.authorization.authorization_code.AuthorizationCodeRefreshRequest;
import se.michaelthelin.spotify.requests.authorization.authorization_code.AuthorizationCodeRequest;
import se.michaelthelin.spotify.requests.authorization.authorization_code.AuthorizationCodeUriRequest;
import se.michaelthelin.spotify.requests.data.player.AddItemToUsersPlaybackQueueRequest;
import se.michaelthelin.spotify.requests.data.player.GetInformationAboutUsersCurrentPlaybackRequest;
import se.michaelthelin.spotify.requests.data.player.PauseUsersPlaybackRequest;
import se.michaelthelin.spotify.requests.data.player.SetRepeatModeOnUsersPlaybackRequest;
import se.michaelthelin.spotify.requests.data.player.SetVolumeForUsersPlaybackRequest;
import se.michaelthelin.spotify.requests.data.player.SkipUsersPlaybackToNextTrackRequest;
import se.michaelthelin.spotify.requests.data.player.SkipUsersPlaybackToPreviousTrackRequest;
import se.michaelthelin.spotify.requests.data.player.StartResumeUsersPlaybackRequest;
import se.michaelthelin.spotify.requests.data.player.ToggleShuffleForUsersPlaybackRequest;
import se.michaelthelin.spotify.requests.data.search.simplified.SearchTracksRequest;
import se.michaelthelin.spotify.requests.data.tracks.GetTrackRequest;

public class SpotifyRemote
implements MusicPlayerRemote {
    public JSONObject playerState;
    private JSONObject settings;
    public SpotifyApi spotifyApi;
    private final String clientId = "9919aae1fcad4186aa48bf85746568ce";
    private final String clientSecret = "082d982d8472494da5b722ff24f2649a";
    private String trackId = null;
    private Track currentTrack;
    private long tokenExpiresAt;

    public SpotifyRemote(JSONObject settings) {
        this.settings = settings;
        JSONObject stateObj = new JSONObject();
        stateObj.put("artist", "ERROR");
        stateObj.put("title", "No Spotify Connection");
        stateObj.put("playerState", 0);
        stateObj.put("duration", 0);
        stateObj.put("position", 0);
        stateObj.put("repeat", false);
        stateObj.put("shuffle", false);
        stateObj.put("volume", 0);
        stateObj.put("lastStateFetch", System.currentTimeMillis());
        stateObj.put("error", true);
        this.playerState = stateObj;
        this.spotifyApi = new SpotifyApi.Builder().setClientId("9919aae1fcad4186aa48bf85746568ce").setClientSecret("082d982d8472494da5b722ff24f2649a").setRedirectUri(SpotifyHttpManager.makeUri("http://127.0.0.1:6323/api/spotify/")).build();
        this.spotifyApi.setAccessToken(settings.optString("spotifyAccessToken", null));
        this.spotifyApi.setRefreshToken(settings.optString("spotifyRefreshToken", null));
        this.tokenExpiresAt = settings.optLong("spotifyTokenExpiresAt", 0L);
    }

    public void receiveAccessCode(String accessCode) {
        try {
            AuthorizationCodeRequest authorizationCodeRequest = this.spotifyApi.authorizationCode(accessCode).build();
            AuthorizationCodeCredentials authorizationCodeCredentials = authorizationCodeRequest.execute();
            String accessToken = authorizationCodeCredentials.getAccessToken();
            String refreshToken = authorizationCodeCredentials.getRefreshToken();
            this.tokenExpiresAt = System.currentTimeMillis() + (long)(authorizationCodeCredentials.getExpiresIn() * 1000);
            this.settings.put("spotifyAccessToken", accessToken);
            this.settings.put("spotifyRefreshToken", refreshToken);
            this.settings.put("spotifyTokenExpiresAt", this.tokenExpiresAt);
            this.spotifyApi.setAccessToken(accessToken);
            this.spotifyApi.setRefreshToken(refreshToken);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doTokenRefresh() {
        try {
            AuthorizationCodeRefreshRequest authorizationCodeRefreshRequest = this.spotifyApi.authorizationCodeRefresh().build();
            AuthorizationCodeCredentials authorizationCodeCredentials = authorizationCodeRefreshRequest.execute();
            String accessToken = authorizationCodeCredentials.getAccessToken();
            this.tokenExpiresAt = System.currentTimeMillis() + (long)(authorizationCodeCredentials.getExpiresIn() * 1000);
            this.settings.put("spotifyAccessToken", accessToken);
            this.settings.put("spotifyTokenExpiresAt", this.tokenExpiresAt);
            this.spotifyApi.setAccessToken(accessToken);
            System.err.println("Spotify Token Refreshed: " + accessToken);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void doAuth() {
        try {
            AuthorizationCodeUriRequest authorizationCodeUriRequest = this.spotifyApi.authorizationCodeUri().scope("user-read-currently-playing user-read-playback-state user-modify-playback-state app-remote-control").build();
            URI uri = authorizationCodeUriRequest.execute();
            TunesDirector.browseTo(uri.toString());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void play() {
        try {
            StartResumeUsersPlaybackRequest startResumeUsersPlaybackRequest = this.spotifyApi.startResumeUsersPlayback().build();
            startResumeUsersPlaybackRequest.execute();
        }
        catch (UnauthorizedException e) {
            this.doAuth();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void pause() {
        try {
            PauseUsersPlaybackRequest pauseUsersPlaybackRequest = this.spotifyApi.pauseUsersPlayback().build();
            pauseUsersPlaybackRequest.execute();
        }
        catch (UnauthorizedException e) {
            this.doAuth();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void next() {
        try {
            SkipUsersPlaybackToNextTrackRequest skipUsersPlaybackToNextTrackRequest = this.spotifyApi.skipUsersPlaybackToNextTrack().build();
            skipUsersPlaybackToNextTrackRequest.execute();
        }
        catch (UnauthorizedException e) {
            this.doAuth();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void previous() {
        try {
            SkipUsersPlaybackToPreviousTrackRequest skipUsersPlaybackToPreviousTrackRequest = this.spotifyApi.skipUsersPlaybackToPreviousTrack().build();
            skipUsersPlaybackToPreviousTrackRequest.execute();
        }
        catch (UnauthorizedException e) {
            this.doAuth();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public JSONObject getPlayerState() {
        block9: {
            if (System.currentTimeMillis() - this.playerState.optLong("lastStateFetch", 0L) > 500L) {
                if (this.spotifyApi.getRefreshToken() != null && System.currentTimeMillis() > this.tokenExpiresAt - 300000L) {
                    this.doTokenRefresh();
                }
                if (this.spotifyApi.getAccessToken() != null) {
                    try {
                        GetInformationAboutUsersCurrentPlaybackRequest getInformationAboutUsersCurrentPlaybackRequest = this.spotifyApi.getInformationAboutUsersCurrentPlayback().build();
                        CurrentlyPlayingContext currentlyPlayingContext = getInformationAboutUsersCurrentPlaybackRequest.execute();
                        if (currentlyPlayingContext != null) {
                            IPlaylistItem playlistItem = currentlyPlayingContext.getItem();
                            if (this.trackId != playlistItem.getId() || this.currentTrack == null) {
                                GetTrackRequest trackRequest = this.spotifyApi.getTrack(playlistItem.getId()).build();
                                this.currentTrack = trackRequest.execute();
                            }
                            JSONObject stateObj = new JSONObject();
                            stateObj.put("artwork", this.getArtworkUrl());
                            stateObj.put("artist", this.currentTrack.getArtists()[0].getName());
                            stateObj.put("title", this.currentTrack.getName());
                            stateObj.put("playerState", currentlyPlayingContext.getIs_playing() != false ? 1 : 0);
                            stateObj.put("duration", (int)(playlistItem.getDurationMs().floatValue() / 1000.0f));
                            stateObj.put("position", (int)((float)currentlyPlayingContext.getProgress_ms().intValue() / 1000.0f));
                            stateObj.put("volume", currentlyPlayingContext.getDevice().getVolume_percent());
                            stateObj.put("repeat", !currentlyPlayingContext.getRepeat_state().equals("off"));
                            stateObj.put("shuffle", currentlyPlayingContext.getShuffle_state());
                            stateObj.put("lastStateFetch", System.currentTimeMillis());
                            this.playerState = stateObj;
                            break block9;
                        }
                        JSONObject stateObj = new JSONObject();
                        stateObj.put("artist", "Spotify");
                        stateObj.put("title", "Not Playing");
                        stateObj.put("playerState", 0);
                        stateObj.put("duration", 0);
                        stateObj.put("position", 0);
                        stateObj.put("volume", 0);
                        stateObj.put("repeat", false);
                        stateObj.put("shuffle", false);
                        stateObj.put("lastStateFetch", System.currentTimeMillis());
                        this.playerState = stateObj;
                    }
                    catch (UnauthorizedException e) {
                        System.err.println(e.getMessage());
                        e.printStackTrace(System.err);
                        this.spotifyApi.setAccessToken(null);
                        this.spotifyApi.setRefreshToken(null);
                        JSONObject stateObj = new JSONObject();
                        stateObj.put("artist", "Spotify");
                        stateObj.put("title", "press play to authenticate");
                        stateObj.put("playerState", 0);
                        stateObj.put("duration", 0);
                        stateObj.put("position", 0);
                        stateObj.put("volume", 0);
                        stateObj.put("repeat", false);
                        stateObj.put("shuffle", false);
                        stateObj.put("lastStateFetch", System.currentTimeMillis());
                        stateObj.put("error", true);
                        this.playerState = stateObj;
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                } else {
                    JSONObject stateObj = new JSONObject();
                    stateObj.put("artist", "Spotify");
                    stateObj.put("title", "press play to authenticate");
                    stateObj.put("playerState", 0);
                    stateObj.put("duration", 0);
                    stateObj.put("position", 0);
                    stateObj.put("volume", 0);
                    stateObj.put("repeat", false);
                    stateObj.put("shuffle", false);
                    stateObj.put("lastStateFetch", System.currentTimeMillis());
                    stateObj.put("error", true);
                    this.playerState = stateObj;
                }
            }
        }
        return this.playerState;
    }

    @Override
    public void setVolume(int volume) {
        try {
            if (volume > 100) {
                volume = 100;
            }
            if (volume < 0) {
                volume = 0;
            }
            if (volume != this.playerState.optInt("volume", 0)) {
                SetVolumeForUsersPlaybackRequest setVolumeForUsersPlaybackRequest = this.spotifyApi.setVolumeForUsersPlayback(volume).build();
                setVolumeForUsersPlaybackRequest.execute();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void configure(Component parent) {
        if (JOptionPane.showConfirmDialog(parent, "Launch Spotify Authorization?", "Configure Spotify", 2) == 0) {
            this.doAuth();
        }
    }

    @Override
    public void setRepeat(boolean value) {
        try {
            SetRepeatModeOnUsersPlaybackRequest setRepeatModeOnUsersPlaybackRequest = this.spotifyApi.setRepeatModeOnUsersPlayback(value ? "context" : "off").build();
            setRepeatModeOnUsersPlaybackRequest.execute();
        }
        catch (UnauthorizedException e) {
            this.doAuth();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void setShuffle(boolean value) {
        try {
            ToggleShuffleForUsersPlaybackRequest toggleShuffleForUsersPlaybackRequest = this.spotifyApi.toggleShuffleForUsersPlayback(value).build();
            toggleShuffleForUsersPlaybackRequest.execute();
        }
        catch (UnauthorizedException e) {
            this.doAuth();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public Collection<MusicPlayerTrack> searchLibrary(String text) {
        try {
            SearchTracksRequest searchTracksRequest = this.spotifyApi.searchTracks(text).build();
            Object tracks = searchTracksRequest.execute();
            List<Track> trackResults = Arrays.asList((Track[])((Paging)tracks).getItems());
            return trackResults.stream().map(track -> new SpotifyTrack((Track)track)).collect(Collectors.toList());
        }
        catch (UnauthorizedException e) {
            this.doAuth();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return null;
    }

    @Override
    public Collection<MusicPlayerTrack> getPlaylist() {
        try {
            return new ArrayList<MusicPlayerTrack>();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    @Override
    public void enqueue(MusicPlayerTrack track) {
        if (track instanceof SpotifyTrack) {
            SpotifyTrack spotTrack = (SpotifyTrack)track;
            try {
                AddItemToUsersPlaybackQueueRequest addItemToUsersPlaybackQueueRequest = this.spotifyApi.addItemToUsersPlaybackQueue(spotTrack.getTrackUri()).build();
                addItemToUsersPlaybackQueueRequest.execute();
            }
            catch (UnauthorizedException e) {
                this.doAuth();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void jump(MusicPlayerTrack track) {
        if (track instanceof SpotifyTrack) {
            // empty if block
        }
    }

    public String getArtworkUrl() {
        try {
            Image[] images = this.currentTrack.getAlbum().getImages();
            if (images.length > 0) {
                return images[0].getUrl();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public BufferedImage getArtwork() {
        try {
            Image[] images = this.currentTrack.getAlbum().getImages();
            if (images.length > 0) {
                return TunesDirector.getCachedImage(images[0].getUrl(), "256x256");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

