/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.routeput;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Base64;
import java.util.HashMap;
import org.eclipse.jetty.http.MimeTypes;
import org.json.JSONObject;
import org.openstatic.routeput.BLOBFile;
import org.openstatic.routeput.RoutePutChannel;
import org.openstatic.routeput.RoutePutMessage;
import org.openstatic.routeput.RoutePutSession;

public class BLOBManager {
    private static HashMap<String, StringBuffer> blobStorage;
    private static File blobRoot;
    public static JSONObject settings;

    static {
        settings = new JSONObject();
    }

    public static File getBlobRoot() {
        return blobRoot;
    }

    public static void init(JSONObject settings) {
        if (settings != null) {
            BLOBManager.settings = settings;
        }
        if (blobRoot == null && !(blobRoot = new File(BLOBManager.settings.optString("blobStorageRoot", "./blob/"))).exists()) {
            blobRoot.mkdir();
        }
        if (blobStorage == null) {
            blobStorage = new HashMap();
        }
    }

    public static void handleBlobData(RoutePutSession session, RoutePutMessage jo) {
        BLOBManager.init(null);
        if (jo.hasMetaField("i") && jo.hasMetaField("of") && jo.hasMetaField("data") && jo.hasMetaField("name")) {
            StringBuffer sb;
            JSONObject rpm = jo.getRoutePutMeta();
            Object context = rpm.optString("context", null);
            int i = rpm.optInt("i", 0);
            int of = rpm.optInt("of", 0);
            String name = rpm.optString("name", "");
            if (i == 1) {
                sb = new StringBuffer();
                blobStorage.put(name, sb);
            } else {
                sb = blobStorage.get(name);
            }
            sb.append(rpm.optString("data", ""));
            if (i == of) {
                File blobFolder = null;
                if (context == null && jo.getRoutePutChannel() != null) {
                    RoutePutChannel chan = jo.getRoutePutChannel();
                    blobFolder = chan.getBlobFolder();
                    context = "channel." + chan.getName();
                } else {
                    blobFolder = new File(blobRoot, (String)context);
                    if (!blobFolder.exists()) {
                        blobFolder.mkdir();
                    }
                }
                if (blobFolder != null) {
                    BLOBFile blobFile = new BLOBFile(blobFolder, (String)context, name);
                    BLOBManager.saveBase64Blob(blobFile, sb);
                    blobStorage.remove(name);
                    RoutePutMessage resp = new RoutePutMessage();
                    resp.setType("blob");
                    resp.mergeRouteputMeta(blobFile.toJSONObject());
                    resp.setRef(jo);
                    if (jo.hasChannel()) {
                        resp.setChannel(jo.getRoutePutChannel());
                        jo.getRoutePutChannel().onMessage(null, resp);
                    } else {
                        session.send(resp);
                    }
                }
            }
        }
    }

    public static BLOBFile resolveBlob(String context, String name) {
        File blobFolder = blobRoot;
        if (context != null && !(blobFolder = new File(blobRoot, context)).exists()) {
            blobFolder.mkdir();
        }
        if (blobFolder != null) {
            BLOBFile blobFile = new BLOBFile(blobFolder, context, name);
            return blobFile;
        }
        return null;
    }

    public static boolean blobExists(String context, String name) {
        BLOBFile blobFile = BLOBManager.resolveBlob(context, name);
        if (blobFile != null) {
            return blobFile.exists();
        }
        return false;
    }

    public static void fetchBlob(RoutePutSession session, RoutePutMessage request) {
        JSONObject rpm = request.getRoutePutMeta();
        String name = rpm.optString("name", "");
        String context = rpm.optString("context");
        RoutePutChannel channel = request.getRoutePutChannel();
        BLOBFile blobFile = BLOBManager.resolveBlob(context, name);
        if (blobFile != null) {
            if (blobFile.exists()) {
                StringBuffer sb = blobFile.getBase64StringBuffer();
                BLOBManager.transmitBlobChunks(session, name, context, sb, request);
            } else {
                RoutePutMessage resp = new RoutePutMessage();
                resp.setType("blob");
                resp.setRef(request);
                resp.setMetaField("name", name);
                resp.setChannel(channel);
                if (context != null) {
                    resp.setMetaField("context", context);
                }
                resp.setMetaField("exists", false);
                session.send(resp);
            }
        } else {
            RoutePutMessage resp = new RoutePutMessage();
            resp.setType("blob");
            resp.setRef(request);
            resp.setMetaField("name", name);
            resp.setChannel(channel);
            if (context != null) {
                resp.setMetaField("context", context);
            }
            resp.setMetaField("exists", false);
            session.send(resp);
        }
    }

    public static void sendBlob(RoutePutSession session, String name, String context, String contentType, byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        sb.append("data:" + contentType + ";base64,");
        sb.append(Base64.getEncoder().encodeToString(bytes));
        BLOBManager.transmitBlobChunks(session, name, context, sb, null);
    }

    private static void transmitBlobChunks(RoutePutSession session, String name, String context, StringBuffer sb, RoutePutMessage request) {
        Thread x = new Thread(() -> {
            int size = sb.length();
            int chunkSize = 4096;
            int numChunks = (size + chunkSize - 1) / chunkSize;
            int i = 0;
            while (i < numChunks) {
                int start;
                int end;
                RoutePutMessage mm3 = new RoutePutMessage();
                mm3.setType("blob");
                mm3.setMetaField("name", name);
                if (context != null) {
                    mm3.setMetaField("context", context);
                }
                mm3.setMetaField("i", i + 1);
                mm3.setMetaField("of", numChunks);
                if (i + 1 == numChunks && request != null) {
                    mm3.setRef(request);
                }
                if ((end = (start = i * chunkSize) + chunkSize) > size) {
                    end = size;
                }
                mm3.setMetaField("data", sb.substring(start, end));
                session.send(mm3);
                ++i;
            }
        });
        x.start();
    }

    public static File saveBase64Blob(File file, StringBuffer sb) {
        try {
            byte[] fileData = Base64.getDecoder().decode(sb.substring(sb.indexOf(",") + 1));
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(fileData);
            fos.close();
            return file;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static StringBuffer loadBase64Blob(File file) {
        StringBuffer sb = new StringBuffer();
        try {
            String contentType = BLOBManager.getContentTypeFor(file.getName());
            if (file.exists()) {
                sb.append("data:" + contentType + ";base64,");
                FileInputStream fis = new FileInputStream(file);
                byte[] bFile = new byte[(int)file.length()];
                fis.read(bFile);
                fis.close();
                sb.append(Base64.getEncoder().encodeToString(bFile));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb;
    }

    public static String getContentTypeFor(String filename) {
        String lc_file = filename.toLowerCase();
        if (lc_file.endsWith(".html") || lc_file.endsWith(".htm")) {
            return "text/html";
        }
        if (lc_file.endsWith(".txt")) {
            return "text/plain";
        }
        if (lc_file.endsWith(".css")) {
            return "text/css";
        }
        if (lc_file.endsWith(".js")) {
            return "text/javascript";
        }
        if (lc_file.endsWith(".jpg") || lc_file.endsWith(".jpe") || lc_file.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (lc_file.endsWith(".gif")) {
            return "image/gif";
        }
        if (lc_file.endsWith(".png")) {
            return "image/png";
        }
        if (lc_file.endsWith(".bmp")) {
            return "image/x-ms-bmp";
        }
        if (lc_file.endsWith(".mp3")) {
            return "audio/mpeg3";
        }
        if (lc_file.endsWith(".zip")) {
            return "application/zip";
        }
        if (lc_file.endsWith(".pdf")) {
            return "application/pdf";
        }
        if (lc_file.endsWith(".xml")) {
            return "text/xml";
        }
        if (lc_file.endsWith(".mid") || lc_file.endsWith(".midi")) {
            return "audio/midi";
        }
        if (lc_file.endsWith(".tar")) {
            return "application/x-tar";
        }
        if (lc_file.endsWith(".ico")) {
            return "image/x-icon";
        }
        if (lc_file.endsWith(".avi")) {
            return "video/x-msvideo";
        }
        if (lc_file.endsWith(".mp4")) {
            return "video/mp4";
        }
        if (lc_file.endsWith(".mkv")) {
            return "video/x-matroska";
        }
        if (lc_file.endsWith(".mov")) {
            return "video/quicktime";
        }
        if (lc_file.endsWith(".wmv")) {
            return "video/x-ms-wmv";
        }
        if (lc_file.endsWith(".3gp")) {
            return "video/3gpp";
        }
        String result = MimeTypes.getDefaultMimeByExtension(filename);
        if ("".equals(result) || result == null) {
            result = "application/octet-stream";
        }
        return result;
    }
}

