/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.routeput;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.openstatic.routeput.BLOBFile;
import org.openstatic.routeput.BLOBManager;
import org.openstatic.routeput.RoutePutChannelListener;
import org.openstatic.routeput.RoutePutMessage;
import org.openstatic.routeput.RoutePutMessageListener;
import org.openstatic.routeput.RoutePutPropertyChangeMessage;
import org.openstatic.routeput.RoutePutRemoteSession;
import org.openstatic.routeput.RoutePutServer;
import org.openstatic.routeput.RoutePutServerWebsocket;
import org.openstatic.routeput.RoutePutSession;
import org.openstatic.routeput.util.JSONTools;

public class RoutePutChannel
implements RoutePutMessageListener {
    private static HashMap<String, RoutePutChannel> channels;
    private static Thread channelTracker;
    private static File channelRoot;
    private static String hostname;
    private PropertyChangeSupport propertyChangeSupport;
    private String name;
    private BufferedWriter logWriter;
    private JSONObject properties;
    private boolean unsavedProperties;
    protected LinkedHashMap<String, RoutePutSession> members;
    private long lastAccess;
    private RoutePutSession collector;
    private int messagesTx;
    private int messagesRx;
    private int pingAvg;
    private ArrayList<RoutePutChannelListener> listeners;
    private ArrayList<RoutePutMessageListener> messageListeners;
    private int msgTxPerSecond;
    private int msgRxPerSecond;

    static {
        channelTracker = null;
    }

    private RoutePutChannel(String name) {
        RoutePutServer.logIt("Channel created " + name);
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.msgTxPerSecond = 0;
        this.msgRxPerSecond = 0;
        this.messagesTx = 0;
        this.messagesRx = 0;
        this.pingAvg = 0;
        this.name = name;
        this.lastAccess = System.currentTimeMillis();
        this.members = new LinkedHashMap();
        this.listeners = new ArrayList();
        this.messageListeners = new ArrayList();
        this.collector = null;
        this.properties = new JSONObject();
        this.unsavedProperties = false;
        File propertiesFile = this.getPropertiesFile();
        if (propertiesFile != null && propertiesFile.exists()) {
            this.properties = RoutePutServer.loadJSONObject(propertiesFile);
        }
        if (this.properties.optBoolean("log", true)) {
            try {
                File logFile = this.getLogFile();
                if (logFile != null) {
                    this.logWriter = new BufferedWriter(new FileWriter(logFile, true));
                }
            }
            catch (Exception e) {
                RoutePutServer.logError(e);
            }
        }
    }

    public void setPermanent(boolean v) {
        this.properties.put("permanent", true);
        this.saveChannelProperties();
    }

    public boolean isPermanent() {
        return this.properties.optBoolean("permanent", false);
    }

    private void saveChannelProperties() {
        this.unsavedProperties = true;
    }

    public String getBLOBContext() {
        return "channel." + this.name;
    }

    public JSONArray getBlobs() {
        JSONArray ja = new JSONArray();
        File blobFolder = this.getBlobFolder();
        if (blobFolder != null) {
            ja = new JSONArray();
            String[] names = blobFolder.list();
            int i = 0;
            while (i < names.length) {
                BLOBFile file = new BLOBFile(blobFolder, this.getBLOBContext(), names[i]);
                ja.put(file.toJSONObject());
                ++i;
            }
        }
        return ja;
    }

    public File getBlobFolder() {
        File blobRoot = BLOBManager.getBlobRoot();
        if (blobRoot != null) {
            File blobFolder = new File(blobRoot, this.getBLOBContext());
            if (!blobFolder.exists()) {
                blobFolder.mkdir();
            }
            return blobFolder;
        }
        return null;
    }

    private File getPropertiesFile() {
        File channelFolder = this.getChannelFolder();
        if (channelFolder != null) {
            File channelPropertiesFile = new File(channelFolder, "properties.json");
            return channelPropertiesFile;
        }
        return null;
    }

    private File getLogFile() {
        File channelFolder = this.getChannelFolder();
        if (channelFolder != null) {
            File channelPropertiesFile = new File(channelFolder, "channel.log");
            return channelPropertiesFile;
        }
        return null;
    }

    private File getChannelFolder() {
        if (channelRoot != null) {
            File channelFolder;
            if (!channelRoot.exists()) {
                channelRoot.mkdir();
            }
            if (!(channelFolder = new File(channelRoot, this.name)).exists()) {
                channelFolder.mkdir();
            }
            return channelFolder;
        }
        return null;
    }

    public static void setChannelRoot(File channelRoot) {
        RoutePutChannel.channelRoot = channelRoot;
    }

    public static Thread initTracker() {
        if (hostname == null) {
            try {
                InetAddress ip = InetAddress.getLocalHost();
                hostname = ip.getHostName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (channelTracker == null) {
            channels = new HashMap();
            channelTracker = new Thread(() -> {
                while (channelTracker != null) {
                    try {
                        Thread.sleep(1000L);
                        RoutePutChannel.everySecond();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            channelTracker.setDaemon(true);
            channelTracker.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    channels.values().forEach(c -> c.hibernate());
                    channelTracker = null;
                }
            });
        }
        return channelTracker;
    }

    private static void everySecond() throws Exception {
        channels.values().parallelStream().forEach(c -> {
            c.msgTxPerSecond = c.messagesTx;
            c.messagesTx = 0;
            c.msgRxPerSecond = c.messagesRx;
            c.messagesRx = 0;
            Iterator<RoutePutSession> si = c.members.values().iterator();
            float pingTotal = 0.0f;
            float pingCount = 0.0f;
            while (si.hasNext()) {
                RoutePutSession member = si.next();
                JSONObject props = member.getProperties();
                if (!props.has("_ping")) continue;
                pingTotal += (float)props.optInt("_ping");
                pingCount += 1.0f;
            }
            c.pingAvg = (int)(pingTotal / pingCount);
            try {
                if (c.logWriter != null) {
                    c.logWriter.flush();
                }
            }
            catch (Exception e) {
                RoutePutServer.logError(e);
            }
        });
        long idleTimeout = 600000L;
        channels.values().removeIf(c -> {
            boolean removeIt;
            boolean bl = removeIt = c.getIdle() > idleTimeout && c.memberCount() == 0 && !c.isPermanent();
            if (removeIt) {
                c.hibernate();
            }
            return removeIt;
        });
        channels.values().stream().filter(c -> c.unsavedProperties).forEach(c -> {
            try {
                RoutePutServer.saveJSONObject(c.getPropertiesFile(), c.properties);
                c.unsavedProperties = false;
            }
            catch (Exception e) {
                RoutePutServer.logError(e);
            }
        });
        if (RoutePutServer.instance != null) {
            channels.values().forEach(channel -> channel.members.values().forEach(member -> {
                if (member instanceof RoutePutServerWebsocket && !RoutePutServer.instance.sessions.containsValue(member)) {
                    RoutePutServer.logWarning("Found a RoutePutServerWebsocket in channel " + channel.getName() + " without belonging to RouteputServer..?");
                    RoutePutChannel.removeFromAllChannels(member);
                }
            }));
        }
    }

    public static String getHostname() {
        return hostname;
    }

    public static void setHostname(String hostname) {
        RoutePutChannel.hostname = hostname;
    }

    public int getMessagesTxPerSecond() {
        return this.msgTxPerSecond;
    }

    public int getMessagesRxPerSecond() {
        return this.msgRxPerSecond;
    }

    public String getName() {
        return this.name;
    }

    private void bumpTx() {
        ++this.messagesTx;
        this.touch();
    }

    private void bumpRx() {
        ++this.messagesRx;
        this.touch();
    }

    public void touch() {
        this.lastAccess = System.currentTimeMillis();
    }

    public boolean hasMember(RoutePutSession session) {
        return this.members.containsValue(session);
    }

    protected void replaceMember(String connectionId, RoutePutSession oldSession, RoutePutSession newSession) {
        this.members.replace(connectionId, oldSession, newSession);
    }

    public boolean hasMember(String sessionId) {
        return this.members.containsKey(sessionId);
    }

    public synchronized void addMember(RoutePutSession session) {
        String connectionId = session.getConnectionId();
        if (!this.members.containsKey(connectionId)) {
            this.members.put(connectionId, session);
            RoutePutMessage jo = new RoutePutMessage();
            jo.setSourceId(connectionId);
            jo.setChannel(this);
            jo.setType("ConnectionStatus");
            jo.setMetaField("connected", true);
            jo.setMetaField("remoteIP", session.getRemoteIP());
            jo.setMetaField("properties", session.getProperties());
            this.broadcast(jo);
            if (session.isRootConnection()) {
                this.transmitMembers(session);
            }
            this.listeners.parallelStream().forEach(l -> l.onJoin(this, session));
            this.touch();
        }
    }

    public synchronized void removeMember(RoutePutSession session) {
        if (this.members.containsValue(session)) {
            String connectionId = session.getConnectionId();
            this.members.remove(session.getConnectionId());
            RoutePutMessage jo = new RoutePutMessage();
            jo.setSourceId(connectionId);
            jo.setChannel(this);
            jo.setType("ConnectionStatus");
            jo.setMetaField("connected", false);
            jo.setMetaField("remoteIP", session.getRemoteIP());
            jo.setMetaField("properties", session.getProperties());
            this.broadcast(jo);
            this.listeners.parallelStream().forEach(l -> l.onLeave(this, session));
            this.touch();
            if (session instanceof RoutePutRemoteSession) {
                RoutePutRemoteSession rprs = (RoutePutRemoteSession)session;
                rprs.maybeDestroy();
            }
        }
        if (session == this.collector) {
            this.collector = null;
        }
    }

    public void addChannelListener(RoutePutChannelListener rpcl) {
        if (!this.listeners.contains(rpcl)) {
            this.listeners.add(rpcl);
        }
    }

    public void removeChannelListener(RoutePutChannelListener rpcl) {
        if (this.listeners.contains(rpcl)) {
            this.listeners.remove(rpcl);
        }
    }

    public void addMessageListener(RoutePutMessageListener rpml) {
        if (!this.messageListeners.contains(rpml)) {
            this.messageListeners.add(rpml);
        }
    }

    public void removeMessageListener(RoutePutMessageListener rpml) {
        if (this.messageListeners.contains(rpml)) {
            this.messageListeners.remove(rpml);
        }
    }

    public void setCollector(RoutePutSession collector) {
        this.collector = collector;
    }

    public RoutePutSession getCollector() {
        return this.collector;
    }

    public boolean hasCollector() {
        return this.collector != null;
    }

    public int memberCount() {
        return this.members.size();
    }

    public RoutePutSession findMemberById(String id) {
        if (this.members.containsKey(id)) {
            return this.members.get(id);
        }
        return null;
    }

    public void transmitMembers(RoutePutSession session) {
        this.members.values().parallelStream().forEach(m3 -> {
            if (m3 != session) {
                RoutePutMessage jo = new RoutePutMessage();
                jo.setSourceId(m3.getConnectionId());
                jo.setChannel(this);
                jo.setType("ConnectionStatus");
                jo.setMetaField("connected", true);
                jo.setMetaField("remoteIP", m3.getRemoteIP());
                jo.setMetaField("properties", m3.getProperties());
                session.send(jo);
            }
        });
    }

    @Override
    public void onMessage(RoutePutSession session, RoutePutMessage j) {
        RoutePutChannel mChan = j.getRoutePutChannel();
        if (this.equals(mChan)) {
            if (j.canBeLogged() && !"pulse".equals(j.getType())) {
                try {
                    if (this.logWriter != null && this.properties.optBoolean("log", true)) {
                        this.logWriter.write(j.toString() + "\n");
                    }
                }
                catch (Exception e) {
                    RoutePutServer.logError(e);
                }
            }
            this.bumpRx();
            if (hostname != null) {
                j.appendMetaArray("hops", hostname);
            }
            JSONObject messageMeta = j.getRoutePutMeta();
            Iterator<String> messageMetaKeys = messageMeta.keys();
            while (messageMetaKeys.hasNext()) {
                JSONObject sessionProps;
                String messageMetaKey = messageMetaKeys.next();
                if (!messageMetaKey.endsWith("_rssi")) continue;
                int rssi = messageMeta.optInt(messageMetaKey, -120);
                if (session == null || (sessionProps = session.getProperties()) == null) continue;
                sessionProps.put(messageMetaKey, rssi);
            }
            if (j.isType("midi")) {
                JSONArray data = j.getRoutePutMeta().getJSONArray("data");
                long timeStamp = j.getRoutePutMeta().optLong("ts", -1L);
                int data0 = data.optInt(0, 0);
                int data1 = data.optInt(1, 0);
                int data2 = data.optInt(2, 0);
                int command = data0 & 0xF0;
                int midiChannel = data0 & 0xF;
                if (command == 192) {
                    String midiChannelName;
                    JSONObject midiChannelObject;
                    JSONObject channelObject;
                    JSONObject midiObject = this.getProperties().optJSONObject("midi");
                    if (midiObject == null) {
                        midiObject = new JSONObject();
                    }
                    if ((channelObject = midiObject.optJSONObject("channel")) == null) {
                        channelObject = new JSONObject();
                    }
                    if ((midiChannelObject = channelObject.optJSONObject(midiChannelName = String.valueOf(midiChannel + 1))) == null) {
                        midiChannelObject = new JSONObject();
                    }
                    midiChannelObject.put("program", data1);
                    channelObject.put(midiChannelName, midiChannelObject);
                    midiObject.put("channel", channelObject);
                    this.setProperty("midi", midiObject);
                }
            }
            if (j.hasMetaField("setChannelProperty")) {
                JSONObject storeRequest = j.getRoutePutMeta().optJSONObject("setChannelProperty");
                RoutePutPropertyChangeMessage rppcm = new RoutePutPropertyChangeMessage();
                rppcm.setSource(session);
                for (String k : storeRequest.keySet()) {
                    Object v = storeRequest.opt(k);
                    Object oldValue = this.properties.opt(k);
                    Object newValue = v;
                    if (v instanceof String) {
                        newValue = j.getPathValue((String)v);
                    } else if (v instanceof JSONObject && oldValue instanceof JSONObject) {
                        oldValue = JSONTools.filterJSONObjects((JSONObject)oldValue, (JSONObject)v);
                    }
                    rppcm.addUpdate(this, k, oldValue, newValue);
                }
                j.removeMetaField("setChannelProperty");
                rppcm.processUpdates(session);
            }
            if (j.isType("ConnectionStatus")) {
                if (session != null) {
                    boolean c = j.getRoutePutMeta().optBoolean("connected", false);
                    if (c) {
                        this.addMember(session);
                    } else {
                        this.removeMember(session);
                    }
                } else {
                    this.broadcast(j);
                }
            } else if (j.isType("propertyChange")) {
                RoutePutServer.logWarning("PROPERTY_CHANGE message hit channel " + this.name);
            } else if (this.hasCollector() && !j.isType("propertyChange")) {
                RoutePutSession collector = this.getCollector();
                if (session == collector && session != null) {
                    if (j.hasTargetId()) {
                        RoutePutSession target = this.findMemberById(j.getTargetId());
                        if (target != null) {
                            j.setMetaField("collectorTargeted", true);
                            this.bumpTx();
                            target.send(j);
                        }
                    } else {
                        j.setMetaField("collectorBroadcast", true);
                        this.broadcast(j);
                    }
                } else {
                    j.setMetaField("collectorAbsorbed", true);
                    this.bumpTx();
                    collector.send(j);
                }
            } else if (j.hasTargetId()) {
                RoutePutSession target = this.findMemberById(j.getTargetId());
                if (target != null) {
                    this.bumpTx();
                    target.send(j);
                } else {
                    RoutePutServer.logWarning("PACKET LOST (Target wasn't found): " + j.toString());
                }
            } else {
                this.broadcast(j);
            }
            if (!"routeputDebug".equals(mChan.getName()) && (j.isType("error") || j.isType("info") || j.isType("warning"))) {
                RoutePutMessage l2 = new RoutePutMessage();
                l2.setType(j.getType());
                l2.setChannel("routeputDebug");
                l2.put("text", j.getChannel() + "(" + j.getSourceId() + ") " + j.getType().toUpperCase() + " - " + j.optString("text", "No details provided"));
                RoutePutChannel.getChannel("routeputDebug").broadcast(l2);
            }
            this.messageListeners.parallelStream().forEach(l -> l.onMessage(session, j));
        } else {
            RoutePutServer.logWarning(this.getName() + " was asked to handle a packet that didnt belong to it! Intended for " + mChan.getName());
        }
    }

    protected void broadcast(RoutePutMessage jo) {
        if (jo.hasMetaField("where")) {
            JSONObject where = jo.getRoutePutMeta().optJSONObject("where");
            jo.removeMetaField("where");
            this.members.values().parallelStream().filter(s2 -> JSONTools.matchesFilter((Object)s2.getProperties(), where)).forEach(s2 -> {
                try {
                    this.bumpTx();
                    s2.send(jo.forTarget((RoutePutSession)s2));
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            });
        } else {
            this.members.values().parallelStream().filter(s2 -> s2.isRootConnection()).filter(s2 -> !s2.containsConnectionId(jo.getSourceId())).forEach(s2 -> {
                try {
                    this.bumpTx();
                    s2.send(jo);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            });
        }
    }

    public Collection<RoutePutSession> getMembers() {
        return this.members.values();
    }

    public JSONObject membersAsJSONObject() {
        JSONObject jo = new JSONObject();
        for (RoutePutSession s2 : this.getMembers()) {
            jo.put(s2.getConnectionId(), s2.toJSONObject());
        }
        return jo;
    }

    public JSONArray membersAsJSONArray() {
        JSONArray ja = new JSONArray();
        for (RoutePutSession s2 : this.getMembers()) {
            ja.put(s2.toJSONObject());
        }
        return ja;
    }

    public void mergeProperties(JSONObject props) {
        if (props != null) {
            RoutePutPropertyChangeMessage setChannelPropertyMessage = new RoutePutPropertyChangeMessage();
            setChannelPropertyMessage.setChannel(this);
            for (String key : props.keySet()) {
                Object oldValue = this.properties.opt(key);
                Object newValue = props.opt(key);
                setChannelPropertyMessage.addUpdate(this, key, oldValue, newValue);
                this.firePropertyChange(key, oldValue, newValue);
            }
            setChannelPropertyMessage.processUpdates(null);
        }
    }

    public void setProperty(String key, Object value) {
        Object oldValue = this.properties.opt(key);
        RoutePutPropertyChangeMessage setChannelPropertyMessage = new RoutePutPropertyChangeMessage();
        setChannelPropertyMessage.addUpdate(this, key, oldValue, value);
        setChannelPropertyMessage.processUpdates(null);
    }

    protected void firePropertyChange(String key, Object oldValue, Object newValue) {
        if (newValue == null) {
            this.properties.remove(key);
        } else {
            Object oldValueHeld = this.properties.opt(key);
            if (oldValueHeld instanceof JSONObject && newValue instanceof JSONObject) {
                JSONObject existingJSON = (JSONObject)oldValueHeld;
                JSONObject newJSON = (JSONObject)newValue;
                this.properties.put(key, JSONTools.mergeJSONObjects(existingJSON, newJSON));
            } else {
                this.properties.put(key, newValue);
            }
        }
        this.propertyChangeSupport.firePropertyChange(key, oldValue, newValue);
        this.saveChannelProperties();
    }

    public void removeProperty(RoutePutSession session, String key) {
        Object oldValue = this.properties.opt(key);
        RoutePutPropertyChangeMessage setChannelPropertyMessage = new RoutePutPropertyChangeMessage();
        setChannelPropertyMessage.addUpdate(this, key, oldValue, null);
        setChannelPropertyMessage.processUpdates(session);
    }

    public JSONObject getProperties() {
        return this.properties;
    }

    public static Collection<RoutePutChannel> getChannels() {
        return channels.values();
    }

    public static synchronized RoutePutChannel getChannel(String name) {
        RoutePutChannel.initTracker();
        if (name == null) {
            return null;
        }
        RoutePutChannel chan = channels.get(name);
        if (chan == null) {
            chan = new RoutePutChannel(name);
            channels.put(name, chan);
        } else {
            chan.touch();
        }
        return chan;
    }

    public static synchronized void removeFromAllChannels(RoutePutSession session) {
        channels.values().stream().forEach(c -> c.removeMember(session));
        if (session.isRootConnection() && RoutePutRemoteSession.isInitialized()) {
            for (RoutePutRemoteSession rSession : RoutePutRemoteSession.children(session)) {
                RoutePutChannel.removeFromAllChannels(rSession);
            }
        }
    }

    public static synchronized Collection<RoutePutChannel> channelsWithMember(RoutePutSession session) {
        return channels.values().stream().filter(c -> c.hasMember(session)).collect(Collectors.toList());
    }

    public static JSONObject channelBreakdown() {
        JSONObject jo = new JSONObject();
        for (RoutePutChannel c : channels.values()) {
            String dChan = c.getName();
            jo.put(dChan, c.toJSONObject());
        }
        return jo;
    }

    public boolean equals(RoutePutChannel chan) {
        return this.name.equals(chan.getName());
    }

    public boolean equals(String chan) {
        return this.name.equals(chan);
    }

    public String toString() {
        return this.name;
    }

    public long getIdle() {
        return System.currentTimeMillis() - this.lastAccess;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    private void hibernate() {
        RoutePutServer.saveJSONObject(this.getPropertiesFile(), this.properties);
        RoutePutServer.logIt("Channel \"" + this.getName() + "\" moved to cold storage, because of idle");
        if (this.logWriter != null) {
            try {
                this.logWriter.close();
            }
            catch (Exception e) {
                RoutePutServer.logError(e);
            }
        }
    }

    public int getPingAverage() {
        return this.pingAvg;
    }

    public JSONObject toJSONObject() {
        JSONObject jo = new JSONObject();
        jo.put("name", this.name);
        jo.put("lastAccess", this.lastAccess);
        jo.put("idle", this.getIdle());
        jo.put("members", this.membersAsJSONObject());
        jo.put("memberCount", this.memberCount());
        jo.put("properties", this.getProperties());
        jo.put("msgTxPerSecond", this.msgTxPerSecond);
        jo.put("msgRxPerSecond", this.msgRxPerSecond);
        jo.put("pingAvg", this.pingAvg);
        if (this.collector != null) {
            jo.put("collector", this.collector.getConnectionId());
        }
        return jo;
    }
}

