/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.routeput;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.openstatic.routeput.RoutePutChannel;
import org.openstatic.routeput.RoutePutMessage;
import org.openstatic.routeput.RoutePutMessageListener;
import org.openstatic.routeput.RoutePutServer;
import org.openstatic.routeput.RoutePutSession;

public class RoutePutRemoteSession
implements RoutePutSession {
    private static HashMap<String, RoutePutRemoteSession> sessions;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private String connectionId;
    private Vector<RoutePutMessageListener> listeners;
    private RoutePutSession parent;
    private String remoteIP;
    private RoutePutChannel defaultChannel;
    private JSONObject properties;
    private long rxPackets;
    private long txPackets;
    private long lastReceived;

    public static void init() {
        if (sessions == null) {
            sessions = new HashMap();
        }
    }

    public static boolean isInitialized() {
        return sessions != null;
    }

    public static synchronized RoutePutRemoteSession handleRoutedMessage(RoutePutSession parent, RoutePutMessage jo) {
        RoutePutRemoteSession.init();
        String sourceId = jo.getSourceId();
        if (jo.isType("ConnectionStatus")) {
            boolean c = jo.getRoutePutMeta().optBoolean("connected", false);
            if (c) {
                RoutePutRemoteSession remoteSession = null;
                if (sessions.containsKey(sourceId)) {
                    remoteSession = sessions.get(sourceId);
                } else {
                    RoutePutRemoteSession finalRemoteSession;
                    remoteSession = finalRemoteSession = new RoutePutRemoteSession(parent, sourceId);
                    sessions.put(sourceId, remoteSession);
                }
                remoteSession.handleMessage(jo);
                return remoteSession;
            }
            if (sessions.containsKey(sourceId)) {
                RoutePutRemoteSession remoteSession = sessions.get(sourceId);
                remoteSession.handleMessage(jo);
                return remoteSession;
            }
        } else {
            RoutePutRemoteSession remoteSession = null;
            if (sessions.containsKey(sourceId)) {
                remoteSession = sessions.get(sourceId);
                remoteSession.handleMessage(jo);
                return remoteSession;
            }
        }
        return null;
    }

    public RoutePutRemoteSession(RoutePutSession parent, String connectionId) {
        this.parent = parent;
        this.rxPackets = 0L;
        this.txPackets = 0L;
        this.connectionId = connectionId;
        this.listeners = new Vector();
        this.defaultChannel = parent.getDefaultChannel();
        this.properties = new JSONObject();
        this.lastReceived = System.currentTimeMillis();
    }

    public void maybeDestroy() {
        if (RoutePutChannel.channelsWithMember(this).size() == 0 && sessions.containsKey(this.connectionId)) {
            sessions.remove(this.connectionId);
        }
    }

    private void handleMessage(RoutePutMessage m3) {
        if (this.connectionId.equals(m3.getSourceId())) {
            ++this.rxPackets;
            this.lastReceived = System.currentTimeMillis();
            RoutePutChannel msgChannel = m3.getRoutePutChannel();
            if (m3.isType("ConnectionStatus")) {
                boolean connected = m3.getRoutePutMeta().optBoolean("connected", false);
                if (m3.hasMetaField("properties")) {
                    this.properties = m3.getRoutePutMeta().optJSONObject("properties");
                }
                this.remoteIP = m3.getRoutePutMeta().optString("remoteIP", "?.?.?.?");
                if (this.defaultChannel == null) {
                    this.defaultChannel = msgChannel;
                }
                if (connected) {
                    msgChannel.addMember(this);
                } else {
                    msgChannel.removeMember(this);
                }
            } else if (m3.isType("propertyChange")) {
                RoutePutServer.logWarning("PROPERTY_CHANGE message hit remote session " + this.connectionId);
            } else {
                msgChannel.onMessage(this, m3);
                this.listeners.parallelStream().forEach(r -> r.onMessage(this, m3));
            }
        } else {
            RoutePutServer.logWarning("PACKET LOST (RoutePutRemoteSession asked to handle stray packet): " + m3.toString());
        }
    }

    @Override
    public void firePropertyChange(String key, Object oldValue, Object newValue) {
        this.properties.put(key, newValue);
        this.propertyChangeSupport.firePropertyChange(key, oldValue, newValue);
    }

    @Override
    public boolean isConnected() {
        return this.parent.isConnected() && RoutePutChannel.channelsWithMember(this).size() > 0;
    }

    @Override
    public void addMessageListener(RoutePutMessageListener r) {
        if (!this.listeners.contains(r)) {
            this.listeners.add(r);
        }
    }

    @Override
    public void removeMessageListener(RoutePutMessageListener r) {
        if (this.listeners.contains(r)) {
            this.listeners.remove(r);
        }
    }

    public RoutePutSession getParent() {
        return this.parent;
    }

    public boolean hasParent(RoutePutSession session) {
        return this.parent == session;
    }

    public static Collection<RoutePutRemoteSession> children(RoutePutSession parent) {
        return sessions.values().stream().filter(c -> c.hasParent(parent)).collect(Collectors.toList());
    }

    public static boolean isChild(RoutePutSession parent, String childConnectionId) {
        if (sessions != null) {
            if (sessions.containsKey(childConnectionId)) {
                return sessions.get(childConnectionId).hasParent(parent);
            }
            return false;
        }
        return false;
    }

    public static RoutePutRemoteSession findRemoteSession(String childConnectionId) {
        return sessions.get(childConnectionId);
    }

    public Collection<RoutePutMessageListener> getMessageListeners() {
        return this.listeners;
    }

    public boolean hasMessageListener(RoutePutMessageListener r) {
        return this.listeners.contains(r);
    }

    @Override
    public void send(RoutePutMessage jo) {
        RoutePutMessage msg = jo.forTarget(this);
        msg.setChannelIfNull(this.getDefaultChannel());
        this.getParent().send(jo);
        ++this.txPackets;
    }

    @Override
    public String getRemoteIP() {
        return this.remoteIP;
    }

    @Override
    public String getConnectionId() {
        return this.connectionId;
    }

    @Override
    public RoutePutChannel getDefaultChannel() {
        return this.defaultChannel;
    }

    public long getIdle() {
        return System.currentTimeMillis() - this.lastReceived;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject jo = new JSONObject();
        jo.put("connectionId", this.connectionId);
        if (this.defaultChannel != null) {
            jo.put("defaultChannel", this.defaultChannel.getName());
        }
        List channels = RoutePutChannel.channelsWithMember(this).stream().map(c -> c.getName()).collect(Collectors.toList());
        jo.put("channels", new JSONArray(channels));
        jo.put("properties", this.properties);
        jo.put("idle", this.getIdle());
        if (this.rxPackets > 0L) {
            jo.put("rx", this.rxPackets);
        }
        if (this.txPackets > 0L) {
            jo.put("tx", this.txPackets);
        }
        return jo;
    }

    @Override
    public boolean isRootConnection() {
        return false;
    }

    @Override
    public boolean containsConnectionId(String connectionId) {
        return this.connectionId.equals(connectionId);
    }

    @Override
    public JSONObject getProperties() {
        if (this.remoteIP != null) {
            this.properties.put("_remoteIP", this.remoteIP);
        }
        this.properties.put("_parentConnected", this.parent.isConnected());
        this.properties.put("_parentConnectionId", this.parent.getConnectionId());
        this.properties.put("_class", "RoutePutRemoteSession");
        this.properties.put("_listeners", this.listeners.size());
        return this.properties;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

