/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.routeput;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Random;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.json.JSONArray;
import org.json.JSONObject;
import org.openstatic.routeput.ApiServlet;
import org.openstatic.routeput.BLOBManager;
import org.openstatic.routeput.EventsWebSocketServlet;
import org.openstatic.routeput.InterfaceServlet;
import org.openstatic.routeput.RoutePutChannel;
import org.openstatic.routeput.RoutePutMessage;
import org.openstatic.routeput.RoutePutMessageListener;
import org.openstatic.routeput.RoutePutRemoteSession;
import org.openstatic.routeput.RoutePutServerWebsocket;
import org.openstatic.routeput.RoutePutSession;
import org.openstatic.routeput.client.RoutePutClient;

public class RoutePutServer
implements Runnable {
    private Server httpServer;
    protected LinkedHashMap<String, RoutePutServerWebsocket> sessions;
    protected LinkedHashMap<String, RoutePutClient> upstreams;
    protected JSONObject settings;
    protected static RoutePutServer instance;
    private Thread mainThread;
    private boolean keep_running;
    public RoutePutChannel routeputDebug;
    public File channelRoot;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    protected ApiServlet apiServlet;

    public static synchronized String generateBigAlphaKey(int key_length) {
        try {
            Thread.sleep(1L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Random n = new Random(System.currentTimeMillis());
        String alpha = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        StringBuffer return_key = new StringBuffer();
        int i = 0;
        while (i < key_length) {
            return_key.append(alpha.charAt(n.nextInt(alpha.length())));
            ++i;
        }
        String randKey = return_key.toString();
        return randKey;
    }

    public RoutePutServer(JSONObject settings) {
        instance = this;
        this.settings = settings;
        this.channelRoot = new File(settings.optString("channelStorageRoot", "./channel/"));
        BLOBManager.init(this.settings);
        RoutePutChannel.setChannelRoot(this.channelRoot);
        if (this.settings.has("hostname")) {
            RoutePutChannel.setHostname(this.settings.getString("hostname"));
        }
        this.routeputDebug = RoutePutChannel.getChannel("routeputDebug");
        this.routeputDebug.mergeProperties(this.settings);
        this.routeputDebug.setPermanent(true);
        this.routeputDebug.addMessageListener(new RoutePutMessageListener(){

            @Override
            public void onMessage(RoutePutSession session, RoutePutMessage message) {
                String msgType = message.getType();
                if (msgType != null && (msgType.equals("error") || msgType.equals("info") || msgType.equals("warning"))) {
                    String text = message.optString("text", "");
                    System.err.println("<" + RoutePutServer.this.dateFormat.format(new Date()) + "> " + msgType.toUpperCase() + " " + text);
                }
            }
        });
        this.sessions = new LinkedHashMap();
        this.upstreams = new LinkedHashMap();
        this.httpServer = new Server(settings.optInt("port", 6144));
        ServletContextHandler context = new ServletContextHandler(0);
        context.addFilter(HeaderAddingFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        context.setContextPath("/");
        context.addServlet(ApiServlet.class, settings.optString("apiMountPath", "/api/*"));
        context.addServlet(EventsWebSocketServlet.class, settings.optString("websocketMountPath", "/channel/*"));
        context.addServlet(InterfaceServlet.class, "/*");
        this.httpServer.setHandler(context);
        this.mainThread = new Thread(this);
        this.mainThread.setDaemon(true);
        this.mainThread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                RoutePutServer.instance.keep_running = false;
                RoutePutServer.instance.upstreams.forEach((connectionId, rpc) -> {
                    rpc.setAutoReconnect(false);
                    rpc.close();
                });
            }
        });
        this.connectUpstreams();
    }

    public void connectUpstreams() {
        JSONArray upstreams = this.settings.optJSONArray("upstreams");
        if (upstreams != null) {
            upstreams.forEach(o -> {
                if (o instanceof JSONObject) {
                    JSONObject jo = (JSONObject)o;
                    this.connectUpstream(RoutePutChannel.getChannel(jo.optString("channel", "*")), jo.optString("uri", null));
                }
            });
        }
    }

    @Override
    public void run() {
        RoutePutServer.logIt("Startup complete, Configuration " + this.settings.toString());
        this.keep_running = true;
        int tick = 0;
        while (this.keep_running) {
            try {
                this.everySecond(tick);
                if (++tick >= 60) {
                    tick = 0;
                }
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                RoutePutServer.logError(e);
            }
        }
    }

    public RoutePutSession connectUpstream(RoutePutChannel channel, String uri) {
        RoutePutClient client = new RoutePutClient(channel, uri);
        client.setProperty("upstream", uri);
        client.connect();
        this.upstreams.put(client.getConnectionId(), client);
        return client;
    }

    public void everySecond(int tick) throws Exception {
        if (this.routeputDebug != null) {
            RoutePutMessage jo = new RoutePutMessage();
            jo.put("channelStats", this.channelStats());
            jo.setChannel(this.routeputDebug);
            jo.setLogged(false);
            this.routeputDebug.onMessage(null, jo);
        } else {
            System.err.println("routeputDebug is null");
        }
        if (tick % this.settings.optInt("pingPongSecs", 20) == 0) {
            if (this.settings.optBoolean("logPings", false)) {
                RoutePutServer.logIt("ping/pong sweep triggered");
            }
            this.sessions.values().parallelStream().forEach(s2 -> {
                if (s2 instanceof RoutePutServerWebsocket) {
                    RoutePutServerWebsocket sws = s2;
                    sws.ping();
                }
            });
        }
        if (this.apiServlet != null) {
            RoutePutRemoteSession.children(this.apiServlet).stream().forEach(c -> {
                long idleDestruct = c.getProperties().optLong("idleDestruct", 0L);
                if (c.getIdle() > idleDestruct && idleDestruct > 0L) {
                    RoutePutServer.logIt("Connection " + c.getConnectionId() + " destroyed due to idleDestruct, parent was " + c.getParent().getConnectionId());
                    RoutePutChannel.removeFromAllChannels(c);
                }
            });
            this.apiServlet.everySecond();
        }
    }

    public void setState(boolean b) {
        if (b) {
            try {
                this.httpServer.start();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        } else {
            try {
                this.httpServer.stop();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public RoutePutSession findSessionById(String id) {
        if (this.sessions.containsKey(id)) {
            return this.sessions.get(id);
        }
        return null;
    }

    public JSONObject channelStats() {
        JSONObject jo = new JSONObject();
        for (RoutePutChannel chan : RoutePutChannel.getChannels()) {
            String dChan = chan.getName();
            JSONObject js = new JSONObject();
            js.put("rx", chan.getMessagesRxPerSecond());
            js.put("tx", chan.getMessagesTxPerSecond());
            js.put("ping", chan.getPingAverage());
            js.put("members", chan.memberCount());
            for (RoutePutSession member : chan.getMembers()) {
                JSONObject memberProps = member.getProperties();
                Iterator<String> memberPropsKeys = memberProps.keys();
                while (memberPropsKeys.hasNext()) {
                    String memberPropKey = memberPropsKeys.next();
                    if (!memberPropKey.endsWith("_rssi")) continue;
                    int rssi = memberProps.optInt(memberPropKey, -120);
                    int signal = 0;
                    signal = 120 - Math.abs(rssi);
                    if (signal < 0) {
                        signal = 0;
                    }
                    if (signal > 100) {
                        signal = 100;
                    }
                    js.put(memberPropKey.substring(0, memberPropKey.length() - 5) + "Signal", signal);
                }
            }
            if (chan.hasCollector()) {
                js.put("collector", chan.getCollector().getConnectionId());
            }
            jo.put(dChan, js);
        }
        return jo;
    }

    public static void logIt(String text) {
        RoutePutServer.log("info", text);
    }

    public static void logWarning(String text) {
        RoutePutServer.log("warning", text);
    }

    public static void log(String type, String text) {
        if (instance != null && RoutePutServer.instance.routeputDebug != null) {
            RoutePutMessage l = new RoutePutMessage();
            l.setType(type);
            l.setChannel("routeputDebug");
            l.put("text", text);
            RoutePutServer.instance.routeputDebug.onMessage(null, l);
        }
    }

    public static void logError(Exception e) {
        RoutePutServer.logError("NADA", e);
    }

    public static void logError(String info, Exception e) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            e.printStackTrace(ps);
            String text = "(" + info + ") Exception - " + e.toString() + "\n" + baos.toString();
            RoutePutServer.log("error", text);
        }
        catch (Exception e2) {
            System.err.println("Logging Exception");
            e2.printStackTrace(System.err);
        }
    }

    public static JSONObject loadJSONObject(File file) {
        try {
            int ch;
            FileInputStream fis = new FileInputStream(file);
            StringBuilder builder = new StringBuilder();
            while ((ch = fis.read()) != -1) {
                builder.append((char)ch);
            }
            fis.close();
            JSONObject props = new JSONObject(builder.toString());
            return props;
        }
        catch (Exception e) {
            return new JSONObject();
        }
    }

    public static void saveJSONObject(File file, JSONObject obj) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            PrintStream ps = new PrintStream(fos);
            ps.print(obj.toString(2));
            ps.close();
            fos.close();
        }
        catch (Exception e) {
            RoutePutServer.logError(e);
        }
    }

    public static class HeaderAddingFilter
    implements Filter {
        @Override
        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            if (response instanceof HttpServletResponse) {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                httpResponse.addHeader("Server", "Routeput 1.0");
            }
            chain.doFilter(request, response);
        }

        @Override
        public void init(FilterConfig arg0) throws ServletException {
        }

        @Override
        public void destroy() {
        }
    }
}

