/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.model_objects;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import se.michaelthelin.spotify.model_objects.IModelObject;
import se.michaelthelin.spotify.model_objects.specification.Cursor;
import se.michaelthelin.spotify.model_objects.specification.Paging;
import se.michaelthelin.spotify.model_objects.specification.PagingCursorbased;

public abstract class AbstractModelObject
implements IModelObject {
    protected AbstractModelObject(Builder builder) {
        assert (builder != null);
    }

    public abstract String toString();

    public static abstract class JsonUtil<T>
    implements IModelObject.IJsonUtil<T> {
        @Override
        public boolean hasAndNotNull(JsonObject jsonObject, String memberName) {
            return jsonObject.has(memberName) && !jsonObject.get(memberName).isJsonNull();
        }

        @Override
        public T createModelObject(String json) {
            if (json == null) {
                return null;
            }
            return this.createModelObject(JsonParser.parseString(json).getAsJsonObject());
        }

        @Override
        public T[] createModelObjectArray(JsonArray jsonArray) {
            Object[] array = (Object[])Array.newInstance((Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0], jsonArray.size());
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonElement jsonElement = jsonArray.get(i);
                if (jsonElement instanceof JsonNull) {
                    array[i] = null;
                    continue;
                }
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                array[i] = this.createModelObject(jsonObject);
            }
            return array;
        }

        @Override
        public T[] createModelObjectArray(String json) {
            return this.createModelObjectArray(JsonParser.parseString(json).getAsJsonArray());
        }

        @Override
        public T[] createModelObjectArray(String json, String key) {
            return this.createModelObjectArray(JsonParser.parseString(json).getAsJsonObject().get(key).getAsJsonArray());
        }

        @Override
        public <X> X[] createModelObjectArray(JsonArray jsonArray, Class<X> clazz) {
            Object[] array = (Object[])Array.newInstance(clazz, jsonArray.size());
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonElement jsonElement = jsonArray.get(i);
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                array[i] = this.createModelObject(jsonObject);
            }
            return array;
        }

        @Override
        public Paging<T> createModelObjectPaging(JsonObject jsonObject) {
            return new Paging.Builder().setHref(this.hasAndNotNull(jsonObject, "href") ? jsonObject.get("href").getAsString() : null).setItems(this.hasAndNotNull(jsonObject, "items") ? this.createModelObjectArray(jsonObject.getAsJsonArray("items")) : null).setLimit(this.hasAndNotNull(jsonObject, "limit") ? Integer.valueOf(jsonObject.get("limit").getAsInt()) : null).setNext(this.hasAndNotNull(jsonObject, "next") ? jsonObject.get("next").getAsString() : null).setOffset(this.hasAndNotNull(jsonObject, "offset") ? Integer.valueOf(jsonObject.get("offset").getAsInt()) : null).setPrevious(this.hasAndNotNull(jsonObject, "previous") ? jsonObject.get("previous").getAsString() : null).setTotal(this.hasAndNotNull(jsonObject, "total") ? Integer.valueOf(jsonObject.get("total").getAsInt()) : null).build();
        }

        @Override
        public Paging<T> createModelObjectPaging(String json) {
            return this.createModelObjectPaging(JsonParser.parseString(json).getAsJsonObject());
        }

        @Override
        public Paging<T> createModelObjectPaging(String json, String key) {
            return this.createModelObjectPaging(JsonParser.parseString(json).getAsJsonObject().get(key).getAsJsonObject());
        }

        @Override
        public PagingCursorbased<T> createModelObjectPagingCursorbased(JsonObject jsonObject) {
            return new PagingCursorbased.Builder().setHref(this.hasAndNotNull(jsonObject, "href") ? jsonObject.get("href").getAsString() : null).setItems(this.hasAndNotNull(jsonObject, "items") ? this.createModelObjectArray(jsonObject.getAsJsonArray("items")) : null).setLimit(this.hasAndNotNull(jsonObject, "limit") ? Integer.valueOf(jsonObject.get("limit").getAsInt()) : null).setNext(this.hasAndNotNull(jsonObject, "next") ? jsonObject.get("next").getAsString() : null).setCursors(this.hasAndNotNull(jsonObject, "cursors") ? new Cursor.JsonUtil().createModelObject(jsonObject.getAsJsonObject("cursors")) : null).setTotal(this.hasAndNotNull(jsonObject, "total") ? Integer.valueOf(jsonObject.get("total").getAsInt()) : null).build();
        }

        @Override
        public PagingCursorbased<T> createModelObjectPagingCursorbased(String json) {
            return this.createModelObjectPagingCursorbased(JsonParser.parseString(json).getAsJsonObject());
        }

        @Override
        public PagingCursorbased<T> createModelObjectPagingCursorbased(String json, String key) {
            return this.createModelObjectPagingCursorbased(JsonParser.parseString(json).getAsJsonObject().get(key).getAsJsonObject());
        }
    }

    public static abstract class Builder
    implements IModelObject.Builder {
    }
}

