/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.model_objects.miscellaneous;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import se.michaelthelin.spotify.model_objects.AbstractModelObject;
import se.michaelthelin.spotify.model_objects.miscellaneous.AudioAnalysisMeasure;

@JsonDeserialize(builder=Builder.class)
public class AudioAnalysisSegment
extends AbstractModelObject {
    private final AudioAnalysisMeasure measure;
    private final Float loudnessStart;
    private final Float loudnessMaxTime;
    private final Float loudnessMax;
    private final Float loudnessEnd;
    private final float[] pitches;
    private final float[] timbre;

    private AudioAnalysisSegment(Builder builder) {
        super(builder);
        this.measure = builder.measure;
        this.loudnessStart = builder.loudnessStart;
        this.loudnessMaxTime = builder.loudnessMaxTime;
        this.loudnessMax = builder.loudnessMax;
        this.loudnessEnd = builder.loudnessEnd;
        this.pitches = builder.pitches;
        this.timbre = builder.timbre;
    }

    public AudioAnalysisMeasure getMeasure() {
        return this.measure;
    }

    public Float getLoudnessStart() {
        return this.loudnessStart;
    }

    public Float getLoudnessMaxTime() {
        return this.loudnessMaxTime;
    }

    public Float getLoudnessMax() {
        return this.loudnessMax;
    }

    public Float getLoudnessEnd() {
        return this.loudnessEnd;
    }

    public float[] getPitches() {
        return this.pitches;
    }

    public float[] getTimbre() {
        return this.timbre;
    }

    @Override
    public String toString() {
        return "AudioAnalysisSegment(measure=" + this.measure + ", loudnessStart=" + this.loudnessStart + ", loudnessMaxTime=" + this.loudnessMaxTime + ", loudnessMax=" + this.loudnessMax + ", loudnessEnd=" + this.loudnessEnd + ", pitches=" + Arrays.toString(this.pitches) + ", timbre=" + Arrays.toString(this.timbre) + ")";
    }

    @Override
    public Builder builder() {
        return new Builder();
    }

    public static final class JsonUtil
    extends AbstractModelObject.JsonUtil<AudioAnalysisSegment> {
        @Override
        public AudioAnalysisSegment createModelObject(JsonObject jsonObject) {
            if (jsonObject == null || jsonObject.isJsonNull()) {
                return null;
            }
            return new Builder().setLoudnessEnd(this.hasAndNotNull(jsonObject, "loudness_end") ? Float.valueOf(jsonObject.get("loudness_end").getAsFloat()) : null).setLoudnessMax(this.hasAndNotNull(jsonObject, "loudness_max") ? Float.valueOf(jsonObject.get("loudness_max").getAsFloat()) : null).setLoudnessMaxTime(this.hasAndNotNull(jsonObject, "loudness_max_time") ? Float.valueOf(jsonObject.get("loudness_max_time").getAsFloat()) : null).setLoudnessStart(this.hasAndNotNull(jsonObject, "loudness_start") ? Float.valueOf(jsonObject.get("loudness_start").getAsFloat()) : null).setMeasure(new AudioAnalysisMeasure.JsonUtil().createModelObject(jsonObject)).setPitches(this.hasAndNotNull(jsonObject, "pitches") ? new Gson().fromJson((JsonElement)jsonObject.getAsJsonArray("pitches"), float[].class) : null).setTimbre(this.hasAndNotNull(jsonObject, "timbre") ? new Gson().fromJson((JsonElement)jsonObject.getAsJsonArray("timbre"), float[].class) : null).build();
        }
    }

    public static final class Builder
    extends AbstractModelObject.Builder {
        private AudioAnalysisMeasure measure;
        private Float loudnessStart;
        private Float loudnessMaxTime;
        private Float loudnessMax;
        private Float loudnessEnd;
        private float[] pitches;
        private float[] timbre;

        public Builder setMeasure(AudioAnalysisMeasure measure) {
            this.measure = measure;
            return this;
        }

        public Builder setLoudnessStart(Float loudnessStart) {
            this.loudnessStart = loudnessStart;
            return this;
        }

        public Builder setLoudnessMaxTime(Float loudnessMaxTime) {
            this.loudnessMaxTime = loudnessMaxTime;
            return this;
        }

        public Builder setLoudnessMax(Float loudnessMax) {
            this.loudnessMax = loudnessMax;
            return this;
        }

        public Builder setLoudnessEnd(Float loudnessEnd) {
            this.loudnessEnd = loudnessEnd;
            return this;
        }

        public Builder setPitches(float[] pitches) {
            this.pitches = pitches;
            return this;
        }

        public Builder setTimbre(float[] timbre) {
            this.timbre = timbre;
            return this;
        }

        @Override
        public AudioAnalysisSegment build() {
            return new AudioAnalysisSegment(this);
        }
    }
}

