/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.model_objects.specification;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.neovisionaries.i18n.CountryCode;
import java.util.Arrays;
import se.michaelthelin.spotify.enums.AlbumType;
import se.michaelthelin.spotify.enums.ModelObjectType;
import se.michaelthelin.spotify.enums.ReleaseDatePrecision;
import se.michaelthelin.spotify.model_objects.AbstractModelObject;
import se.michaelthelin.spotify.model_objects.specification.ArtistSimplified;
import se.michaelthelin.spotify.model_objects.specification.Copyright;
import se.michaelthelin.spotify.model_objects.specification.ExternalId;
import se.michaelthelin.spotify.model_objects.specification.ExternalUrl;
import se.michaelthelin.spotify.model_objects.specification.Image;
import se.michaelthelin.spotify.model_objects.specification.Paging;
import se.michaelthelin.spotify.model_objects.specification.TrackSimplified;

@JsonDeserialize(builder=Builder.class)
public class Album
extends AbstractModelObject {
    private final AlbumType albumType;
    private final ArtistSimplified[] artists;
    private final CountryCode[] availableMarkets;
    private final Copyright[] copyrights;
    private final ExternalId externalIds;
    private final ExternalUrl externalUrls;
    private final String[] genres;
    private final String href;
    private final String id;
    private final Image[] images;
    private final String label;
    private final String name;
    private final Integer popularity;
    private final String releaseDate;
    private final ReleaseDatePrecision releaseDatePrecision;
    private final Paging<TrackSimplified> tracks;
    private final ModelObjectType type;
    private final String uri;

    private Album(Builder builder) {
        super(builder);
        this.albumType = builder.albumType;
        this.artists = builder.artists;
        this.availableMarkets = builder.availableMarkets;
        this.copyrights = builder.copyrights;
        this.externalIds = builder.externalIds;
        this.externalUrls = builder.externalUrls;
        this.genres = builder.genres;
        this.href = builder.href;
        this.id = builder.id;
        this.images = builder.images;
        this.label = builder.label;
        this.name = builder.name;
        this.popularity = builder.popularity;
        this.releaseDate = builder.releaseDate;
        this.releaseDatePrecision = builder.releaseDatePrecision;
        this.tracks = builder.tracks;
        this.type = builder.type;
        this.uri = builder.uri;
    }

    public AlbumType getAlbumType() {
        return this.albumType;
    }

    public ArtistSimplified[] getArtists() {
        return this.artists;
    }

    public CountryCode[] getAvailableMarkets() {
        return this.availableMarkets;
    }

    public Copyright[] getCopyrights() {
        return this.copyrights;
    }

    public ExternalId getExternalIds() {
        return this.externalIds;
    }

    public ExternalUrl getExternalUrls() {
        return this.externalUrls;
    }

    public String[] getGenres() {
        return this.genres;
    }

    public String getHref() {
        return this.href;
    }

    public String getId() {
        return this.id;
    }

    public Image[] getImages() {
        return this.images;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public Integer getPopularity() {
        return this.popularity;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public ReleaseDatePrecision getReleaseDatePrecision() {
        return this.releaseDatePrecision;
    }

    public Paging<TrackSimplified> getTracks() {
        return this.tracks;
    }

    public ModelObjectType getType() {
        return this.type;
    }

    public String getUri() {
        return this.uri;
    }

    @Override
    public String toString() {
        return "Album(artists=" + Arrays.toString(this.artists) + ", name=" + this.name + ", albumType=" + this.albumType + ", availableMarkets=" + Arrays.toString((Object[])this.availableMarkets) + ", copyrights=" + Arrays.toString(this.copyrights) + ", externalIds=" + this.externalIds + ", externalUrls=" + this.externalUrls + ", genres=" + Arrays.toString(this.genres) + ", href=" + this.href + ", id=" + this.id + ", images=" + Arrays.toString(this.images) + ", label=" + this.label + ", popularity=" + this.popularity + ", releaseDate=" + this.releaseDate + ", releaseDatePrecision=" + this.releaseDatePrecision + ", tracks=" + this.tracks + ", type=" + this.type + ", uri=" + this.uri + ")";
    }

    @Override
    public Builder builder() {
        return new Builder();
    }

    public static final class JsonUtil
    extends AbstractModelObject.JsonUtil<Album> {
        @Override
        public Album createModelObject(JsonObject jsonObject) {
            if (jsonObject == null || jsonObject.isJsonNull()) {
                return null;
            }
            return new Builder().setAlbumType(this.hasAndNotNull(jsonObject, "album_type") ? AlbumType.keyOf(jsonObject.get("album_type").getAsString().toLowerCase()) : null).setArtists(this.hasAndNotNull(jsonObject, "artists") ? (ArtistSimplified[])new ArtistSimplified.JsonUtil().createModelObjectArray(jsonObject.getAsJsonArray("artists")) : null).setAvailableMarkets(this.hasAndNotNull(jsonObject, "available_markets") ? new Gson().fromJson((JsonElement)jsonObject.getAsJsonArray("available_markets"), CountryCode[].class) : null).setCopyrights(this.hasAndNotNull(jsonObject, "copyrights") ? (Copyright[])new Copyright.JsonUtil().createModelObjectArray(jsonObject.getAsJsonArray("copyrights")) : null).setExternalIds(this.hasAndNotNull(jsonObject, "external_ids") ? new ExternalId.JsonUtil().createModelObject(jsonObject.getAsJsonObject("external_ids")) : null).setExternalUrls(this.hasAndNotNull(jsonObject, "external_urls") ? new ExternalUrl.JsonUtil().createModelObject(jsonObject.getAsJsonObject("external_urls")) : null).setGenres(this.hasAndNotNull(jsonObject, "genres") ? new Gson().fromJson((JsonElement)jsonObject.getAsJsonArray("genres"), String[].class) : null).setHref(this.hasAndNotNull(jsonObject, "href") ? jsonObject.get("href").getAsString() : null).setId(this.hasAndNotNull(jsonObject, "id") ? jsonObject.get("id").getAsString() : null).setImages(this.hasAndNotNull(jsonObject, "images") ? (Image[])new Image.JsonUtil().createModelObjectArray(jsonObject.getAsJsonArray("images")) : null).setLabel(this.hasAndNotNull(jsonObject, "label") ? jsonObject.get("label").getAsString() : null).setName(this.hasAndNotNull(jsonObject, "name") ? jsonObject.get("name").getAsString() : null).setPopularity(this.hasAndNotNull(jsonObject, "popularity") ? Integer.valueOf(jsonObject.get("popularity").getAsInt()) : null).setReleaseDate(this.hasAndNotNull(jsonObject, "release_date") ? jsonObject.get("release_date").getAsString() : null).setReleaseDatePrecision(this.hasAndNotNull(jsonObject, "release_date_precision") ? ReleaseDatePrecision.keyOf(jsonObject.get("release_date_precision").getAsString().toLowerCase()) : null).setTracks(this.hasAndNotNull(jsonObject, "tracks") ? new TrackSimplified.JsonUtil().createModelObjectPaging(jsonObject.getAsJsonObject("tracks")) : null).setType(this.hasAndNotNull(jsonObject, "type") ? ModelObjectType.keyOf(jsonObject.get("type").getAsString().toLowerCase()) : null).setUri(this.hasAndNotNull(jsonObject, "uri") ? jsonObject.get("uri").getAsString() : null).build();
        }
    }

    public static final class Builder
    extends AbstractModelObject.Builder {
        private AlbumType albumType;
        private ArtistSimplified[] artists;
        private CountryCode[] availableMarkets;
        private Copyright[] copyrights;
        private ExternalId externalIds;
        private ExternalUrl externalUrls;
        private String[] genres;
        private String href;
        private String id;
        private Image[] images;
        private String label;
        private String name;
        private Integer popularity;
        private String releaseDate;
        private ReleaseDatePrecision releaseDatePrecision;
        private Paging<TrackSimplified> tracks;
        private ModelObjectType type;
        private String uri;

        public Builder setAlbumType(AlbumType albumType) {
            this.albumType = albumType;
            return this;
        }

        public Builder setArtists(ArtistSimplified ... artists) {
            this.artists = artists;
            return this;
        }

        public Builder setAvailableMarkets(CountryCode ... availableMarkets) {
            this.availableMarkets = availableMarkets;
            return this;
        }

        public Builder setCopyrights(Copyright ... copyrights) {
            this.copyrights = copyrights;
            return this;
        }

        public Builder setExternalIds(ExternalId externalIds) {
            this.externalIds = externalIds;
            return this;
        }

        public Builder setExternalUrls(ExternalUrl externalUrls) {
            this.externalUrls = externalUrls;
            return this;
        }

        public Builder setGenres(String ... genres) {
            this.genres = genres;
            return this;
        }

        public Builder setHref(String href) {
            this.href = href;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setImages(Image ... images) {
            this.images = images;
            return this;
        }

        public Builder setLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setPopularity(Integer popularity) {
            this.popularity = popularity;
            return this;
        }

        public Builder setReleaseDate(String releaseDate) {
            this.releaseDate = releaseDate;
            return this;
        }

        public Builder setReleaseDatePrecision(ReleaseDatePrecision releaseDatePrecision) {
            this.releaseDatePrecision = releaseDatePrecision;
            return this;
        }

        public Builder setTracks(Paging<TrackSimplified> tracks) {
            this.tracks = tracks;
            return this;
        }

        public Builder setType(ModelObjectType type) {
            this.type = type;
            return this;
        }

        public Builder setUri(String uri) {
            this.uri = uri;
            return this;
        }

        @Override
        public Album build() {
            return new Album(this);
        }
    }
}

