/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests.authorization.authorization_code;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.net.URI;
import se.michaelthelin.spotify.requests.AbstractRequest;

@JsonDeserialize(builder=Builder.class)
public class AuthorizationCodeUriRequest
extends AbstractRequest<URI> {
    private AuthorizationCodeUriRequest(Builder builder) {
        super(builder);
    }

    @Override
    public URI execute() {
        return this.getUri();
    }

    public static final class Builder
    extends AbstractRequest.Builder<URI, Builder> {
        public Builder client_id(String client_id) {
            assert (client_id != null);
            assert (!client_id.equals(""));
            return (Builder)this.setQueryParameter("client_id", client_id);
        }

        public Builder response_type(String response_type) {
            assert (response_type != null);
            assert (response_type.equals("code"));
            return (Builder)this.setQueryParameter("response_type", response_type);
        }

        public Builder redirect_uri(URI redirect_uri) {
            assert (redirect_uri != null);
            return (Builder)this.setQueryParameter("redirect_uri", redirect_uri.toString());
        }

        public Builder code_challenge_method(String code_challenge_method) {
            assert (code_challenge_method != null);
            assert (code_challenge_method.equals("S256"));
            return (Builder)this.setQueryParameter("code_challenge_method", code_challenge_method);
        }

        public Builder code_challenge(String code_challenge) {
            assert (code_challenge != null);
            assert (!code_challenge.equals(""));
            return (Builder)this.setQueryParameter("code_challenge", code_challenge);
        }

        public Builder state(String state) {
            assert (state != null);
            assert (!state.equals(""));
            return (Builder)this.setQueryParameter("state", state);
        }

        public Builder scope(String scope) {
            assert (scope != null);
            assert (!scope.equals(""));
            return (Builder)this.setQueryParameter("scope", scope);
        }

        public Builder show_dialog(boolean show_dialog) {
            return (Builder)this.setQueryParameter("show_dialog", (Object)show_dialog);
        }

        public AuthorizationCodeUriRequest build() {
            this.setHost("accounts.spotify.com");
            this.setPort(443);
            this.setScheme("https");
            this.setPath("/authorize");
            return new AuthorizationCodeUriRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

