/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests.data.browse;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import com.neovisionaries.i18n.LanguageCode;
import java.io.IOException;
import org.apache.hc.core5.http.ParseException;
import se.michaelthelin.spotify.exceptions.SpotifyWebApiException;
import se.michaelthelin.spotify.model_objects.specification.Category;
import se.michaelthelin.spotify.requests.data.AbstractDataRequest;

@JsonDeserialize(builder=Builder.class)
public class GetCategoryRequest
extends AbstractDataRequest<Category> {
    private GetCategoryRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Category execute() throws IOException, SpotifyWebApiException, ParseException {
        return (Category)new Category.JsonUtil().createModelObject(this.getJson());
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<Category, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder category_id(String category_id) {
            assert (category_id != null);
            assert (category_id.matches("^[a-z]+$"));
            return (Builder)this.setPathParameter("category_id", category_id);
        }

        public Builder country(CountryCode country) {
            assert (country != null);
            return (Builder)this.setQueryParameter("country", (Object)country);
        }

        public Builder locale(String locale) {
            assert (locale != null);
            assert (locale.contains("_"));
            String[] localeParts = locale.split("_");
            assert (localeParts.length == 2);
            assert (LanguageCode.getByCode(localeParts[0]) != null);
            assert (CountryCode.getByCode(localeParts[1]) != null);
            return (Builder)this.setQueryParameter("locale", locale);
        }

        public GetCategoryRequest build() {
            this.setPath("/v1/browse/categories/{category_id}");
            return new GetCategoryRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

