/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests.data.browse;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import com.neovisionaries.i18n.LanguageCode;
import java.io.IOException;
import org.apache.hc.core5.http.ParseException;
import se.michaelthelin.spotify.exceptions.SpotifyWebApiException;
import se.michaelthelin.spotify.model_objects.specification.Category;
import se.michaelthelin.spotify.model_objects.specification.Paging;
import se.michaelthelin.spotify.requests.data.AbstractDataPagingRequest;
import se.michaelthelin.spotify.requests.data.AbstractDataRequest;

@JsonDeserialize(builder=Builder.class)
public class GetListOfCategoriesRequest
extends AbstractDataRequest<Paging<Category>> {
    private GetListOfCategoriesRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Paging<Category> execute() throws IOException, SpotifyWebApiException, ParseException {
        return new Category.JsonUtil().createModelObjectPaging(this.getJson(), "categories");
    }

    public static final class Builder
    extends AbstractDataPagingRequest.Builder<Category, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder country(CountryCode country) {
            assert (country != null);
            return (Builder)this.setQueryParameter("country", (Object)country);
        }

        public Builder locale(String locale) {
            assert (locale != null);
            assert (locale.contains("_"));
            String[] localeParts = locale.split("_");
            assert (localeParts.length == 2);
            assert (LanguageCode.getByCode(localeParts[0]) != null);
            assert (CountryCode.getByCode(localeParts[1]) != null);
            return (Builder)this.setQueryParameter("locale", locale);
        }

        @Override
        public Builder limit(Integer limit) {
            assert (1 <= limit && limit <= 50);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        @Override
        public Builder offset(Integer offset) {
            assert (offset >= 0);
            return (Builder)this.setQueryParameter("offset", offset);
        }

        public GetListOfCategoriesRequest build() {
            this.setPath("/v1/browse/categories");
            return new GetListOfCategoriesRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

