/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests.data.browse;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import java.io.IOException;
import org.apache.hc.core5.http.ParseException;
import se.michaelthelin.spotify.exceptions.SpotifyWebApiException;
import se.michaelthelin.spotify.model_objects.specification.AlbumSimplified;
import se.michaelthelin.spotify.model_objects.specification.Paging;
import se.michaelthelin.spotify.requests.data.AbstractDataPagingRequest;
import se.michaelthelin.spotify.requests.data.AbstractDataRequest;

@JsonDeserialize(builder=Builder.class)
public class GetListOfNewReleasesRequest
extends AbstractDataRequest<Paging<AlbumSimplified>> {
    private GetListOfNewReleasesRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Paging<AlbumSimplified> execute() throws IOException, SpotifyWebApiException, ParseException {
        return new AlbumSimplified.JsonUtil().createModelObjectPaging(this.getJson(), "albums");
    }

    public static final class Builder
    extends AbstractDataPagingRequest.Builder<AlbumSimplified, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder country(CountryCode country) {
            assert (country != null);
            return (Builder)this.setQueryParameter("country", (Object)country);
        }

        @Override
        public Builder limit(Integer limit) {
            assert (1 <= limit && limit <= 50);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        @Override
        public Builder offset(Integer offset) {
            assert (offset >= 0);
            return (Builder)this.setQueryParameter("offset", offset);
        }

        public GetListOfNewReleasesRequest build() {
            this.setPath("/v1/browse/new-releases");
            return new GetListOfNewReleasesRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

