/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests.data.episodes;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import java.io.IOException;
import org.apache.hc.core5.http.ParseException;
import se.michaelthelin.spotify.exceptions.SpotifyWebApiException;
import se.michaelthelin.spotify.model_objects.specification.Episode;
import se.michaelthelin.spotify.requests.data.AbstractDataRequest;

@JsonDeserialize(builder=Builder.class)
public class GetSeveralEpisodesRequest
extends AbstractDataRequest<Episode[]> {
    private GetSeveralEpisodesRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Episode[] execute() throws IOException, SpotifyWebApiException, ParseException {
        return (Episode[])new Episode.JsonUtil().createModelObjectArray(this.getJson(), "episodes");
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<Episode[], Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder ids(String ids) {
            assert (ids != null);
            assert (ids.split(",").length <= 50);
            return (Builder)this.setQueryParameter("ids", ids);
        }

        public Builder market(CountryCode market) {
            assert (market != null);
            return (Builder)this.setQueryParameter("market", (Object)market);
        }

        public GetSeveralEpisodesRequest build() {
            this.setPath("/v1/episodes");
            return new GetSeveralEpisodesRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

