/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests.data.follow;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import org.apache.hc.core5.http.ParseException;
import se.michaelthelin.spotify.exceptions.SpotifyWebApiException;
import se.michaelthelin.spotify.requests.data.AbstractDataRequest;

@JsonDeserialize(builder=Builder.class)
public class CheckUsersFollowPlaylistRequest
extends AbstractDataRequest<Boolean[]> {
    private CheckUsersFollowPlaylistRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Boolean[] execute() throws IOException, SpotifyWebApiException, ParseException {
        return new Gson().fromJson((JsonElement)JsonParser.parseString(this.getJson()).getAsJsonArray(), Boolean[].class);
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<Boolean[], Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder owner_id(String owner_id) {
            assert (owner_id != null);
            assert (!owner_id.equals(""));
            return (Builder)this.setPathParameter("owner_id", owner_id);
        }

        public Builder playlist_id(String playlist_id) {
            assert (playlist_id != null);
            assert (!playlist_id.equals(""));
            return (Builder)this.setPathParameter("playlist_id", playlist_id);
        }

        public Builder ids(String ids) {
            assert (ids != null);
            assert (ids.split(",").length <= 5);
            return (Builder)this.setQueryParameter("ids", ids);
        }

        public CheckUsersFollowPlaylistRequest build() {
            this.setPath("/v1/users/{owner_id}/playlists/{playlist_id}/followers/contains");
            return new CheckUsersFollowPlaylistRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

