/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests.data.library;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.gson.JsonArray;
import java.io.IOException;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.ParseException;
import se.michaelthelin.spotify.exceptions.SpotifyWebApiException;
import se.michaelthelin.spotify.requests.data.AbstractDataRequest;

@JsonDeserialize(builder=Builder.class)
public class RemoveAlbumsForCurrentUserRequest
extends AbstractDataRequest<String> {
    private RemoveAlbumsForCurrentUserRequest(Builder builder) {
        super(builder);
    }

    @Override
    public String execute() throws IOException, SpotifyWebApiException, ParseException {
        return this.deleteJson();
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<String, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder ids(String ids) {
            assert (ids != null);
            assert (ids.split(",").length <= 50);
            return (Builder)this.setQueryParameter("ids", ids);
        }

        public Builder ids(JsonArray ids) {
            assert (ids != null);
            assert (!ids.isJsonNull());
            assert (ids.size() <= 50);
            return (Builder)this.setBodyParameter("ids", ids);
        }

        public RemoveAlbumsForCurrentUserRequest build() {
            this.setContentType(ContentType.APPLICATION_JSON);
            this.setPath("/v1/me/albums");
            return new RemoveAlbumsForCurrentUserRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

