/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests.data.playlists;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import java.io.IOException;
import org.apache.hc.core5.http.ParseException;
import se.michaelthelin.spotify.exceptions.SpotifyWebApiException;
import se.michaelthelin.spotify.model_objects.specification.Playlist;
import se.michaelthelin.spotify.requests.data.AbstractDataRequest;

@JsonDeserialize(builder=Builder.class)
public class GetPlaylistRequest
extends AbstractDataRequest<Playlist> {
    private GetPlaylistRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Playlist execute() throws IOException, SpotifyWebApiException, ParseException {
        return (Playlist)new Playlist.JsonUtil().createModelObject(this.getJson());
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<Playlist, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder playlist_id(String playlist_id) {
            assert (playlist_id != null);
            assert (!playlist_id.equals(""));
            return (Builder)this.setPathParameter("playlist_id", playlist_id);
        }

        public Builder fields(String fields) {
            assert (fields != null);
            assert (!fields.equals(""));
            return (Builder)this.setQueryParameter("fields", fields);
        }

        public Builder market(CountryCode market) {
            assert (market != null);
            return (Builder)this.setQueryParameter("market", (Object)market);
        }

        public Builder additionalTypes(String additionalTypes) {
            assert (additionalTypes != null);
            assert (additionalTypes.matches("((^|,)(episode|track))+$"));
            return (Builder)this.setQueryParameter("additional_types", additionalTypes);
        }

        public GetPlaylistRequest build() {
            this.setPath("/v1/playlists/{playlist_id}");
            return new GetPlaylistRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

