/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests.data.tracks;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import java.io.IOException;
import org.apache.hc.core5.http.ParseException;
import se.michaelthelin.spotify.exceptions.SpotifyWebApiException;
import se.michaelthelin.spotify.model_objects.specification.Track;
import se.michaelthelin.spotify.requests.data.AbstractDataRequest;

@JsonDeserialize(builder=Builder.class)
public class GetSeveralTracksRequest
extends AbstractDataRequest<Track[]> {
    private GetSeveralTracksRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Track[] execute() throws IOException, SpotifyWebApiException, ParseException {
        return (Track[])new Track.JsonUtil().createModelObjectArray(this.getJson(), "tracks");
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<Track[], Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder ids(String ids) {
            assert (ids != null);
            assert (ids.split(",").length <= 50);
            return (Builder)this.setQueryParameter("ids", ids);
        }

        public Builder market(CountryCode market) {
            assert (market != null);
            return (Builder)this.setQueryParameter("market", (Object)market);
        }

        public GetSeveralTracksRequest build() {
            this.setPath("/v1/tracks");
            return new GetSeveralTracksRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

