/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.enums;

import java.util.HashMap;
import java.util.Map;

public enum ProductType {
    BASIC_DESKTOP("basic-desktop"),
    DAYPASS("daypass"),
    FREE("free"),
    OPEN("open"),
    PREMIUM("premium");

    private static final Map<String, ProductType> map;
    public final String type;

    private ProductType(String type) {
        this.type = type;
    }

    public static ProductType keyOf(String type) {
        return map.get(type);
    }

    public String getType() {
        return this.type;
    }

    static {
        map = new HashMap<String, ProductType>();
        for (ProductType productType : ProductType.values()) {
            map.put(productType.type, productType);
        }
    }
}

