/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.model_objects.miscellaneous;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.gson.JsonObject;
import java.util.Arrays;
import se.michaelthelin.spotify.model_objects.AbstractModelObject;
import se.michaelthelin.spotify.model_objects.miscellaneous.AudioAnalysisMeasure;
import se.michaelthelin.spotify.model_objects.miscellaneous.AudioAnalysisMeta;
import se.michaelthelin.spotify.model_objects.miscellaneous.AudioAnalysisSection;
import se.michaelthelin.spotify.model_objects.miscellaneous.AudioAnalysisSegment;
import se.michaelthelin.spotify.model_objects.miscellaneous.AudioAnalysisTrack;

@JsonDeserialize(builder=Builder.class)
public class AudioAnalysis
extends AbstractModelObject {
    private final AudioAnalysisMeasure[] bars;
    private final AudioAnalysisMeasure[] beats;
    private final AudioAnalysisMeta meta;
    private final AudioAnalysisSection[] sections;
    private final AudioAnalysisSegment[] segments;
    private final AudioAnalysisMeasure[] tatums;
    private final AudioAnalysisTrack track;

    private AudioAnalysis(Builder builder) {
        super(builder);
        this.bars = builder.bars;
        this.beats = builder.beats;
        this.meta = builder.meta;
        this.sections = builder.sections;
        this.segments = builder.segments;
        this.tatums = builder.tatums;
        this.track = builder.track;
    }

    public AudioAnalysisMeasure[] getBars() {
        return this.bars;
    }

    public AudioAnalysisMeasure[] getBeats() {
        return this.beats;
    }

    public AudioAnalysisMeta getMeta() {
        return this.meta;
    }

    public AudioAnalysisSection[] getSections() {
        return this.sections;
    }

    public AudioAnalysisSegment[] getSegments() {
        return this.segments;
    }

    public AudioAnalysisMeasure[] getTatums() {
        return this.tatums;
    }

    public AudioAnalysisTrack getTrack() {
        return this.track;
    }

    @Override
    public String toString() {
        return "AudioAnalysis(bars=" + Arrays.toString(this.bars) + ", beats=" + Arrays.toString(this.beats) + ", meta=" + this.meta + ", sections=" + Arrays.toString(this.sections) + ", segments=" + Arrays.toString(this.segments) + ", tatums=" + Arrays.toString(this.tatums) + ", track=" + this.track + ")";
    }

    @Override
    public Builder builder() {
        return new Builder();
    }

    public static final class JsonUtil
    extends AbstractModelObject.JsonUtil<AudioAnalysis> {
        @Override
        public AudioAnalysis createModelObject(JsonObject jsonObject) {
            if (jsonObject == null || jsonObject.isJsonNull()) {
                return null;
            }
            return new Builder().setBars(this.hasAndNotNull(jsonObject, "bars") ? (AudioAnalysisMeasure[])new AudioAnalysisMeasure.JsonUtil().createModelObjectArray(jsonObject.getAsJsonArray("bars")) : null).setBeats(this.hasAndNotNull(jsonObject, "beats") ? (AudioAnalysisMeasure[])new AudioAnalysisMeasure.JsonUtil().createModelObjectArray(jsonObject.getAsJsonArray("beats")) : null).setMeta(this.hasAndNotNull(jsonObject, "meta") ? new AudioAnalysisMeta.JsonUtil().createModelObject(jsonObject.getAsJsonObject("meta")) : null).setSections(this.hasAndNotNull(jsonObject, "sections") ? (AudioAnalysisSection[])new AudioAnalysisSection.JsonUtil().createModelObjectArray(jsonObject.getAsJsonArray("sections")) : null).setSegments(this.hasAndNotNull(jsonObject, "segments") ? (AudioAnalysisSegment[])new AudioAnalysisSegment.JsonUtil().createModelObjectArray(jsonObject.getAsJsonArray("segments")) : null).setTatums(this.hasAndNotNull(jsonObject, "tatums") ? (AudioAnalysisMeasure[])new AudioAnalysisMeasure.JsonUtil().createModelObjectArray(jsonObject.getAsJsonArray("tatums")) : null).setTrack(this.hasAndNotNull(jsonObject, "track") ? new AudioAnalysisTrack.JsonUtil().createModelObject(jsonObject.getAsJsonObject("track")) : null).build();
        }
    }

    public static final class Builder
    extends AbstractModelObject.Builder {
        private AudioAnalysisMeasure[] bars;
        private AudioAnalysisMeasure[] beats;
        private AudioAnalysisMeta meta;
        private AudioAnalysisSection[] sections;
        private AudioAnalysisSegment[] segments;
        private AudioAnalysisMeasure[] tatums;
        private AudioAnalysisTrack track;

        public Builder setBars(AudioAnalysisMeasure[] bars) {
            this.bars = bars;
            return this;
        }

        public Builder setBeats(AudioAnalysisMeasure[] beats) {
            this.beats = beats;
            return this;
        }

        public Builder setMeta(AudioAnalysisMeta meta) {
            this.meta = meta;
            return this;
        }

        public Builder setSections(AudioAnalysisSection[] sections) {
            this.sections = sections;
            return this;
        }

        public Builder setSegments(AudioAnalysisSegment[] segments) {
            this.segments = segments;
            return this;
        }

        public Builder setTatums(AudioAnalysisMeasure[] tatums) {
            this.tatums = tatums;
            return this;
        }

        public Builder setTrack(AudioAnalysisTrack track) {
            this.track = track;
            return this;
        }

        @Override
        public AudioAnalysis build() {
            return new AudioAnalysis(this);
        }
    }
}

