/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.model_objects.specification;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.neovisionaries.i18n.CountryCode;
import java.util.Arrays;
import se.michaelthelin.spotify.enums.ModelObjectType;
import se.michaelthelin.spotify.model_objects.AbstractModelObject;
import se.michaelthelin.spotify.model_objects.IPlaylistItem;
import se.michaelthelin.spotify.model_objects.miscellaneous.Restrictions;
import se.michaelthelin.spotify.model_objects.specification.AlbumSimplified;
import se.michaelthelin.spotify.model_objects.specification.ArtistSimplified;
import se.michaelthelin.spotify.model_objects.specification.ExternalId;
import se.michaelthelin.spotify.model_objects.specification.ExternalUrl;
import se.michaelthelin.spotify.model_objects.specification.TrackLink;
import se.michaelthelin.spotify.requests.data.personalization.interfaces.IArtistTrackModelObject;
import se.michaelthelin.spotify.requests.data.search.interfaces.ISearchModelObject;

@JsonDeserialize(builder=Builder.class)
public class Track
extends AbstractModelObject
implements IArtistTrackModelObject,
ISearchModelObject,
IPlaylistItem {
    private final AlbumSimplified album;
    private final ArtistSimplified[] artists;
    private final CountryCode[] availableMarkets;
    private final Integer discNumber;
    private final Integer durationMs;
    private final Boolean explicit;
    private final ExternalId externalIds;
    private final ExternalUrl externalUrls;
    private final String href;
    private final String id;
    private final Boolean isPlayable;
    private final TrackLink linkedFrom;
    private final Restrictions restrictions;
    private final String name;
    private final Integer popularity;
    private final String previewUrl;
    private final Integer trackNumber;
    private final ModelObjectType type;
    private final String uri;

    private Track(Builder builder) {
        super(builder);
        this.album = builder.album;
        this.artists = builder.artists;
        this.availableMarkets = builder.availableMarkets;
        this.discNumber = builder.discNumber;
        this.durationMs = builder.durationMs;
        this.explicit = builder.explicit;
        this.externalIds = builder.externalIds;
        this.externalUrls = builder.externalUrls;
        this.href = builder.href;
        this.id = builder.id;
        this.isPlayable = builder.isPlayable;
        this.linkedFrom = builder.linkedFrom;
        this.restrictions = builder.restrictions;
        this.name = builder.name;
        this.popularity = builder.popularity;
        this.previewUrl = builder.previewUrl;
        this.trackNumber = builder.trackNumber;
        this.type = builder.type;
        this.uri = builder.uri;
    }

    public AlbumSimplified getAlbum() {
        return this.album;
    }

    public ArtistSimplified[] getArtists() {
        return this.artists;
    }

    public CountryCode[] getAvailableMarkets() {
        return this.availableMarkets;
    }

    public Integer getDiscNumber() {
        return this.discNumber;
    }

    @Override
    public Integer getDurationMs() {
        return this.durationMs;
    }

    public Boolean getIsExplicit() {
        return this.explicit;
    }

    public ExternalId getExternalIds() {
        return this.externalIds;
    }

    @Override
    public ExternalUrl getExternalUrls() {
        return this.externalUrls;
    }

    @Override
    public String getHref() {
        return this.href;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Boolean getIsPlayable() {
        return this.isPlayable;
    }

    public TrackLink getLinkedFrom() {
        return this.linkedFrom;
    }

    public Restrictions getRestrictions() {
        return this.restrictions;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Integer getPopularity() {
        return this.popularity;
    }

    public String getPreviewUrl() {
        return this.previewUrl;
    }

    public Integer getTrackNumber() {
        return this.trackNumber;
    }

    @Override
    public ModelObjectType getType() {
        return this.type;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public String toString() {
        return "Track(name=" + this.name + ", artists=" + Arrays.toString(this.artists) + ", album=" + this.album + ", availableMarkets=" + Arrays.toString(this.availableMarkets) + ", discNumber=" + this.discNumber + ", durationMs=" + this.durationMs + ", explicit=" + this.explicit + ", externalIds=" + this.externalIds + ", externalUrls=" + this.externalUrls + ", href=" + this.href + ", id=" + this.id + ", isPlayable=" + this.isPlayable + ", linkedFrom=" + this.linkedFrom + ", restrictions=" + this.restrictions + ", popularity=" + this.popularity + ", previewUrl=" + this.previewUrl + ", trackNumber=" + this.trackNumber + ", type=" + this.type + ", uri=" + this.uri + ")";
    }

    @Override
    public Builder builder() {
        return new Builder();
    }

    public static final class JsonUtil
    extends AbstractModelObject.JsonUtil<Track> {
        @Override
        public Track createModelObject(JsonObject jsonObject) {
            if (jsonObject == null || jsonObject.isJsonNull()) {
                return null;
            }
            return new Builder().setAlbum(this.hasAndNotNull(jsonObject, "album") ? new AlbumSimplified.JsonUtil().createModelObject(jsonObject.getAsJsonObject("album")) : null).setArtists(this.hasAndNotNull(jsonObject, "artists") ? (ArtistSimplified[])new ArtistSimplified.JsonUtil().createModelObjectArray(jsonObject.getAsJsonArray("artists")) : null).setAvailableMarkets(this.hasAndNotNull(jsonObject, "available_markets") ? (CountryCode[])new Gson().fromJson((JsonElement)jsonObject.getAsJsonArray("available_markets"), CountryCode[].class) : null).setDiscNumber(this.hasAndNotNull(jsonObject, "disc_number") ? Integer.valueOf(jsonObject.get("disc_number").getAsInt()) : null).setDurationMs(this.hasAndNotNull(jsonObject, "duration_ms") ? Integer.valueOf(jsonObject.get("duration_ms").getAsInt()) : null).setExplicit(this.hasAndNotNull(jsonObject, "explicit") ? Boolean.valueOf(jsonObject.get("explicit").getAsBoolean()) : null).setExternalIds(this.hasAndNotNull(jsonObject, "external_ids") ? new ExternalId.JsonUtil().createModelObject(jsonObject.getAsJsonObject("external_ids")) : null).setExternalUrls(this.hasAndNotNull(jsonObject, "external_urls") ? new ExternalUrl.JsonUtil().createModelObject(jsonObject.getAsJsonObject("external_urls")) : null).setHref(this.hasAndNotNull(jsonObject, "href") ? jsonObject.get("href").getAsString() : null).setId(this.hasAndNotNull(jsonObject, "id") ? jsonObject.get("id").getAsString() : null).setIsPlayable(this.hasAndNotNull(jsonObject, "is_playable") ? Boolean.valueOf(jsonObject.get("is_playable").getAsBoolean()) : null).setLinkedFrom(this.hasAndNotNull(jsonObject, "linked_from") ? new TrackLink.JsonUtil().createModelObject(jsonObject.get("linked_from").getAsJsonObject()) : null).setRestrictions(this.hasAndNotNull(jsonObject, "restrictions") ? new Restrictions.JsonUtil().createModelObject(jsonObject.get("restrictions").getAsJsonObject()) : null).setName(this.hasAndNotNull(jsonObject, "name") ? jsonObject.get("name").getAsString() : null).setPopularity(this.hasAndNotNull(jsonObject, "popularity") ? Integer.valueOf(jsonObject.get("popularity").getAsInt()) : null).setPreviewUrl(this.hasAndNotNull(jsonObject, "preview_url") ? jsonObject.get("preview_url").getAsString() : null).setTrackNumber(this.hasAndNotNull(jsonObject, "track_number") ? Integer.valueOf(jsonObject.get("track_number").getAsInt()) : null).setType(this.hasAndNotNull(jsonObject, "type") ? ModelObjectType.keyOf(jsonObject.get("type").getAsString().toLowerCase()) : null).setUri(this.hasAndNotNull(jsonObject, "uri") ? jsonObject.get("uri").getAsString() : null).build();
        }
    }

    public static final class Builder
    extends AbstractModelObject.Builder {
        private AlbumSimplified album;
        private ArtistSimplified[] artists;
        private CountryCode[] availableMarkets;
        private Integer discNumber;
        private Integer durationMs;
        private Boolean explicit;
        private ExternalId externalIds;
        private ExternalUrl externalUrls;
        private String href;
        private String id;
        private Boolean isPlayable;
        private TrackLink linkedFrom;
        private Restrictions restrictions;
        private String name;
        private Integer popularity;
        private String previewUrl;
        private Integer trackNumber;
        private ModelObjectType type;
        private String uri;

        public Builder setAlbum(AlbumSimplified album) {
            this.album = album;
            return this;
        }

        public Builder setArtists(ArtistSimplified ... artists) {
            this.artists = artists;
            return this;
        }

        public Builder setAvailableMarkets(CountryCode ... availableMarkets) {
            this.availableMarkets = availableMarkets;
            return this;
        }

        public Builder setDiscNumber(Integer discNumber) {
            this.discNumber = discNumber;
            return this;
        }

        public Builder setDurationMs(Integer durationMs) {
            this.durationMs = durationMs;
            return this;
        }

        public Builder setExplicit(Boolean explicit) {
            this.explicit = explicit;
            return this;
        }

        public Builder setExternalIds(ExternalId externalIds) {
            this.externalIds = externalIds;
            return this;
        }

        public Builder setExternalUrls(ExternalUrl externalUrls) {
            this.externalUrls = externalUrls;
            return this;
        }

        public Builder setHref(String href) {
            this.href = href;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setIsPlayable(Boolean isPlayable) {
            this.isPlayable = isPlayable;
            return this;
        }

        public Builder setLinkedFrom(TrackLink linkedFrom) {
            this.linkedFrom = linkedFrom;
            return this;
        }

        public Builder setRestrictions(Restrictions restrictions) {
            this.restrictions = restrictions;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setPopularity(Integer popularity) {
            this.popularity = popularity;
            return this;
        }

        public Builder setPreviewUrl(String previewUrl) {
            this.previewUrl = previewUrl;
            return this;
        }

        public Builder setTrackNumber(Integer trackNumber) {
            this.trackNumber = trackNumber;
            return this;
        }

        public Builder setType(ModelObjectType type) {
            this.type = type;
            return this;
        }

        public Builder setUri(String uri) {
            this.uri = uri;
            return this;
        }

        @Override
        public Track build() {
            return new Track(this);
        }
    }
}

